/*
 * Decompiled with CFR 0.152.
 */
package us.springett.parsers.cpe;

import us.springett.parsers.cpe.Cpe;
import us.springett.parsers.cpe.exceptions.CpeParsingException;
import us.springett.parsers.cpe.exceptions.CpeValidationException;
import us.springett.parsers.cpe.util.Convert;
import us.springett.parsers.cpe.values.LogicalValue;
import us.springett.parsers.cpe.values.Part;

public class CpeBuilder {
    private Part part = Part.ANY;
    private String vendor = LogicalValue.ANY.getAbbreviation();
    private String product = LogicalValue.ANY.getAbbreviation();
    private String version = LogicalValue.ANY.getAbbreviation();
    private String update = LogicalValue.ANY.getAbbreviation();
    private String edition = LogicalValue.ANY.getAbbreviation();
    private String language = LogicalValue.ANY.getAbbreviation();
    private String swEdition = LogicalValue.ANY.getAbbreviation();
    private String targetSw = LogicalValue.ANY.getAbbreviation();
    private String targetHw = LogicalValue.ANY.getAbbreviation();
    private String other = LogicalValue.ANY.getAbbreviation();

    protected void reset() {
        this.part = Part.ANY;
        this.vendor = LogicalValue.ANY.getAbbreviation();
        this.product = LogicalValue.ANY.getAbbreviation();
        this.version = LogicalValue.ANY.getAbbreviation();
        this.update = LogicalValue.ANY.getAbbreviation();
        this.edition = LogicalValue.ANY.getAbbreviation();
        this.language = LogicalValue.ANY.getAbbreviation();
        this.swEdition = LogicalValue.ANY.getAbbreviation();
        this.targetSw = LogicalValue.ANY.getAbbreviation();
        this.targetHw = LogicalValue.ANY.getAbbreviation();
        this.other = LogicalValue.ANY.getAbbreviation();
    }

    public CpeBuilder part(Part part) {
        this.part = part;
        return this;
    }

    public CpeBuilder part(String part) throws CpeParsingException {
        this.part = Part.getEnum(part);
        return this;
    }

    public CpeBuilder vendor(String vendor) {
        this.vendor = Convert.toWellFormed(vendor);
        return this;
    }

    public CpeBuilder product(String product) {
        this.product = Convert.toWellFormed(product);
        return this;
    }

    public CpeBuilder version(String version) {
        this.version = Convert.toWellFormed(version);
        return this;
    }

    public CpeBuilder update(String update) {
        this.update = Convert.toWellFormed(update);
        return this;
    }

    public CpeBuilder edition(String edition) {
        this.edition = Convert.toWellFormed(edition);
        return this;
    }

    public CpeBuilder language(String language) {
        this.language = Convert.toWellFormed(language);
        return this;
    }

    public CpeBuilder swEdition(String swEdition) {
        this.swEdition = Convert.toWellFormed(swEdition);
        return this;
    }

    public CpeBuilder targetSw(String targetSw) {
        this.targetSw = Convert.toWellFormed(targetSw);
        return this;
    }

    public CpeBuilder targetHw(String targetHw) {
        this.targetHw = Convert.toWellFormed(targetHw);
        return this;
    }

    public CpeBuilder other(String other) {
        this.other = Convert.toWellFormed(other);
        return this;
    }

    public CpeBuilder vendor(LogicalValue vendor) {
        this.vendor = vendor.getAbbreviation();
        return this;
    }

    public CpeBuilder product(LogicalValue product) {
        this.product = product.getAbbreviation();
        return this;
    }

    public CpeBuilder version(LogicalValue version) {
        this.version = version.getAbbreviation();
        return this;
    }

    public CpeBuilder update(LogicalValue update) {
        this.update = update.getAbbreviation();
        return this;
    }

    public CpeBuilder edition(LogicalValue edition) {
        this.edition = edition.getAbbreviation();
        return this;
    }

    public CpeBuilder language(LogicalValue language) {
        this.language = language.getAbbreviation();
        return this;
    }

    public CpeBuilder swEdition(LogicalValue swEdition) {
        this.swEdition = swEdition.getAbbreviation();
        return this;
    }

    public CpeBuilder targetSw(LogicalValue targetSw) {
        this.targetSw = targetSw.getAbbreviation();
        return this;
    }

    public CpeBuilder targetHw(LogicalValue targetHw) {
        this.targetHw = targetHw.getAbbreviation();
        return this;
    }

    public CpeBuilder other(LogicalValue other) {
        this.other = other.getAbbreviation();
        return this;
    }

    public CpeBuilder wfVendor(String vendor) {
        this.vendor = vendor;
        return this;
    }

    public CpeBuilder wfProduct(String product) {
        this.product = product;
        return this;
    }

    public CpeBuilder wfVersion(String version) {
        this.version = version;
        return this;
    }

    public CpeBuilder wfUpdate(String update) {
        this.update = update;
        return this;
    }

    public CpeBuilder wfEdition(String edition) {
        this.edition = edition;
        return this;
    }

    public CpeBuilder wfLanguage(String language) {
        this.language = language;
        return this;
    }

    public CpeBuilder wfSwEdition(String swEdition) {
        this.swEdition = swEdition;
        return this;
    }

    public CpeBuilder wfTargetSw(String targetSw) {
        this.targetSw = targetSw;
        return this;
    }

    public CpeBuilder wfTargetHw(String targetHw) {
        this.targetHw = targetHw;
        return this;
    }

    public CpeBuilder wfOther(String other) {
        this.other = other;
        return this;
    }

    protected Part getPart() {
        return this.part;
    }

    protected String getVendor() {
        return this.vendor;
    }

    protected String getProduct() {
        return this.product;
    }

    protected String getVersion() {
        return this.version;
    }

    protected String getUpdate() {
        return this.update;
    }

    protected String getEdition() {
        return this.edition;
    }

    protected String getLanguage() {
        return this.language;
    }

    protected String getSwEdition() {
        return this.swEdition;
    }

    protected String getTargetSw() {
        return this.targetSw;
    }

    protected String getTargetHw() {
        return this.targetHw;
    }

    protected String getOther() {
        return this.other;
    }

    public Cpe build() throws CpeValidationException {
        Cpe cpe = new Cpe(this.part, this.vendor, this.product, this.version, this.update, this.edition, this.language, this.swEdition, this.targetSw, this.targetHw, this.other);
        this.reset();
        return cpe;
    }
}

