package org.swift.aop;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;

public class InterfaceProxy<T> implements InvocationHandler {
	private T target;

	public InterfaceProxy(T t) {
		target = t;
	}

	public Object invoke(Object proxy, Method method, Object[] args)
			throws Throwable {
		AOPAdvice annotation = method.getAnnotation(AOPAdvice.class);
		if (annotation != null && annotation.before() != Object.class) {
			Object advice = annotation.before().newInstance();
			if (advice instanceof IBeforeAdvice) {
				((IBeforeAdvice) advice).before(target, method, args);
			}
		}
		Object returnValue = null;
		try {
			returnValue = method.invoke(target, args);
		} catch (Exception e) {
			if (annotation == null || annotation.exception() == Object.class) {
				throw e;
			}
			Object advice = annotation.exception().newInstance();
			if (advice instanceof IExceptionAdvice) {
				returnValue = ((IExceptionAdvice) advice).exception(target,
						method, args, e);
			} else {
				throw e;
			}
		}
		if (annotation != null && annotation.after() != Object.class) {
			Object advice = annotation.after().newInstance();
			if (advice instanceof IAfterAdvice) {
				((IAfterAdvice) advice).after(target, method, args, returnValue);
			}
		}
		return returnValue;
	}
}
