package org.swift.app;

public class ConsoleHook extends Thread {

	private static IConsoleHookCallback callbackHook = null;
	private static boolean exit = false;
	private static Object sync = new Object();

	public static void install(IConsoleHookCallback callback) {
		callbackHook = callback;
		Runtime.getRuntime().addShutdownHook(new ConsoleHook());
	}

	public static boolean waitForShutdown(long timeout) {
		try {
			synchronized (sync) {
				sync.wait(timeout);
			}
		} catch (InterruptedException e) {
			e.printStackTrace();
		}

		return exit;
	}

	@Override
	public void run() {
		synchronized (sync) {
			exit = true;

			if (callbackHook != null)
				callbackHook.onShutdown();

			sync.notify();
		}
	}
}