package org.swift.bean;

import org.swift.util.IConfig;
import org.swift.util.UtilEnv;
import org.swift.util.impl.Config;
import org.swift.util.impl.StreamResource;


public class BeanEnv {

	private static IConfig utilBeanConfig;
	private static IConfig beanConfig;

	/**
	 * 功能描述：对象创建配置
	 * 
	 * @return
	 */
	public static IConfig getUtilBeanConfig() {
		if (utilBeanConfig == null) {
			synchronized (UtilEnv.class) {
				if (utilBeanConfig == null) {
					utilBeanConfig = new Config(new StreamResource(UtilEnv.class
							.getResourceAsStream("/org/swift/util/beans.prop")));
				}
			}
		}
		return utilBeanConfig;
	}

	/**
	 * 功能描述：默认的对象创建配置
	 * 
	 * @return
	 */
	public static IConfig getBeanConfig() {
		if (beanConfig == null) {
			synchronized (UtilEnv.class) {
				if (beanConfig == null) {
					beanConfig = new Config(new StreamResource(UtilEnv.class
							.getResourceAsStream("/beans.prop")));
				}
			}
		}
		return beanConfig;
	}
}
