package org.swift.bean;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.TreeMap;

import org.swift.util.IConfig;


/**
 * 
 * 功能描述：对象工厂，根据配置创建对象。
 * 
 */
public class BeanFactory<T> {
	private IConfig config;
	private Map<String, Constructor<?>> constructors;
	private Map<String, Method> methods;
	private Class<?> clazz;

	/**
	 * 按指定配置创建
	 * 
	 * @param config
	 */
	public BeanFactory(Class<?> clazz, IConfig config) {
		this.clazz = clazz;
		this.config = config;
		constructors = new TreeMap<String, Constructor<?>>();
		methods = new TreeMap<String, Method>();
	}

	/**
	 * 默认配置文件在ClassPath的根目录
	 */
	public BeanFactory(Class<?> clazz) {
		this(clazz, BeanEnv.getBeanConfig());
	}

	/**
	 * 功能描述：按名称找到类并找到默认构造函数创建实例
	 * 
	 * @param name
	 * @return
	 */
	public T New(String name) {
		Class<?>[] classes = {};
		Object[] objects = {};
		return New(name, classes, objects);
	}

	/**
	 * 功能描述：用类的简单名称找到类并找到默认构造函数创建实例
	 * 
	 * @param clazz
	 * @return
	 */
	public T New() {
		Class<?>[] classes = {};
		Object[] objects = {};
		return New(classes, objects);
	}

	/**
	 * 功能描述：按名称找到类，按参数类型找到构造函数创建实例
	 * 
	 * @param name
	 * @param classes
	 * @param objects
	 * @return
	 */
	@SuppressWarnings("unchecked")
	public T New(String name, Class<?>[] classes, Object[] objects) {
		String key = config.toString() + "->" + name + ".<init>(";
		if (classes != null) {
			for (Class<?> clazz : classes) {
				key += clazz.getSimpleName() + ",";
			}
		}
		key += ")";
		if (constructors.containsKey(key)) {
			try {
				return (T) constructors.get(key).newInstance(objects);
			} catch (Exception e) {
				System.err.println("new Object by Constructor " + key + " failed");
				e.printStackTrace();
				return null;
			}
		}
		String clazzName = config.getString(name);
		Class<?> clazz = null;
		try {
			clazz = (Class<?>) Class.forName(clazzName);
		} catch (ClassNotFoundException e) {
			System.err.println("not found Class " + clazzName);
			e.printStackTrace();
			return null;
		}
		Constructor<?> constructor = null;
		try {
			constructor = clazz.getDeclaredConstructor(classes);
		} catch (Exception e) {
			System.err.println("not found Constructor " + key);
			e.printStackTrace();
			return null;
		}
		constructor.setAccessible(true);
		constructors.put(key, constructor);
		try {
			return (T) constructor.newInstance(objects);
		} catch (Exception e) {
			System.err.println("new Object by Constructor " + key + " failed");
			e.printStackTrace();
			return null;
		}
	}

	/**
	 * 功能描述：用类的简单名称找到类并找到默认构造函数创建实例
	 * 
	 * @param clazz
	 * @param classes
	 * @param objects
	 * @return
	 */
	@SuppressWarnings("unchecked")
	public T New(Class<?>[] classes, Object[] objects) {
		String iface = clazz.getSimpleName();
		if (config.getString(iface) == null) {
			config.setString(iface, clazz.getPackage().getName() + ".impl." + iface.substring(1));
		}
		return New(clazz.getSimpleName(), classes, objects);
	}

	/**
	 * 功能描述：调用实例的renew方法
	 * 
	 * @param object
	 * @param classes
	 * @param objects
	 * @return
	 */
	public boolean Renew(Object object, Class<?>[] classes, Object[] objects) {
		String key = config.toString() + "->" + object.getClass().getSimpleName() + ".renew(";
		if (classes != null) {
			for (Class<?> clazz : classes) {
				key += clazz.getSimpleName() + ",";
			}
		}
		key += ")";
		if (methods.containsKey(key)) {
			try {
				return (Boolean) methods.get(key).invoke(object, objects);
			} catch (Exception e) {
				System.err.println("invoke Method " + key + " failed");
				e.printStackTrace();
				return false;
			}
		}
		Class<?> clazz = object.getClass();
		Method method = null;
		try {
			method = clazz.getDeclaredMethod("renew", classes);
		} catch (Exception e) {
			System.err.println("not found Method " + key);
			e.printStackTrace();
			return false;
		}
		method.setAccessible(true);
		methods.put(key, method);
		try {
			return (Boolean) method.invoke(object, objects);
		} catch (Exception e) {
			System.err.println("invoke Method " + key + " failed");
			e.printStackTrace();
			return false;
		}
	}
}
