package org.swift.cache;

import org.swift.bean.BeanEnv;
import org.swift.bean.BeanFactory;

public interface ISoftRefCache<K extends Comparable<K>, V> {
	public class Factory {
		private static BeanFactory<ISoftRefCache<? extends Comparable<?>, ?>> factory = new BeanFactory<ISoftRefCache<? extends Comparable<?>, ?>>(
				ISoftRefCache.class, BeanEnv.getUtilBeanConfig());

		@SuppressWarnings("unchecked")
		public static <K extends Comparable<K>, V> ISoftRefCache<K, V> New() {
			return (ISoftRefCache<K, V>) factory.New();
		}
	}

	/**
	 * 功能描述：真实大小
	 * 
	 * @return
	 */
	int getSize();

	/**
	 * 功能描述：添加缓存数据
	 * 
	 * @param k
	 * @param v
	 */
	V put(K k, V v);

	/**
	 * 功能描述：是否包含Key
	 * 
	 * @param k
	 * @return
	 */
	boolean contains(K k);

	/**
	 * 功能描述：取缓存数据
	 * 
	 * @param k
	 * @return
	 */
	V get(K k);

	/**
	 * 功能描述：删除缓存数据
	 * 
	 * @param k
	 */
	V remove(K k);

	/**
	 * 功能描述：强制删除所有数据
	 * 
	 */
	void clear();

	/**
	 * 功能描述：命中次数
	 * 
	 * @return
	 */
	int getHit();

	/**
	 * 功能描述：没命中次数
	 * 
	 * @return
	 */
	int getMiss();

}
