package org.swift.cache;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;

public class KeySoftReference<K, V> extends SoftReference<V> {

	private K key;

	public KeySoftReference(K key, V referent, ReferenceQueue<? super V> queue) {
		super(referent, queue);
		this.key = key;
	}

	public K getKey() {
		return key;
	}

}
