package org.swift.tools;

public class LinkList<T> {
	private int size;
	private Iterator begin;
	private Iterator end;

	public class Iterator {
		private Iterator previous;
		private Iterator next;
		private T t;

		Iterator(T t, Iterator previous, Iterator next) {
			this.t = t;
			this.previous = previous;
			this.next = next;
		}

		public boolean hasNext() {
			return next != null;
		}

		public boolean hasPrevious() {
			return previous != null;
		}

		public Iterator next() {
			return next;
		}

		public Iterator previous() {
			return previous;
		}

		public T get() {
			return t;
		}

		public void set(T t) {
			this.t = t;
		}

		public void addPrevious(T t) {
			Iterator it = new Iterator(t, previous, this);
			if (previous != null) {
				previous.next = it;
			} else {
				begin = it;
			}
			previous = it;
			size++;
		}

		public void addNext(T t) {
			Iterator it = new Iterator(t, this, next);
			if (next != null) {
				next.previous = it;
			} else {
				end = it;
			}
			next = it;
			size++;
		}

		public void remove() {
			if (previous == null && next == null) {
				begin = null;
				end = null;
			} else if (previous == null) {
				next.previous = null;
				begin = next;
			} else if (next == null) {
				previous.next = null;
				end = previous;
			} else {
				previous.next = next;
				next.previous = previous;
			}
			size--;
		}
	}

	public Iterator begin() {
		return begin;
	}

	public Iterator end() {
		return end;
	}

	public T first() {
		if (begin == null) {
			return null;
		}
		return begin.get();
	}

	public T last() {
		if (end == null) {
			return null;
		}
		return end.get();
	}

	public void addFirst(T t) {
		if (begin == null) {
			begin = new Iterator(t, null, null);
			end = begin;
			size++;
		} else {
			begin.addPrevious(t);
		}
	}

	public void addLast(T t) {
		if (end == null) {
			end = new Iterator(t, null, null);
			begin = end;
			size++;
		} else {
			end.addNext(t);
		}
	}

	public T removeFirst() {
		if (begin == null) {
			return null;
		}
		T t = begin.get();
		begin.remove();
		return t;
	}

	public T removeLast() {
		if (end == null) {
			return null;
		}
		T t = end.get();
		end.remove();
		return t;
	}

	public boolean remove(T t) {
		if (begin == null) {
			return false;
		}
		Iterator it = begin;
		do {
			if (it.get().equals(t)) {
				it.remove();
				return true;
			}
			it = it.next;
		} while (it.hasNext());
		return false;
	}

	public int size() {
		return size;
	}

	public boolean isEmpty() {
		return size == 0;
	}

	public void clear() {
		size = 0;
		begin = null;
		end = null;
	}

	@Override
	public String toString() {
		StringBuffer buffer = new StringBuffer("[");
		boolean first = true;
		for (Iterator it = begin; it != null; it = it.next()) {
			if (first) {
				first = false;
			} else {
				buffer.append(" ,");
			}
			buffer.append(it.get().toString());
		}
		buffer.append("]");
		return buffer.toString();
	}

	public static void main(String[] args) {
		LinkList<String> list = new LinkList<String>();
		list.addLast("A");
		LinkList<String>.Iterator ita = list.end();
		list.addLast("B");
		LinkList<String>.Iterator itb = list.end();
		list.addLast("C");
		LinkList<String>.Iterator itc = list.end();
		list.addLast("D");
		list.addFirst("E");
		LinkList<String>.Iterator ite = list.begin();
		list.addFirst("F");
		LinkList<String>.Iterator itf = list.begin();
		System.out.println(list.toString());
		System.out.println(ita.get().toString());
		System.out.println(itb.get().toString());
		System.out.println(itc.get().toString());
		System.out.println(ite.get().toString());
		System.out.println(itf.get().toString());
	}

}
