package org.swift.tools;

import java.util.Calendar;
import java.util.GregorianCalendar;

/**
 * 功能描述：月份接口的实现
 * 
 * 修改记录： 2009.03.04 重写了equals方法
 */
public class Month {

	private int date;

	public Month() {
		this.date = (int) (System.currentTimeMillis() / 1000);
	}

	public Month(int date) {
		this.date = date;
	}

	public int getFirstTime() {
		Calendar c = Calendar.getInstance();
		c.setTimeInMillis((long) date * 1000);
		Calendar stdCal = new GregorianCalendar(c.get(Calendar.YEAR), c.get(Calendar.MONTH), 1);
		return (int) (stdCal.getTimeInMillis() / 1000);
	}

	public String getYearMonth() {
		Calendar c = Calendar.getInstance();
		c.setTimeInMillis((long) date * 1000);
		String m = "";
		int intm = c.get(Calendar.MONTH) + 1;
		if ((c.get(Calendar.MONTH) + 1) < 10)
			m += "0" + intm;
		else
			m = intm + "";
		return String.valueOf(c.get(Calendar.YEAR)) + m;
	}

	public Month next() {
		Calendar c = Calendar.getInstance();
		c.setTimeInMillis((long) date * 1000);
		int currMonth = c.get(Calendar.MONTH);
		int currYear = c.get(Calendar.YEAR);
		if (currMonth + 2 > 12) {// 月份从0月开始
			currYear += 1;
			currMonth = 0;
		} else {
			currMonth += 1;
		}
		Calendar stdCal = new GregorianCalendar(currYear, currMonth, 1);
		return new Month((int) (stdCal.getTimeInMillis() / 1000));
	}

	public Month previous() {
		Calendar c = Calendar.getInstance();
		c.setTimeInMillis((long) date * 1000);
		int currMonth = c.get(Calendar.MONTH);
		int currYear = c.get(Calendar.YEAR);
		if (currMonth - 1 < 0) {
			currYear -= 1;
			currMonth = 11;
		} else {
			currMonth -= 1;
		}
		Calendar stdCal = new GregorianCalendar(currYear, currMonth, 1);
		return new Month((int) (stdCal.getTimeInMillis() / 1000));
	}

	public boolean equals(Object m) {
		if (m == null)
			return false;
		if (!(m instanceof Month)) {
			return false;
		}
		return this.getYearMonth().equals(((Month) m).getYearMonth());
	}

	@Override
	public int hashCode() {
		return date;
	}

	public int getDate() {
		return date;
	}

	public void setDate(int date) {
		this.date = date;
	}
}
