package org.swift.tools;

import java.util.LinkedHashSet;
import java.util.Set;

import org.swift.func.IObservable;
import org.swift.func.IObserver;

/**
 * 功能描述：一个观察者的列表
 * 
 */
public class ObserverList {
	private Set<IObserver> set;

	public ObserverList() {
		set = new LinkedHashSet<IObserver>();
	}

	/**
	 * 功能描述：添加观察者
	 * 
	 * @param observer
	 */
	public synchronized void add(IObserver observer) {
		set.add(observer);
	}

	/**
	 * 功能描述：删除观察者
	 * 
	 * @param observer
	 */
	public synchronized void remove(IObserver observer) {
		set.remove(observer);
	}

	/**
	 * 功能描述：清空观察者
	 * 
	 */
	public synchronized void clear() {
		set.clear();
	}

	/**
	 * 功能描述：列表大小
	 * 
	 * @return
	 */
	public int size() {
		return set.size();
	}

	/**
	 * 功能描述：通知所有的观察者
	 * 
	 * @param observable
	 */
	public void notify(IObservable observable) {
		IObserver[] observers;
		synchronized (this) {
			observers = new IObserver[set.size()];
			observers = set.toArray(observers);
		}
		if (observers == null) {
			return;
		}
		for (IObserver observer : observers) {
			if (observer == null) {
				continue;
			}
			observer.onSubjectUpdate(observable);
		}
	}
}
