package org.swift.tools;

import java.util.List;

/**
 * 功能描述：分页接口的实现
 * 
 * 修改记录： 2009.03.02 list在类的内部创建 2009.03.04 list在类的外部创建（测试用例有冲突导致两次的修改）
 * 2009.03.04 当外面没有传入list对象，那么调用getListSize方法返回0 2009.03.10 当分页参数为0或小于0时，不分页
 */
public class Paging<T> {

	private List<T> list;
	private int page;
	private int pageSize;
	private long total;

	public List<T> getList() {
		return list;
	}

	public int getListSize() {
		if (list == null)
			return 0;
		return list.size();
	}

	public int getPage() {
		return page;
	}

	public int getPageSize() {
		return pageSize;
	}

	public long getTotal() {
		return total;
	}

	public void setList(List<T> list) {
		this.list = list;
	}

	public void setPage(int page) {
		this.page = page;
	}

	public void setPageSize(int size) {
		this.pageSize = size;
	}

	public void setTotal(long total) {
		this.total = total;
	}

	public String getLimitInfo() {
		if (page <= 0 || pageSize <= 0)
			return "";
		String info = " limit ";
		info += (page - 1) * pageSize + ",";
		info += pageSize + "";
		return info;
	}

}
