package org.swift.tools;

public class ResultReasonException extends Exception {
	private static final long serialVersionUID = -9008196796519898442L;
	private Enum<?> reason;
	private String log;

	public ResultReasonException(Enum<?> reason) {
		this.reason = reason;
	}

	public ResultReasonException(Enum<?> reason, String log) {
		this.reason = reason;
		this.log = log;
	}

	public Enum<?> getResultReason() {
		return this.reason;
	}

	@Override
	public String toString() {
		return super.toString() + "(" + this.reason + ") at Thread<"
				+ Thread.currentThread().getId() + "("
				+ Thread.currentThread().getName() + ")> "
				+ (log == null ? "" : log);
	}
}
