package org.swift.tools;

/**
 * 功能描述：定时锁，在指定时长内是锁住的，到时自动解开。当然也能手动解锁或再加锁。
 * 
 */
public class TimeLock {
	private long time;
	private long length;
	private Lock lock;

	public TimeLock(long ms) {
		lock = new Lock();
		length = ms;
		reset();
	}

	public boolean isLocked() {
		if (System.currentTimeMillis() - time < length) {
			return true;
		}
		return lock.isLocked();
	}

	public void lock() {
		lock.lock();
	}

	public void unlock() {
		lock.unlock();
	}

	public void reset() {
		time = System.currentTimeMillis();
	}

}
