package org.swift.util;

import java.util.Map;
import java.util.Set;

import org.swift.bean.BeanEnv;
import org.swift.bean.BeanFactory;


/**
 * 
 * 功能描述：配置信息接口
 * 
 */
public interface IConfig {

	public class Factory {
		private static BeanFactory<IConfig> factory = new BeanFactory<IConfig>(IConfig.class,
				BeanEnv.getUtilBeanConfig());

		public static IConfig New(IResource resource) {
			Class<?>[] pType = { IResource.class };
			Object[] pValue = { resource };
			return factory.New(pType, pValue);
		}
	}

	IResource getResource();

	@Deprecated
	void checkModification();

	boolean checkModifyAndReload();

	void deleteKey(String key);

	void deleteKey(String section, String key);

	void deleteSection();

	void deleteSection(String section);

	Map<String, String> getAllValues();

	Map<String, String> getAllValues(String section);

	boolean getBoolean(String key);

	boolean getBoolean(String key, boolean dflt);

	boolean getBoolean(String section, String key, boolean dflt);

	String getDefaultSection();

	double getDouble(String key);

	double getDouble(String key, double dflt);

	double getDouble(String section, String key, double dflt);

	float getFloat(String key);

	float getFloat(String key, float dflt);

	float getFloat(String section, String key, float dflt);

	int getInt(String key);

	int getInt(String key, int dflt);

	int getInt(String section, String key, int dflt);

	Set<String> getKeys();

	Set<String> getKeys(String section);

	long getLong(String key);

	long getLong(String key, long dflt);

	long getLong(String section, String key, long dflt);

	Set<String> getSections();

	String getString(String key);

	String getString(String key, String dflt);

	String getString(String section, String key, String dflt);

	boolean hasKey(String key);

	boolean hasKey(String section, String key);

	boolean save();

	void setBoolean(String key, boolean value);

	void setBoolean(String section, String key, boolean value);

	void setDefaultSection(String section);

	void setDouble(String key, double value);

	void setDouble(String section, String key, double value);

	void setFloat(String key, float value);

	void setFloat(String section, String key, float value);

	void setInt(String key, int value);

	void setInt(String section, String key, int value);

	void setLong(String key, long value);

	void setLong(String section, String key, long value);

	void setString(String key, String value);

	void setString(String section, String key, String value);
}
