package org.swift.util;

import org.swift.bean.BeanEnv;
import org.swift.bean.BeanFactory;

/**
 * 
 * 功能描述：http访问器接口
 * 
 */
public interface IHttpAccesser {

	public class Factory {
		private static BeanFactory<IHttpAccesser> factory = new BeanFactory<IHttpAccesser>(
				IHttpAccesser.class, BeanEnv.getUtilBeanConfig());

		/**
		 * 功能描述：得到IHttpAccesser实例
		 * 
		 * @return
		 */
		public static IHttpAccesser New(IResource resource, int threadCount,
				IThreadPool pool) {
			if (pool == null || !pool.isStart()) {
				return null;
			}
			Class<?>[] pType = { IResource.class, int.class, IThreadPool.class };
			Object[] pValue = { resource, threadCount, pool };
			return factory.New(pType, pValue);
		}
	}

	/**
	 * 
	 * 功能描述：同步访问http，直接使用WebClient返回得到的数据。访问失败返回null
	 * 
	 * @param url
	 * @return
	 * 
	 */
	String access(String url);

	/**
	 * 功能描述：异步访问http,把 url放到队列中。没启动直接返回false，不放入队列。
	 * 
	 * @param url
	 * @param failedCount
	 *            失败次数，超过次数的url就会被丢掉
	 * @return
	 */
	boolean notify(String url, int failedCount);

}
