package org.swift.util;

import org.swift.bean.BeanFactory;


/**
 * 
 * 功能描述：日志记录器
 * 
 * 可支付把日志写到数据库
 * 
 * 日志在数据库中有分类，每种分类保存一定数量的记录
 * 
 * 默认的分类是default
 */
public interface ILogger {
	class Factory {
		private static BeanFactory<ILogger> factory = new BeanFactory<ILogger>(
				ILogger.class);

		public static ILogger New(String log4jName) {
			Class<?>[] pType = { String.class };
			Object[] pValue = { log4jName };
			return factory.New(pType, pValue);
		}
	}

	static final String DEFAULT_TYPE = "default";
	static final String EXCEPTION = "exception";

	/**
	 * 功能描述：设置一个一定等级的sql执行器用于记录日志
	 * 
	 * @param executer
	 * @param table
	 * @param level
	 */
	void setSqlExecuter(ISqlExecuter executer);

	void fatal(String action, boolean result, String other);

	void fatal(Exception exception);

	void error(String action, boolean result, String other);

	void error(Exception exception);

	void warn(String action, boolean result, String other);

	void warn(Exception exception);

	void info(String action, boolean result, String other);

	void info(Exception exception);

	void debug(String action, boolean result, String other);

	void debug(Exception exception);

	void fatal(String type, String action, boolean result, String other);

	void fatal(String type, Exception exception);

	void error(String type, String action, boolean result, String other);

	void error(String type, Exception exception);

	void warn(String type, String action, boolean result, String other);

	void warn(String type, Exception exception);

	void info(String type, String action, boolean result, String other);

	void info(String type, Exception exception);

	void debug(String type, String action, boolean result, String other);

	void debug(String type, Exception exception);
}
