package org.swift.util;

import org.swift.bean.BeanEnv;
import org.swift.bean.BeanFactory;

/**
 * 功能描述：项目信息接口（项目目录结构已定）
 * 
 * Web项目：project/WEB-INF/lib；project/WEB-INF/classes
 * Main项目：project/lib；project/bin
 * 
 */
public interface IProject {
	public class Factory {
		private static BeanFactory<IProject> factory = new BeanFactory<IProject>(IProject.class,
				BeanEnv.getUtilBeanConfig());

		public static IProject New() {
			return factory.New();
		}
	}

	/**
	 * 功能描述：项目名
	 * 
	 * @return
	 */
	String getName();

	/**
	 * 功能描述：项目所以目录
	 * 
	 * @return
	 */
	String getPath();

	/**
	 * 功能描述：是否是web项目
	 * 
	 * @return
	 */
	boolean isWebProject();
}
