package org.swift.util;

import javax.servlet.http.HttpServletRequest;

import org.swift.bean.BeanFactory;


/**
 * 
 * 功能描述：请求参数处理
 */
public interface IRequestParams {
	class Factory {
		private static BeanFactory<IRequestParams> factory = new BeanFactory<IRequestParams>(
				IRequestParams.class);

		public static IRequestParams New(HttpServletRequest request) {
			Class<?>[] pType = { HttpServletRequest.class };
			Object[] pValue = { request };
			return factory.New(pType, pValue);
		}
	}
	
	String getIp();

	/**
	 * 功能描述：取查询字符串
	 * 
	 * @return
	 */
	String getQueryString();

	/**
	 * 功能描述：按编码取查询字符串
	 * 
	 * @param enc
	 * @return
	 */
	String getQueryString(String enc);

	/**
	 * 功能描述：取请求参数
	 * 
	 * @param key
	 * @return
	 */
	String getParameter(String key);

	/**
	 * 功能描述：按编码取请求参数
	 * 
	 * @param key
	 * @param enc
	 * @return
	 */
	String getParameter(String key, String enc);
}
