package org.swift.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;

import org.swift.bean.BeanEnv;
import org.swift.bean.BeanFactory;


/**
 * 功能描述：资源接口
 * 
 */
public interface IResource {

	public class Factory {
		private static BeanFactory<IResource> factory = new BeanFactory<IResource>(IResource.class,
				BeanEnv.getUtilBeanConfig());

		public static IResource New(InputStream stream) {
			Class<?>[] pType = { InputStream.class };
			Object[] pValue = { stream };
			return factory.New(IResource.class.getSimpleName() + "_stream", pType, pValue);
		}

		public static IResource New(String file) {
			Class<?>[] pType = { String.class };
			Object[] pValue = { file };
			return factory.New(IResource.class.getSimpleName() + "_file", pType, pValue);
		}

		public static IResource New(File file) {
			Class<?>[] pType = { File.class };
			Object[] pValue = { file };
			return factory.New(IResource.class.getSimpleName() + "_file", pType, pValue);
		}

		public static IResource New(String dbName, String tabName) {
			Class<?>[] pType = { String.class, String.class };
			Object[] pValue = { dbName, tabName };
			return factory.New(IResource.class.getSimpleName() + "_db", pType, pValue);
		}
	}

	enum OpenMode {
		/**
		 * 只读
		 */
		ReadOnly,
		/**
		 * 只写
		 */
		WriteOnly,
		/**
		 * 只写(追加)
		 */
		AppendOnly,
		/**
		 * 读写
		 */
		ReadWrite,
		/**
		 * 读写(追加)
		 */
		ReadApped
	}

	/**
	 * 功能描述：资源是否存在
	 * 
	 * @return
	 */
	boolean exists();

	/**
	 * 功能描述：打开资源
	 * 
	 * @throws IOException
	 */
	void open(OpenMode mode) throws IOException;

	/**
	 * 功能描述：关闭资源
	 * 
	 */
	void close() throws IOException;

	/**
	 * 功能描述：读取一个对象T，读到末尾返回null
	 * 
	 * 如资源已经被打开为写状态，并还没关闭，此时读会抛出IOException
	 * 
	 * @return
	 */
	String read() throws IOException;

	/**
	 * 功能描述：写入一个对象t
	 * 
	 * 如资源已经被打开为读状态，并还没关闭，此时写会抛出IOException
	 * 
	 * 资源打开后首次写入时，会先把资源清空后再写入
	 * 
	 * @param t
	 */
	void write(String t) throws IOException;

	/**
	 * 功能描述：刷新缓冲
	 * 
	 * @throws IOException
	 */
	void flush() throws IOException;

	/**
	 * 功能描述：获取资源地址
	 * 
	 * @return
	 */
	String getAddress();

	/**
	 * 功能描述：检查是否被修改
	 * 
	 * @return
	 */
	boolean checkModification();
}
