package org.swift.util;

import org.swift.bean.BeanEnv;
import org.swift.bean.BeanFactory;
import org.swift.func.ILock;


/**
 * 功能描述：sql执行器
 */
public interface ISqlExecuter {

	public class Factory {
		private static BeanFactory<ISqlExecuter> factory = new BeanFactory<ISqlExecuter>(
				ISqlExecuter.class, BeanEnv.getUtilBeanConfig());

		/**
		 * 功能描述：得到一个异步sql执行器实例
		 * 
		 * 指定了一个存放未执行的sql的资源
		 * 
		 * 启动时从资源中读入未执行的sql，清空资源
		 * 
		 * 在停止时还要把未执行的sql存入资源
		 * 
		 * @param dbname
		 * @return
		 */
		public static ISqlExecuter New(String dbname, IResource resource,
				IThreadPool pool) {
			if (pool == null || !pool.isStart()) {
				return null;
			}
			Class<?>[] pType = { String.class, IResource.class,
					IThreadPool.class };
			Object[] pValue = { dbname, resource, pool };
			ISqlExecuter executer = factory.New(pType, pValue);
			return executer;
		}
	}

	/**
	 * 
	 * 功能描述： 更新，对异步更新可加锁提交安全性
	 * 
	 * 添加成功时加锁，在sql执行成功后解锁
	 * 
	 * @param sql
	 * @param lock
	 * @return
	 * 
	 */
	boolean update(String sql, ILock lock);

	boolean update(String sql, Object lock);

	/**
	 * 功能描述：异步执行存储过程，可加锁提交安全性
	 * 
	 * @param sql
	 * @param lock
	 * @return
	 */
	boolean call(String sql, ILock lock);

	boolean call(String sql, Object lock);

}
