package org.swift.util;

import org.swift.bean.BeanEnv;
import org.swift.bean.BeanFactory;
import org.swift.func.IProcessor;


/**
 * 功能描述：线程池，线程数按需自动改变，所有任务在会在线程关闭时自动退出
 */
public interface IThreadPool {

	public class Factory {
		private static BeanFactory<IThreadPool> factory = new BeanFactory<IThreadPool>(
				IThreadPool.class, BeanEnv.getUtilBeanConfig());

		public static IThreadPool New() {
			return factory.New();
		}
	}

	/**
	 * 功能描述：启动线程池
	 */
	void start();

	/**
	 * 功能描述：关闭线程池
	 */
	void stop();

	/**
	 * 功能描述：是否已经启动
	 * 
	 * @return
	 */
	boolean isStart();

	/**
	 * 功能描述：添加单线程执行任务
	 * 
	 * @param processor
	 * @return
	 */
	boolean addWorker(IProcessor processor);

	/**
	 * 功能描述：添加多线程执行任务
	 * 
	 * @param processor
	 * @param threadCount
	 * @return
	 */
	boolean addWorkers(IProcessor processor, int threadCount);
}
