package org.swift.util;

import org.swift.bean.BeanEnv;
import org.swift.bean.BeanFactory;

/**
 * 功能描述：Web项目发布环境
 * 
 */
public interface IWebEnv {
	public class Factory {
		private static BeanFactory<IWebEnv> factory = new BeanFactory<IWebEnv>(IWebEnv.class,
				BeanEnv.getUtilBeanConfig());

		public static IWebEnv New(IConfig config, String name) {
			Class<?>[] pType = { IConfig.class, String.class };
			Object[] pValue = { config, name };
			return factory.New(pType, pValue);
		}
	}

	String PROTOCOL = "protocol";
	String HOST = "host";
	String PORT = "port";
	String PATH = "path";

	/**
	 * 功能描述：取协议，默认是http
	 * 
	 * @return
	 */
	String getProtocol();

	/**
	 * 功能描述：取域名，默认是localhost
	 * 
	 * @return
	 */
	String getHost();

	/**
	 * 功能描述：取端口，默认是80
	 * 
	 * @return
	 */
	String getPort();

	/**
	 * 功能描述：取地址，默认是/
	 * 
	 * @return
	 */
	String getPath();

	/**
	 * 功能描述：取完整的发布环境url，如端口是80就省略
	 * 
	 * @return
	 */
	String getUrl();
}
