package org.swift.util;

import java.io.File;

/**
 * 功能描述：包的环境
 * 
 */
public class UtilEnv {
	private static IConfig mainConfig;
	private static IConfig envConfig;
	private static IProject project;

	/**
	 * 功能描述：获取当前项目信息
	 * 
	 * @return
	 */
	public static IProject getProject() {
		if (project == null) {
			synchronized (UtilEnv.class) {
				if (project == null) {
					project = IProject.Factory.New();
				}
			}
		}
		return project;
	}

	/**
	 * 功能描述：主配置文件配置信息
	 * 
	 * @return
	 */
	public static IConfig getMainConfig() {
		if (mainConfig == null) {
			synchronized (UtilEnv.class) {
				if (mainConfig == null) {
					IProject project = getProject();
					String fName = project.getPath() + project.getName() + ".prop";
					System.out.println(fName);
					IResource resource = IResource.Factory.New(fName);
					mainConfig = IConfig.Factory.New(resource);
				}
			}
		}
		return mainConfig;
	}

	/**
	 * 功能描述：获取发布环境配置信息
	 * 
	 * 在主配置文件的configfile段下的envfile配置，内容是“项目名_env.prop”
	 * 
	 * @return
	 */
	public static IConfig getEnvConfig() {
		if (envConfig == null) {
			synchronized (UtilEnv.class) {
				if (envConfig == null) {
					IConfig config = getMainConfig();
					IProject project = getProject();
					String envFile = config.getString("configfile", "envfile", project.getName() + "_env.prop");
					IResource result = IResource.Factory.New(envFile);
					if (!result.exists()) {
						result = IResource.Factory.New(new File(config.getResource().getAddress()).getParent() + File.separator + envFile);
					}
					envConfig = IConfig.Factory.New(result);
				}
			}
		}
		return envConfig;
	}
}
