package org.swift.util.datetime;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;


/**
 * 时间处理，已不建议使用，由FormatTime替代<br>
 * 鲍庆丰<br>
 *  模板定义如下：<br>
    y        年号，如 1996<br>
    M        月份，如 July 或者 07<br>
    d        月中第几天，如 12<br>
    H        小时(24制)，如 0、17<br>
    m        分钟,如 32<br>
    s        钞钟，如55<br>
    S        微钞，如978<br>
    E        星期几，如 Tuesday<br>
    D        一年中的第几天，如 189<br>
    w        week in year            (Number)            27<br>
    W        week in month          (Number)            2<br>
    a        am/pm marker            (Text)              PM<br>
    k        hour in day (1~24)      (Number)            24<br>
    K        hour in am/pm (0~11)    (Number)            0<br>
    z        time zone              (Text)              Pacific Standard Time<br>
    '        escape for text        (Delimiter)<br>
    ''      single quote            (Literal)          '<br>
 * baoqingfeng@gmail.com<br>
 */
@Deprecated
public class CTime {

	/**
     * @param args
     * @throws ParseException
     */
    public static void main(String[] args) throws ParseException {
        Long l = (1000L * 60L * 60L * 25L * 30L * 12L);
        System.out.println(getTimeStrByLongTime(l));
        System.out.println(getFormatTimeStrFromLongTime(12345222,
                "yyyy年MM月dd日HH时mm分ss秒"));

        //System.out.println(getTimeFormatFromDate(getTimeAddTime(0,-1),"yyyy-MM-01"));
    }
    /**
     * @param time
     * 		长整型的时间戳
     * @param pattern
     * 		格式
     * @return long时间转换为格式化String时间
     */
    public static String getFormatTimeStrFromLongTime(long time, String pattern) {
        SimpleDateFormat sdf = new SimpleDateFormat(pattern);
        Date dtTime = new Date(time);

        return sdf.format(dtTime);
    }

    /**
     * @param date
     * 		日期
     * @param pattern
     * 		格式
     * @return Date时间转换为格式化Date时间
     * @throws ParseException
     */
    public static Date getFormatDateFromDate(Date date, String pattern)
        throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat(pattern);

        return sdf.parse(sdf.format(date));
    }

    /**
     * @param format
     * 		格式
     * @return 今天的格式化String时间
     */
    public static String getFormatTodayTimeStr(String format) {
        Date time = new Date();
        SimpleDateFormat dateformatter = new SimpleDateFormat(format);
        String dateString = dateformatter.format(time);

        return dateString;
    }

    /**
     * 例：getFormatTimeStrAddTime("...",Calendar.HOUR,3) 表示距离现在三小时后的时间
     * @param format
     * 		格式
     * @param field
     * 		域，例：Calendar.HOUR
     * @param add_days
     * 		多出来的数量
     * @return 距今天一定时间后的格式化String时间
     */
    public static String getFormatTimeStrAddTime(String format, int field,
        int add_days) {
        Calendar time = Calendar.getInstance();
        time.add(field, add_days);

        SimpleDateFormat dateformatter = new SimpleDateFormat(format);
        String dateString = dateformatter.format(time.getTime());

        return dateString;
    }

    /**
     * @param format
     * 		格式
     * @param add_days
     * 		多出来的数量
     * @return 格式化时间，时间为距几天天数
     */
    public static String getFormatTimeStrAddDays(String format, int add_days) {
        Calendar time = Calendar.getInstance();
        time.add(Calendar.DATE, add_days);

        SimpleDateFormat dateformatter = new SimpleDateFormat(format);
        String dateString = dateformatter.format(time.getTime());

        return dateString;
    }
    
    /**
     * @param format
     * 		格式
     * @param add_months
     * 		多出来的月份
     * @return 格式化后时间，时间为距今天月数
     */
    public static String getFormatTimeStrAddMonths(String format, int add_months) {
        Calendar time = Calendar.getInstance();
        time.add(Calendar.MONTH, add_months);

        SimpleDateFormat dateformatter = new SimpleDateFormat(format);
        String dateString = dateformatter.format(time.getTime());

        return dateString;
    }

   /**
     * 
	 * @param date
	 * 		Date类型的日期
	 * @param format
	 * 		格式
	 * @param add_days
	 * 		加上的天数
	 * @return String时间转化为Date时间，并加上一定天数
	 * @throws ParseException
	 */
	public static Date getFormatTimeAddDaysFromDateStr(String date,
	       String format, int add_days) throws ParseException {
	       SimpleDateFormat dateformatter = new SimpleDateFormat(format);
	       Date dateString = dateformatter.parse(date);
	       Calendar time = Calendar.getInstance();
	       time.setTime(dateString);
	       time.add(Calendar.DATE, add_days);
	
	       return time.getTime();
	   }

   /**
   *
   */
  /**
	 * @param date
	 * 		日期
	 * @param format
	 * 		格式
	 * @param add_months
	 * 		加上的月份
	 * @return String时间转化为Date时间，并加上一定月数
	 * @throws ParseException
	 */
	public static Date getFormatTimeAddMonthFromDateStr(String date,
		String format, int add_months) throws ParseException {
		SimpleDateFormat dateformatter = new SimpleDateFormat(format);
		Date dateString = dateformatter.parse(date);
		Calendar time = Calendar.getInstance();
		time.setTime(dateString);
		time.add(Calendar.MONTH, add_months);

		return time.getTime();
	}

    /**
     * @param format
     * 		格式
     * @param add_days
     * 		多出来的天数
     * @return 距今天一定天数的Date时间
     * @throws ParseException
     */
    public static Date getFormatTimeAddDays(String format, int add_days)
        throws ParseException {
        Calendar time = Calendar.getInstance();
        time.add(Calendar.DATE, add_days);

        SimpleDateFormat dateformatter = new SimpleDateFormat(format);
        String date = dateformatter.format(time.getTime());

        return dateformatter.parse(date);
    }

    /**
     * @param format
     * 		格式
     * @param add_months
     * 		多出来的月份
     * @return 距今天一定月数的Date时间
     * @throws ParseException
     */
    public static Date getFormatTimeAddMonths(String format, int add_months)
        throws ParseException {
        Calendar time = Calendar.getInstance();
        time.add(Calendar.MONTH, add_months);

        SimpleDateFormat dateformatter = new SimpleDateFormat(format);
        String date = dateformatter.format(time.getTime());

        return dateformatter.parse(date);
    }

    /**
     * @param add_days
     * 		多出来的天数
     * @return 距今天一定天数的Date时间
     */
    public static Date getTimeAddDays(int add_days) {
        Calendar time = Calendar.getInstance();
        time.add(Calendar.DATE, add_days);

        return time.getTime();
    }

    /**
     * @param add_months
     * 		多出来的月份
     * @return 距今天一定月数的Date时间
     */
    public static Date getTimeAddMonths(int add_months) {
        Calendar time = Calendar.getInstance();
        time.add(Calendar.MONTH, add_months);

        return time.getTime();
    }

    /**
     * @param date
     * 		时间
     * @param format
     * 		格式
     * @return Date时间格式化马String时间
     */
    public static String getFormatTimeStrFromDate(Date date, String format) {
        SimpleDateFormat dateformatter = new SimpleDateFormat(format);
        String dateString = dateformatter.format(date);

        return dateString;
    }

    /**
     * @param date
     * 		时间
     * @param format
     * 		格式
     * @return 式化的String时间转化为Date时间
     * @throws ParseException
     */
    public static Date getFormatTimeFromDateStr(String date, String format)
        throws ParseException {
        SimpleDateFormat dateformatter = new SimpleDateFormat(format);
        Date dateString = dateformatter.parse(date);

        return dateString;
    }

    /**
     * @param time_misec
     * 		时间截
     * @return 用时时间，12000=12秒
     */
    public static String getTimeStrByLongTime(long time_misec) {
        StringBuffer bu = new StringBuffer(20);
        long parent = time_misec;
        long leav = parent % 1000;

        if (leav != 0) {
            bu.insert(0, leav + "毫秒");
        }

        long child = parent / 1000;

        if (child == 0) {
            return bu.toString();
        }

        leav = child % 60;

        if (leav != 0) {
            bu.insert(0, leav + "秒");
        }

        child = child / 60;

        if (child == 0) {
            return bu.toString();
        }

        leav = child % 60;

        if (leav != 0) {
            bu.insert(0, leav + "分钟");
        }

        child = child / 60;

        if (child == 0) {
            return bu.toString();
        }

        leav = child % 24;

        if (leav != 0) {
            bu.insert(0, leav + "小时");
        }

        child = child / 24;

        if (child == 0) {
            return bu.toString();
        }

        leav = child % 30;

        if (leav != 0) {
            bu.insert(0, leav + "天");
        }

        child = child / 30;

        if (child == 0) {
            return bu.toString();
        }

        leav = child % 12;

        if (leav != 0) {
            bu.insert(0, leav + "月");
        }

        child = child / 12;

        if (child == 0) {
            return bu.toString();
        }

        bu.insert(0, child + "年");

        return bu.toString();
    }

    /**
     * @param time
     * @return 相距时间time参数为年月日时分秒的时间
     */
    public static Date getTimeAddTime(int...time) {
        Calendar now = new GregorianCalendar();

        if ((time == null) || (time.length == 0)) {
            return now.getTime();
        }

        int len = time.length;
        int[] times = time;

        for (int i = 0; i < len; i++) {
            switch (i) {
            case 0:
                now.add(Calendar.YEAR, times[i]);

                break;

            case 1:
                now.add(Calendar.MONTH, times[i]);

                break;

            case 2:
                now.add(Calendar.DATE, times[i]);

                break;

            case 3:
                now.add(Calendar.HOUR, times[i]);

                break;

            case 4:
                now.add(Calendar.MINUTE, times[i]);

            case 5:
                now.add(Calendar.SECOND, times[i]);

                break;
            }
        }

        return now.getTime();
    }

    /**
     * @return 上月第一天的long值
     */
    public static Date getLastMonthFistDay() {
        Calendar now = new GregorianCalendar();
        now.add(Calendar.MONTH, -1);

        Calendar stdCal = new GregorianCalendar(now.get(Calendar.YEAR),
                now.get(Calendar.MONTH), 1);

        return stdCal.getTime();
    }

    /**
     * @return 本月第一天的long值
     */
    public static Date getNowMonthFirstDay() {
        Calendar now = new GregorianCalendar();
        int curYear = now.get(Calendar.YEAR);
        int curMonth = now.get(Calendar.MONTH);

        Calendar stdCal = new GregorianCalendar(curYear, curMonth, 1);

        return stdCal.getTime();
    }
}
