package org.swift.util.encrypt;

import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Random;

/**
 * The AzDGCrypt<br>
 * 一个纯字符串加解密类,加密后数据是字符串<br>
 * 
 * @author 鲍庆丰
 * <br>
 * 
 * System.out.println("Source : " + source + " Key : " + key);<br>
 * String encryptTxt = AzDGCrypt.encrypt(source, key, "gbk"); //按照GBK加密<br>
 * System.out.println("Encypt String : " + encryptTxt);<br>
 * String decryptTxt = AzDGCrypt.decrypt(encryptTxt, key); //解密<br>
 * System.out.println("Decypt String : " + decryptTxt);<br>
 * <br>
 * 
 * byte[] encryptTxt2 = AzDGCrypt.encrypt(source.getBytes(), key.getBytes());
 * //对字节流进行加密<br>
 * System.out.println("Encypt String : " + new String(encryptTxt2));<br>
 * byte[] decryptTxt2 = AzDGCrypt.decrypt(encryptTxt2, key.getBytes()); //解密<br>
 * System.out.println("Decypt String : " + new String(decryptTxt2));<br>
 */
public class AzDGCrypt {

	public static final String KEY = "Test AzDGCrypt";

	/**
	 * 对字节流加密
	 * 
	 * @param txt
	 *            源字节流
	 * @param key
	 *            密钥字节流
	 * @return 加密后字节流
	 */
	public static byte[] encrypt(byte[] txt, byte[] key) {
		int rand = new Random().nextInt(32000);//new Double(Math.random() * 32000).intValue();

		byte[] encrypt_key = Security.MD5(rand + "").toLowerCase().getBytes();

		byte ctr = 0;

		ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
		for (int i = 0, j = 0; i < txt.length; i++, j += 2) {
			ctr = ctr == encrypt_key.length ? 0 : ctr;
			byteOut.write(encrypt_key[ctr]);
			byteOut.write(txt[i] ^ encrypt_key[ctr++]);
		}

		return Base64.encode(encodeKey(byteOut.toByteArray(), key)).getBytes();
	}

	/**
	 * 对字符串加密
	 * 
	 * @param txt
	 *            源字符串
	 * @param key
	 *            密钥
	 * @return 加密后字符串
	 */
	public static String encrypt(String txt, String key) {
		return new String(encrypt(txt.getBytes(), key.getBytes()));
	}

	/**
	 * 对字符串按特定编码加密
	 * 
	 * @param txt
	 *            源字符串
	 * @param key
	 *            密钥
	 * @param encoding
	 *            编码
	 * @return 加密后字符串
	 */
	public static String encrypt(String txt, String key, String encoding) {
		String str = null;
		try {
			str = new String(encrypt(txt.getBytes(encoding), key.getBytes()));
		} catch (UnsupportedEncodingException e) {
			e.printStackTrace();
		}
		return str;
	}

	/**
	 * 解密字节流
	 * 
	 * @param txt
	 *            源字节流
	 * @param key
	 *            密钥
	 * @return 解密后字节流
	 */
	public static byte[] decrypt(byte[] txt, byte[] key) {
		txt = encodeKey(Base64.decode(new String(txt)), key);

		ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
		for (int i = 0; i < txt.length; i++) {
			byte md5 = txt[i];
			byteOut.write(txt[++i] ^ md5);
		}
		return byteOut.toByteArray();
	}

	/**
	 * 解密字符串
	 * 
	 * @param txt
	 *            源字符串
	 * @param key
	 *            密钥
	 * @return 解密后字符串
	 */
	public static String decrypt(String txt, String key) {
		return new String(decrypt(txt.getBytes(), key.getBytes()));
	}

	private static byte[] encodeKey(byte[] txt, byte[] encrypt_key) {

		encrypt_key = Security.MD5(new String(encrypt_key)).toLowerCase()
				.getBytes();

		byte ctr = 0;
		byte[] tmp = new byte[txt.length];
		for (int i = 0; i < txt.length; i++) {
			ctr = ctr == encrypt_key.length ? 0 : ctr;
			tmp[i] = (byte) (txt[i] ^ encrypt_key[ctr++]);
		}
		return tmp;
	}

	public static void main(String[] arg) {
		String source = "阿斯顿发的发12133qezd";
		String key = "Test key";

		System.out.println("Source : " + source + " Key : " + key);
		String encryptTxt = AzDGCrypt.encrypt(source, key, "gbk");
		System.out.println("Encypt String : " + encryptTxt);
		String decryptTxt = AzDGCrypt.decrypt(encryptTxt, key);
		System.out.println("Decypt String : " + decryptTxt);

		byte[] encryptTxt2 = AzDGCrypt.encrypt(source.getBytes(), key
				.getBytes());
		System.out.println("Encypt String : " + new String(encryptTxt2));
		byte[] decryptTxt2 = AzDGCrypt.decrypt(encryptTxt2, key.getBytes());
		System.out.println("Decypt String : " + new String(decryptTxt2));
	}
}
