package org.swift.util.encrypt;

import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;

import java.io.UnsupportedEncodingException;
import java.security.NoSuchAlgorithmException;
import java.security.Security;

/**
 * DES加密的，文件中共有两个方法,加密、解密
 */
public class DES {
	private String Algorithm = "DES";// 加密算法的名称
	private KeyGenerator keygen;// 密钥生成器
	private SecretKey deskey;// 密钥
	private Cipher c;// 密码器
	private byte[] cipherByte;

	/**
	 * 初始化 DES 实例
	 */
	public DES() {
		init();
	}

	public void init() {
		Security.addProvider(new com.sun.crypto.provider.SunJCE());
		try {
			keygen = KeyGenerator.getInstance(Algorithm);
			deskey = keygen.generateKey();
			c = Cipher.getInstance(Algorithm);
		} catch (NoSuchAlgorithmException ex) {
			ex.printStackTrace();
		} catch (NoSuchPaddingException ex) {
			ex.printStackTrace();
		}
	}

	/**
	 * 对 String 进行加密
	 * 
	 * @param str
	 *            要加密的数据
	 * @return 返回加密后的 byte 数组
	 */
	public byte[] createEncryptor(String str) {
		try {
			c.init(Cipher.ENCRYPT_MODE, deskey);// 初始化密码器，用密钥deskey,进入加密模式
			cipherByte = c.doFinal(str.getBytes());// 加密
		} catch (java.security.InvalidKeyException ex) {
			ex.printStackTrace();
		} catch (javax.crypto.BadPaddingException ex) {
			ex.printStackTrace();
		} catch (javax.crypto.IllegalBlockSizeException ex) {
			ex.printStackTrace();
		}
		return cipherByte;
	}

	/**
	 * 对 Byte 数组进行解密
	 * 
	 * @param buff
	 *            要解密的数据
	 * @return 返回加密后的 String
	 */
	public String createDecryptor(byte[] buff) {
		try {
			c.init(Cipher.DECRYPT_MODE, deskey);// 初始化密码器，用密钥deskey,进入解密模式
			cipherByte = c.doFinal(buff);
		} catch (java.security.InvalidKeyException ex) {
			ex.printStackTrace();
		} catch (javax.crypto.BadPaddingException ex) {
			ex.printStackTrace();
		} catch (javax.crypto.IllegalBlockSizeException ex) {
			ex.printStackTrace();
		}
		return (new String(cipherByte));
	}
	
	public static void main(String[] arg) throws UnsupportedEncodingException
	{
		DES des = new DES();
		String Test = "123456";
		 System.out.println("加密前的数据："+Test); 
		 byte[] enc = des.createEncryptor(Test);
		 System.out.println("加密后的数据："+Base64.encode(Test.getBytes())); 
		 System.out.println("加密后的数据："+Base64.encode(enc)); 
		 System.out.println("解密后的数据："+des.createDecryptor(enc)); 
	}
}