package org.swift.util.file;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;

import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipFile;
import org.apache.tools.zip.ZipOutputStream;

/**
 * 生成日期：2007-8-17 上午10:34:29<br>
 * 模块功能描述：文件压缩与解压缩操作<br>
 * <br>
 * 
 * 示例:unZip("e:\\temp\\classes.zip", "e:\\temp", 1); 解压缩到E:\temp目录<br>
 */
public class FileZip {
	
	  private static final int BUFFER = 1024;
	  public static void zip(String baseDir, String fileName, String encode)
	    throws Exception
	  {
	    List fileList = getSubFiles(new File(baseDir));
	    ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(fileName));
	    zos.setEncoding(encode);
	    ZipEntry ze = null;
	    byte[] buf = new byte[1024];
	    int readLen = 0;
	    for (int i = 0; i < fileList.size(); ++i) {
	      File f = (File)fileList.get(i);
	      ze = new ZipEntry(getAbsFileName(baseDir, f));
	      ze.setSize(f.length());
	      ze.setTime(f.lastModified());
	      zos.putNextEntry(ze);
	      InputStream is = new BufferedInputStream(new FileInputStream(f));
	      while ((readLen = is.read(buf, 0, 1024)) != -1) {
	        zos.write(buf, 0, readLen);
	      }
	      is.close();
	    }
	    zos.close();
	  }

	  private static String getAbsFileName(String baseDir, File realFileName)
	  {
	    File real = realFileName;
	    File base = new File(baseDir);
	    String ret = real.getName();
	    while (true) {
	      real = real.getParentFile();
	      if (real == null)
	        break;
	      if (real.equals(base)) {
	        break;
	      }
	      ret = real.getName() + "/" + ret;
	    }
	    return ret;
	  }

	  private static List<File> getSubFiles(File baseDir)
	  {
	    List<File> ret = new ArrayList<File>();
	    File[] tmp = baseDir.listFiles();
	    for (int i = 0; i < tmp.length; ++i) {
	      if (tmp[i].isFile())
	        ret.add(tmp[i]);
	      if (tmp[i].isDirectory())
	        ret.addAll(getSubFiles(tmp[i]));
	    }
	    return ret;
	  }

	  public static void unZip(String ZIP_FILENAME, String unZIP_DIR)
	    throws Exception
	  {
	    ZipFile zfile = new ZipFile(ZIP_FILENAME);
	    Enumeration zList = zfile.getEntries();
	    ZipEntry ze = null;
	    byte[] buf = new byte[1024];
	    while (zList.hasMoreElements()) {
	      ze = (ZipEntry)zList.nextElement();
	      if (ze.isDirectory()) {
	        File f = new File(unZIP_DIR + ze.getName());
	        f.mkdir();
	      }
	      else {
	        OutputStream os = new BufferedOutputStream(new FileOutputStream(getRealFileName(unZIP_DIR, ze.getName())));
	        InputStream is = new BufferedInputStream(zfile.getInputStream(ze));
	        int readLen = 0;
	        while ((readLen = is.read(buf, 0, 1024)) != -1) {
	          os.write(buf, 0, readLen);
	        }
	        is.close();
	        os.close();
	      }
	    }
	    zfile.close();
	  }

	  public static File getRealFileName(String baseDir, String absFileName)
	  {
	    String[] dirs = absFileName.split("/");
	    File ret = new File(baseDir);
	    if (dirs.length > 1) {
	      for (int i = 0; i < dirs.length - 1; ++i) {
	        ret = new File(ret, dirs[i]);
	      }
	      if (!ret.exists())
	        ret.mkdirs();
	      ret = new File(ret, dirs[(dirs.length - 1)]);
	      return ret;
	    }
	    return ret;
	  }
	  
	/**
	 * @param compressFileName
	 *            压缩路径
	 */
	
	
	public static boolean createZip(String compressFileName, String[] args) {
		boolean flag = false;

		try {
			byte[] b = new byte[512];
			ZipOutputStream zout = new ZipOutputStream(new FileOutputStream(compressFileName));

			for (int i = 0; i < args.length; i++) {
				InputStream in = new FileInputStream(args[i]);
				File file = new File(args[i]);
				String filename = file.getName(); // 取得文件名
				// ZipEntry e = new
				// ZipEntry(args[i].replace(File.separatorChar,'/')); //压缩后带路径

				ZipEntry e = new ZipEntry(filename); // 压缩后不带路径
				zout.putNextEntry(e);

				int len = 0;

				while ((len = in.read(b)) != -1) {
					zout.write(b, 0, len);
				}
				in.close();
				zout.closeEntry();
			}

			zout.close();
			flag = true;
		} catch (Exception e) {
			e.printStackTrace();
		}

		return flag;
	}

	/**
	 * @param zipFile
	 *            压缩包路径
	 * @param outFilePath
	 *            解压缩路径
	 * @param mode
	 *            解压缩方式 1:解压缩到当前路径下 否则解压缩到同名目录下
	 * @return 
	 */
	@SuppressWarnings("unchecked")
	public static boolean unZip(String zipFile, String outFilePath, int mode) {
		boolean flag = false;
		DataInputStream dis = null;
		FileOutputStream fos = null;
		try {
			File file = new File(zipFile);
			String fileName = file.getName();

			if (mode == 1) {
				outFilePath += File.separator; // 文件当前路径下
			} else {
				outFilePath += (File.separator + fileName.substring(0, fileName.length() - 4) + File.separator);
			}

			File tmpFileDir = new File(outFilePath);
			if (!tmpFileDir.mkdirs()) {
				return false;
			}

			ZipFile zf = new ZipFile(zipFile);

			byte[] buf = new byte[1024];

			for (Enumeration<ZipEntry> em = zf.getEntries(); em.hasMoreElements();) {
				ZipEntry ze = em.nextElement();

				if (ze.isDirectory()) {
					continue;
				}

				dis = new DataInputStream(zf.getInputStream(ze));
				String currentFileName = ze.getName();
				int dex = currentFileName.lastIndexOf('/');
				String currentoutFilePath = outFilePath;

				if (dex > 0) {
					currentoutFilePath += (currentFileName.substring(0, dex) + File.separator);

					File currentFileDir = new File(currentoutFilePath);
					if (!currentFileDir.mkdirs()) {
						return false;
					}
				}

				fos = new FileOutputStream(outFilePath + ze.getName());

				int readLen = 0;

				while ((readLen = dis.read(buf, 0, 1024)) > 0) {
					fos.write(buf, 0, readLen);
				}

			}

			flag = true;
		} catch (Exception e) {
			e.printStackTrace();
		} finally {
			try {
				if (dis != null) {
					dis.close();
				}
				if (fos != null) {
					fos.close();
				}
			} catch (IOException e) {
				e.printStackTrace();
			}
		}

		return flag;
	}

	public static void main(String[] args) {
		System.out.println(unZip("e:\\temp\\classes.zip", "e:\\temp", 1));
	}
}
