package org.swift.util.file;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Date;

import org.swift.util.datetime.FormatTime;
import org.swift.util.lang.CharUtil;



/**
 * 日志处理<br>
 * 鲍庆丰<br>
 * baoqingfeng@gmail.com<br>
 */
@Deprecated
public class Log {
    /**
     * 用来记录事件
     * @param msg　事件内容
     * @param fileName　日志文件的路径及名称
     */
    public static String LOG_FILE = null;

    {
        try {
            Path.getFullPathRelateClass("../../../../log", Path.class);
        } catch (IOException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
    }

    /**
     * 把收到的byte字节流打印成hex字符串
     * @param msg　事件内容
     * @param logFile　日志文件的路径及名称
     */
    public static void printBytes(byte[] msg, String logFile) {
        printEvent(CharUtil.byteArrayToHexString(msg),logFile);
    }

    /**
     * 用来记录普通事件
     * @param msg　事件内容
     * @param logFile　日志文件的路径及名称
     */
    public synchronized static void printEvent(String msg, String fileName) {
        msg = new String("INFO "+FormatTime.toString(new Date(),"yyyy-MM-dd HH:mm:ss") +
                " " + msg);

        if (fileName != null) {
            printToFile(msg, fileName);
            print(msg);
        } else {
            print(msg);
        }

        return;
    }

    /**
     * 记录应用程序错误信息
     * @param msg　　　消息
     * @param fileName　日志文件的路径及名称
     */
    public synchronized static void printError(String msg, String fileName) {
        StringBuffer errors = new StringBuffer(100);
        errors.append("ERROR ");
        errors.append(FormatTime.toString(new Date(),"yyyy-MM-dd HH:mm:ss"));
        errors.append("　");
        errors.append(msg);

        if (fileName != null) {
        	print(errors.toString().trim());
            printToFile(errors.toString().trim(), fileName);
        } else {
            print(errors.toString().trim());
        }
        return;
    }

    /**
     * 把错误消息打印到屏幕上
     * @param msg　错误消息
     */
    private static void print(String msg) {
        System.out.println(msg);
    }

    /**
     * 把消息打印到指定文件
     * @param msg　错误消息
     * @param fileName　指定的文件
     */
    private static void printToFile(String msg, String fileName) //打印到文件中
     {
        printToFile(msg, fileName, true);
    }

    private static void printToFile(String msg, String fileName, boolean flag) //打印到文件中
     {
        String ctime = FormatTime.toString(new Date(),"yyyy-MM-dd HH:mm:ss");
        fileName = fileName + ctime.substring(1, 6) + ".log";

        BufferedWriter mBufWriter = null;

        try {
            if (!createFile(fileName)) {
                return;
            }

            FileWriter fileWriter = new FileWriter(fileName, flag);
            mBufWriter = new BufferedWriter(fileWriter);

            mBufWriter.write(msg);
            mBufWriter.newLine();

            mBufWriter.flush();
            mBufWriter.close();
        } catch (Throwable e) {
            try {
                mBufWriter.close();
            } catch (Throwable t) {
            }

            ;
        }

        return;
    }

    /**
     * 用来创建文件和文件夹
     * @param fileName　文件或文件夹名称
     * @return
     * @throws IOException
     * @throws Exception
     */
    public static boolean createFile(String fileName)
        throws IOException, Exception {
        File file = new File(fileName);

        if (file.exists()) /* does file exist? If so, can it be written to */ {
            if (file.canWrite() == false) {
                return false;
            }
        } else {
            String path = null; /* Does not exist.  Create the directories */

            int firstSlash = fileName.indexOf(File.separatorChar);
            int finalSlash = fileName.lastIndexOf(File.separatorChar);

            if (finalSlash == 0) { /* error, not valid path */
            } else if (finalSlash == 1) /* UNIX root dir */ {
                path = File.separator;
            } else if (firstSlash == finalSlash) { /* for example c:\  Then make sure slash is part of path */
                path = fileName.substring(0, finalSlash + 1);
            } else {
                path = fileName.substring(0, finalSlash);
            }

            File dir = new File(path);
            dir.mkdirs();
        }

        return true;
    }

    public static void main(String[] args) throws IOException, Exception {
        createFile("c\\:\\log\\a.log");
    }
}
