package org.swift.util.format;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

/**
 * 时间处理<br>
 * 鲍庆丰<br>
 * baoqingfeng@gmail.com<br>
 * <br>
 * 格式定义如下：<br>
 * y 年号，如 1996<br>
 * M 月份，如 July 或者 07<br>
 * d 月中第几天，如 12<br>
 * H 小时(24制)，如 0、17<br>
 * m 分钟,如 32<br>
 * s 钞钟，如55<br>
 * S 微钞，如978<br>
 * E 星期几，如 Tuesday<br>
 * D 一年中的第几天，如 189<br>
 * w week in year (Number) 27<br>
 * W week in month (Number) 2<br>
 * a am/pm marker (Text) PM<br>
 * k hour in day (1~24) (Number) 24<br>
 * K hour in am/pm (0~11) (Number) 0<br>
 * z time zone (Text) Pacific Standard Time<br> ' escape for text (Delimiter)<br> ''
 * single quote (Literal) '<br>
 * 用法：<br>
 * FormatTime.getTimeStrByLongTime(1000L * 60L * 60L * 25L * 30L * 12L) 1年15天
 * <br>
 * FormatTime.toString(new Date(),"yyyy年MM月dd日HH时mm分ss秒") 2007年12月27日10时49分52秒
 * <br>
 * FormatTime.toString(FormatTime.getDate(new
 * Date(),"yyyy-MM-DD"),"yyyy年MM月dd日HH时mm分ss秒") 2007年12月27日00时00分00秒 <br>
 * FormatTime.toString(FormatTime.getDate("2005-1-1","yyyy-MM-DD"),"yyyy年MM月dd日HH时mm分ss秒")
 * 2005年01月01日00时00分00秒 <br>
 * FormatTime.toString(FormatTime.getDateAddDays(new
 * Date(),-10),"yyyy年MM月dd日HH时mm分ss秒") 2007年12月17日10时49分52秒 <br>
 * FormatTime.toString(FormatTime.getDateAddMonths(new
 * Date(),-2),"yyyy年MM月dd日HH时mm分ss秒") 2007年10月27日10时49分52秒 <br>
 * FormatTime.toString(new Date(12345222),"yyyy年MM月dd日HH时mm分ss秒")
 * 1970年01月01日11时25分45秒 <br>
 */
public class DateTimeFormat {

	/**
	 * @param args
	 * @throws ParseException
	 */
	public static void main(String[] args) throws ParseException {
		Long l = (1000L * 60L * 60L * 25L * 30L * 12L);
		System.out.println(DateTimeFormat.getTimeStrByLongTime(l));
		System.out.println(DateTimeFormat.toString(new Date(),
				"yyyy年MM月dd日HH时mm分ss秒"));
		System.out.println(DateTimeFormat.toString(DateTimeFormat.getDate(
				new Date(), "yyyy-MM-DD"), "yyyy年MM月dd日HH时mm分ss秒"));
		System.out.println(DateTimeFormat.toString(DateTimeFormat.getDate(
				"2005-1-1", "yyyy-MM-DD"), "yyyy年MM月dd日HH时mm分ss秒"));
		System.out.println(DateTimeFormat.toString(DateTimeFormat
				.getDateAddDays(new Date(), -10), "yyyy年MM月dd日HH时mm分ss秒"));
		System.out.println(DateTimeFormat.toString(DateTimeFormat
				.getDateAddMonths(new Date(), -2), "yyyy年MM月dd日HH时mm分ss秒"));
		System.out.println(DateTimeFormat.toString(new Date(12345222),
				"yyyy年MM月dd日HH时mm分ss秒"));

		// System.out.println(getTimeFormatFromDate(getTimeAddTime(0,-1),"yyyy-MM-01"));
	}

	/**
	 * 作者：baoqf<br>
	 * 生成日期：2007-12-27 上午10:58:44<br>
	 * 功能描述：Date转换为String<br>
	 * 
	 * @param date
	 *            需要转换的date
	 * @param format
	 *            格式字符串
	 * @return 返回按照格式转化后的字符串 FormatTime.toString(new Date(),"yyyy-MM-dd HH:mm:ss
	 *         SSS")
	 */
	public static String toString(Date date, String format) {
		SimpleDateFormat dateformatter = new SimpleDateFormat(format);
		String dateString = dateformatter.format(date);

		return dateString;
	}

	/**
	 * 作者：baoqf<br>
	 * 生成日期：2007-12-27 上午10:58:44<br>
	 * 功能描述：Date时间转换为格式化后的Date时间<br>
	 * 
	 * @param date
	 *            需要转换的date
	 * @param format
	 *            格式字符串
	 * @return 返回按照格式转化后的Date 如：FormatTime.getDate(new Date(),"yyyy-MM-dd")
	 *         获得某天0点的时间
	 */
	public static Date getDate(Date date, String format) throws ParseException {
		SimpleDateFormat sdf = new SimpleDateFormat(format);

		return sdf.parse(sdf.format(date));
	}

	/**
	 * 作者：baoqf<br>
	 * 生成日期：2007-12-27 上午10:58:44<br>
	 * 功能描述：String时间转换为格式化Date时间<br>
	 * 
	 * @param date
	 *            需要转换的String
	 * @param format
	 *            格式字符串
	 * @return 返回按照格式转化后的Date 如：FormatTime.getDate("2007-11-01","yyyy-MM-dd")
	 */
	public static Date getDate(String dateStr, String format)
			throws ParseException {
		SimpleDateFormat dateformatter = new SimpleDateFormat(format);
		return dateformatter.parse(dateStr);
	}

	/**
	 * 作者：baoqf<br>
	 * 生成日期：2007-12-27 上午10:58:44<br>
	 * 功能描述：获得距今天一定时间后的时间<br>
	 * 
	 * @param date
	 *            转换前的时间
	 * @param field
	 *            增减单位
	 * @param add_days
	 *            增减数量
	 * @return 返回增减单位后的Date 如：FormatTime.getDateAdd(new
	 *         Date(),Calendar.MONTH,-2) 2个月前的时间
	 */
	public static Date getDateAdd(Date date, int field, int add_days) {
		Calendar time = Calendar.getInstance();
		time.setTime(date);
		time.add(field, add_days);
		return time.getTime();
	}

	/**
	 * 作者：baoqf<br>
	 * 生成日期：2007-12-27 上午10:58:44<br>
	 * 功能描述：获得格式化时间，时间为距几天天数<br>
	 * 
	 * @param date
	 *            转换前的时间
	 * @param add_days
	 *            天数
	 * @return 返回增加天数之后的Date 如：FormatTime.getDateAddDays(new Date(),-1) 一天前的时间
	 */
	public static Date getDateAddDays(Date date, int add_days) {
		Calendar time = Calendar.getInstance();

		time.setTime(date);
		time.add(Calendar.DATE, add_days);
		return time.getTime();
	}

	/**
	 * 作者：baoqf<br>
	 * 生成日期：2007-12-27 上午10:58:44<br>
	 * 功能描述：获得格式化时间，时间为距今天月数<br>
	 * 
	 * @param date
	 *            转换前的时间
	 * @param add_months
	 *            月数
	 * @return 返回增减月数后的Date 如：FormatTime.getDateAddMonths(new Date(),-2) 2个月前的时间
	 */
	public static Date getDateAddMonths(Date date, int add_months) {
		Calendar time = Calendar.getInstance();
		time.setTime(date);
		time.add(Calendar.MONTH, add_months);
		return time.getTime();
	}

	/**
	 * 作者：baoqf<br>
	 * 生成日期：2007-12-27 上午10:58:44<br>
	 * 功能描述：获得用时时间，12000=12秒<br>
	 * 
	 * @param time_misec
	 *            毫秒数
	 * @return 返回用时时间字符串 如：FormatTime.getTimeStrByLongTime(12010) 12秒10毫秒
	 */
	public static String getTimeStrByLongTime(long time_misec) {
		StringBuffer bu = new StringBuffer(20);
		long parent = time_misec;
		long leav = parent % 1000;

		if (leav != 0) {
			bu.insert(0, leav + "毫秒");
		}

		long child = parent / 1000;

		if (child == 0) {
			return bu.toString();
		}

		leav = child % 60;

		if (leav != 0) {
			bu.insert(0, leav + "秒");
		}

		child = child / 60;

		if (child == 0) {
			return bu.toString();
		}

		leav = child % 60;

		if (leav != 0) {
			bu.insert(0, leav + "分钟");
		}

		child = child / 60;

		if (child == 0) {
			return bu.toString();
		}

		leav = child % 24;

		if (leav != 0) {
			bu.insert(0, leav + "小时");
		}

		child = child / 24;

		if (child == 0) {
			return bu.toString();
		}

		leav = child % 30;

		if (leav != 0) {
			bu.insert(0, leav + "天");
		}

		child = child / 30;

		if (child == 0) {
			return bu.toString();
		}

		leav = child % 12;

		if (leav != 0) {
			bu.insert(0, leav + "月");
		}

		child = child / 12;

		if (child == 0) {
			return bu.toString();
		}

		bu.insert(0, child + "年");

		return bu.toString();
	}

	/**
	 * 作者：baoqf<br>
	 * 生成日期：2007-12-27 上午10:58:44<br>
	 * 功能描述：获取相距时间time参数为年月日时分秒的时间<br>
	 * 
	 * @param int...time
	 *            年月日时分秒顺序输入参数,允许部分参数
	 * @return 返回时间 如：FormatTime.getTimeAddTime(2007,12,26)
	 */
	public static Date getTimeAddTime(int... time) {
		Calendar now = new GregorianCalendar();

		if ((time == null) || (time.length == 0)) {
			return now.getTime();
		}

		int len = time.length;
		int[] times = time;

		for (int i = 0; i < len; i++) {
			switch (i) {
			case 0:
				now.add(Calendar.YEAR, times[i]);

				break;

			case 1:
				now.add(Calendar.MONTH, times[i]);

				break;

			case 2:
				now.add(Calendar.DATE, times[i]);

				break;

			case 3:
				now.add(Calendar.HOUR, times[i]);

				break;

			case 4:
				now.add(Calendar.MINUTE, times[i]);
				
				break;
			case 5:
				now.add(Calendar.SECOND, times[i]);

				break;
			}
		}

		return now.getTime();
	}

	/**
	 * 作者：baoqf<br>
	 * 生成日期：2007-12-27 上午10:58:44<br>
	 * 功能描述：获取上月第一天的时间<br>
	 * 
	 * @return 返回上月第一天的时间 如：FormatTime.getLastMonthFistDay()
	 */
	public static Date getLastMonthFistDay() {
		Calendar now = new GregorianCalendar();
		now.add(Calendar.MONTH, -1);

		Calendar stdCal = new GregorianCalendar(now.get(Calendar.YEAR), now
				.get(Calendar.MONTH), 1);

		return stdCal.getTime();
	}

	/**
	 * 作者：baoqf<br>
	 * 生成日期：2007-12-27 上午10:58:44<br>
	 * 功能描述：获取本月第一天的时间<br>
	 * 
	 * @return 返回本月第一天的时间 如：FormatTime.getNowMonthFirstDay()
	 */
	public static Date getNowMonthFirstDay() {
		Calendar now = new GregorianCalendar();
		int curYear = now.get(Calendar.YEAR);
		int curMonth = now.get(Calendar.MONTH);

		Calendar stdCal = new GregorianCalendar(curYear, curMonth, 1);

		return stdCal.getTime();
	}
}
