package org.swift.util.http;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * Cookie工具类<br>
 * 
 */
public class CookieUtil {
	/**
	 * 作者：清风<br>
	 * 生成日期：2007-12-28 下午12:18:01<br>
	 * 功能描述：获得当前请求域下指定cookie值<br>
	 * 
	 * @param request
	 * @param key
	 *            键
	 */
	public static String getLocalInfo(HttpServletRequest request, String key) {
		Cookie cookies[] = request.getCookies();
		if (cookies == null)
			return null;

		String value = null;
		for (Cookie cookie : cookies) {
			String cname = cookie.getName();
			if (cname.equals(key)) {
				value = cookie.getValue();
			}
		}

		return value;
	}

	/**
	 * 作者：清风<br>
	 * 生成日期：2007-12-28 下午12:18:01<br>
	 * 功能描述：设置cookie<br>
	 * 
	 * @param response
	 * @param domain
	 *            域
	 * @param key
	 *            键
	 * @param value
	 *            值
	 * @param cookieAge
	 *            最大过期时间
	 */

	public static void setLocalInfo(HttpServletResponse response, String domain, String key,
			String value, int cookieAge) {
		Cookie cookieToken = new Cookie(key, value);
		if (domain != null) {
			cookieToken.setDomain(domain);
		}
		cookieToken.setPath("/");
		if (cookieAge >= 0) {
			cookieToken.setMaxAge(cookieAge);
		}
		response.addCookie(cookieToken);
	}

	public static void setLocalInfo(HttpServletResponse response, String domain, String key,
			String value) {
		setLocalInfo(response, domain, key, value, -1);
	}

	/**
	 * 作者：清风<br>
	 * 生成日期：2007-12-28 下午12:18:01<br>
	 * 功能描述：删除cookie<br>
	 * 
	 * @param response
	 * @param domain
	 *            域
	 * @param key
	 *            键
	 */
	public static void removeLocalInfo(HttpServletResponse response, String domain, String key) {
		Cookie cookieToken = new Cookie(key, "");
		if (domain != null) {
			cookieToken.setDomain(domain);
		}
		cookieToken.setPath("/");
		cookieToken.setMaxAge(0);
		response.addCookie(cookieToken);
	}
}
