package org.swift.util.http;

import java.util.Enumeration;

import javax.servlet.http.HttpServletRequest;

/**
 * 获取parameter参数的值
 */
public class ParamUtil {
	public ParamUtil() {
	}

	/**
	 * 作者：清风<br>
	 * 生成日期：2007-12-28 下午12:18:01<br>
	 * 功能描述：获得parameter字符串值<br>
	 * 
	 * @param request
	 * @param s
	 *            url参数
	 * @return 参数值
	 */
	public static String getString(HttpServletRequest request, String s) throws Exception {
		String s1 = request.getParameter(s);

		if ((s1 != null) && !s1.equals("")) {
			return new String(s1.getBytes("8859_1"), "gb2312");
		} else {
			return null;
		}
	}

	/**
	 * 作者：清风<br>
	 * 生成日期：2007-12-28 下午12:18:01<br>
	 * 功能描述：获得parameter字符串值，如果为空使用默认值<br>
	 * 
	 * @param request
	 * @param s
	 *            url参数
	 * @param s1
	 *            默认值
	 * @return 参数值
	 */
	public static String getString(HttpServletRequest request, String s, String s1) throws Exception {
		String s2 = getString(request, s);

		if (s2 == null) {
			s2 = s1;
		}

		return s2;
	}

	/**
	 * 作者：清风<br>
	 * 生成日期：2007-12-28 下午12:18:01<br>
	 * 功能描述：指定编码获得parameter字符串值，如果为空使用默认值<br>
	 * 
	 * @param request
	 * @param s
	 *            url参数
	 * @param s1
	 *            默认值
	 * @param encode
	 *            解码字符集
	 * @return 参数值
	 */
	public static String getStringEncode(HttpServletRequest request, String s, String s1, String encode) throws Exception {
		String s2 = request.getParameter(s);

		if ((s2 != null) && !s2.equals("")) {
			s2 = new String(s2.getBytes("8859_1"), encode);
		} else {
			s2 = null;
		}

		if (s2 == null) {
			s2 = s1;
		}

		return s2;
	}

	/**
	 * 作者：清风<br>
	 * 生成日期：2007-12-28 下午12:18:01<br>
	 * 功能描述：获得int型参数<br>
	 * 
	 * @param request
	 * @param s
	 *            url参数
	 * @return 参数值
	 */
	public static int getInt(HttpServletRequest request, String s) throws Exception {
		return Integer.parseInt(getString(request, s));
	}

	/**
	 * 作者：清风<br>
	 * 生成日期：2007-12-28 下午12:18:01<br>
	 * 功能描述：获得long型参数,没有使用默认值<br>
	 * 
	 * @param request
	 * @param s
	 *            url参数
	 * @param i
	 *            默认值
	 * @return 参数值
	 */
	public static long getLong(HttpServletRequest request, String s, long i) throws Exception {
		String s1 = getString(request, s);

		if (s1 == null) {
			return i;
		} else {
			return Long.parseLong(s1);
		}
	}

	/**
	 * 作者：清风<br>
	 * 生成日期：2007-12-28 下午12:18:01<br>
	 * 功能描述：获得int型参数,没有使用默认值<br>
	 * 
	 * @param request
	 * @param s
	 *            url参数
	 * @param i
	 *            默认值
	 * @return 参数值
	 */
	public static int getInt(HttpServletRequest request, String s, int i) throws Exception {
		String s1 = getString(request, s);

		if (s1 == null) {
			return i;
		} else {
			return Integer.parseInt(s1);
		}
	}

	/**
	 * 作者：清风<br>
	 * 生成日期：2007-12-28 下午12:18:01<br>
	 * 功能描述：获得bool型参数,没有使用默认值<br>
	 * 
	 * @param request
	 * @param s
	 *            url参数
	 * @param b
	 *            默认值
	 * @return 参数值
	 */
	public static boolean getBoolean(HttpServletRequest request, String s, boolean b) throws Exception {
		String s1 = getString(request, s);

		if (s1 == null) {
			return b;
		}

		if ((s1.compareToIgnoreCase("true") == 0) || (s1.compareToIgnoreCase("1") == 0)) {
			return true;
		}

		return false;
	}

	/**
	 * 作者：清风<br>
	 * 生成日期：2007-12-28 下午12:18:01<br>
	 * 功能描述：获得double型参数,没有使用默认值<br>
	 * 
	 * @param request
	 * @param s
	 *            url参数
	 * @param d
	 *            默认值
	 * @return 参数值
	 */
	public static double getDouble(HttpServletRequest request, String s, double d) throws Exception {
		String s1 = getString(request, s);

		if (s1 == null) {
			return d;
		} else {
			return Double.parseDouble(s1);
		}
	}

	/**
	 * 作者：清风<br>
	 * 生成日期：2007-12-28 下午12:18:01<br>
	 * 功能描述：在session中放入key为PARAMUTIL_ERROR_INFO的变量<br>
	 * 
	 * @param request
	 * @param s
	 *            session值
	 * @return
	 */
	public static void setErrorInfo(HttpServletRequest request, String s) {
		request.getSession().setAttribute("PARAMUTIL_ERROR_INFO", s);
	}

	/**
	 * 作者：清风<br>
	 * 生成日期：2007-12-28 下午12:18:01<br>
	 * 功能描述：从session中获得key为PARAMUTIL_ERROR_INFO的值<br>
	 * 
	 * @param request
	 * @return session变量值
	 */
	public static String getErrorInfo(HttpServletRequest request) {
		Object obj = request.getSession().getAttribute("PARAMUTIL_ERROR_INFO");

		if (obj != null) {
			request.getSession().removeAttribute("PARAMUTIL_ERROR_INFO");

			return (String) obj;
		}

		return null;
	}

	/**
	 * 作者：清风<br>
	 * 生成日期：2007-12-28 下午12:18:01<br>
	 * 功能描述：session是否含key为PARAMUTIL_ERROR_INFO的变量<br>
	 * 
	 * @param request
	 * @return true 含 false不含
	 */
	public static boolean hasErrorInfo(HttpServletRequest request) {
		return request.getSession().getAttribute("PARAMUTIL_ERROR_INFO") != null;
	}

	/**
	 * 作者：清风<br>
	 * 生成日期：2007-12-28 下午12:18:01<br>
	 * 功能描述：组装parameter参数名和参数值组成的url<br>
	 * 
	 * @param request
	 * @return 组装后的url,如：&port=22&account=123288888
	 */
	@SuppressWarnings("unchecked")
	public static String computeQueryString(HttpServletRequest request) {
		String queryString = "";
		Enumeration<String> paramNames = request.getParameterNames();
		boolean first = true;

		while (paramNames.hasMoreElements()) {
			String name = paramNames.nextElement();

			if (!first)
				queryString += "&";
			queryString += name + "=" + request.getParameter(name);
			first = false;
		}
		return queryString;
	}

	/**
	 * 设置正确提示信息
	 * 
	 * @param request
	 * @param s
	 */
	public static void setCorrectInfo(HttpServletRequest request, String s) {
		request.getSession().setAttribute("PARAMUTIL_CORRECT_INFO", s);
	}

	/**
	 * 获取正确提示信息
	 * 
	 * @param request
	 * @param s
	 */
	public static String getCorrectInfo(HttpServletRequest request) {
		Object obj = request.getSession().getAttribute("PARAMUTIL_CORRECT_INFO");

		if (obj != null) {
			request.getSession().removeAttribute("PARAMUTIL_CORRECT_INFO");

			return (String) obj;
		}

		return null;
	}

	/**
	 * 是否有正确提示信息
	 * 
	 * @param request
	 * @return
	 */
	public static boolean hasCorrectInfo(HttpServletRequest request) {
		return request.getSession().getAttribute("PARAMUTIL_CORRECT_INFO") != null;
	}
}
