package org.swift.util.http;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Date;
import java.util.Map;

import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.cookie.CookiePolicy;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.params.HttpClientParams;

/**
 * HTTPClient 工具类 主要用于获取http反馈<br>
 * 
 * @author mafei 示例<br>
 *         WebClient.setMaxConnOut(2);<br>
 *         String output = "";<br>
 *         for(int a=0;a<1;a++)<br>
 *         {<br>
 *         if(a%4==0)<br>
 *         output = retrieveWebContent("http://www.sina.com.cn");<br>
 *         else if(a%4==1)<br>
 *         output = retrieveWebContent("http://www.sina.com.cn");<br>
 *         else<br>
 *         output = retrieveWebContent("http://www.sina.com.cn");<br>
 * <br>
 * <br>
 * 
 *         System.out.println(output);<br>
 */
public class WebClient {

	public static void main(String[] args) {
		System.out.println(post("http://game/servlet/Test", "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>" + "<server-status>" + "<call-centers />" + "</server-status>"));
	}

	private static class ContentRequestEntity implements RequestEntity {

		private String contentType;
		private RequestEntity entity;

		public ContentRequestEntity(RequestEntity entity, String contentType) {
			super();
			this.entity = entity;
			this.contentType = contentType;
		}

		public long getContentLength() {
			return entity.getContentLength();
		}

		public String getContentType() {
			if (contentType == null) {
				return entity.getContentType();
			}
			return contentType;
		}

		public boolean isRepeatable() {
			return entity.isRepeatable();
		}

		public void writeRequest(OutputStream out) throws IOException {
			entity.writeRequest(out);
		}

	}

	private static class UTF8PostMethod extends PostMethod {
		private String ecode = "UTF-8";
		private String contentType = FORM_URL_ENCODED_CONTENT_TYPE;

		public UTF8PostMethod(String url, String encode) {
			super(url);
			if (encode != null && encode.length() > 0)
				this.ecode = encode;
		}

		@Override
		public String getRequestCharSet() {
			return ecode;
		}

		public void setContentType(String contentType) {
			this.contentType = contentType;
		}

		protected RequestEntity generateRequestEntity() {
			return new ContentRequestEntity(super.generateRequestEntity(), contentType);
		}
	}

	/**
	 * @deprecated use retrieveWebContent Instead
	 */
	@Deprecated
	public static String retrieveWebInfo(String url) {
		return retrieveWebContent(url);
	}

	public static HttpClient getDefaultHttpClient() {
		HttpConnectionManager connectionManager = WebClientManager.getInstance().getHttpConnectionManager();
		HttpClientParams clientParams = WebClientManager.getInstance().getHttpClientParams();
		return new HttpClient(clientParams, connectionManager);
	}

	/**
	 * 
	 * 作者：Administrator<br>
	 * 生成日期：2008-1-26 下午03:54:25<br>
	 * 功能描述：获得指定编码集的http请求的反馈<br>
	 * 
	 * @param httpClient
	 * <br>
	 * @param url
	 * <br>
	 * @param encode
	 * <br>
	 *            修改人：Administrator<br>
	 *            修改时间：2008-1-26 下午03:54:25<br>
	 *            修改功能：<br>
	 *            修改后版本：<br>
	 */
	public static String retrieveWebContent(HttpClient httpClient, String url, String encode) {
		GetMethod httpGet = new GetMethod(url);
		String respBody = null;
		try {

			httpClient.getParams().setParameter("http.protocol.cookie-policy", CookiePolicy.IGNORE_COOKIES);

			int nRetCode = httpClient.executeMethod(httpGet);

			if (nRetCode == 200) {
				respBody = inputStreamAsString(httpGet.getResponseBodyAsStream(), encode);
			} else {
				System.out.println(new Date() + " url:" + url + " returnCode:" + nRetCode);
			}

		} catch (Exception e) {
			System.out.println(new Date() + " url:" + url + " respBody:" + respBody);
			e.printStackTrace();
		} finally {
			httpGet.releaseConnection();
		}

		if (respBody != null)
			respBody = respBody.trim();

		return respBody;
	}

	/**
	 * 
	 * 作者：Administrator<br>
	 * 生成日期：2008-1-26 下午03:54:25<br>
	 * 功能描述：获得默认编码集(UTF-8)的http请求的反馈<br>
	 * 
	 * @param httpClient
	 * @param url
	 *            修改人：Administrator<br>
	 *            修改时间：2008-1-26 下午03:54:25<br>
	 *            修改功能：<br>
	 *            修改后版本：<br>
	 */
	public static String retrieveWebContent(HttpClient httpClient, String url) {
		return retrieveWebContent(httpClient, url, "UTF-8");
	}

	public static String post(String url, String body) {
		return post(getDefaultHttpClient(), url, body);
	}

	public static String post(String url, String body, String encode) {
		return post(getDefaultHttpClient(), url, body, encode);
	}

	public static String post(HttpClient httpClient, String url, String body) {
		return post(httpClient, url, body, "UTF-8");
	}

	@SuppressWarnings("deprecation")
	public static String post(HttpClient httpClient, String url, String body, String encode) {
		UTF8PostMethod httpPost = new UTF8PostMethod(url, encode);
		String respBody = null;

		try {
			httpPost.setContentType("text/xml;charset=" + encode);
			httpPost.setRequestBody(body);

			int nRetCode = httpClient.executeMethod(httpPost);

			if (nRetCode == 200) {
				respBody = inputStreamAsString(httpPost.getResponseBodyAsStream(), encode);
			} else {
				System.out.println(new Date() + " url:" + url + " returnCode:" + nRetCode);
			}

		} catch (Exception e) {
			System.out.println(new Date() + " url:" + url + " respBody:" + respBody);
			e.printStackTrace();
		} finally {
			httpPost.releaseConnection();
		}

		if (respBody != null)
			respBody = respBody.trim();

		return respBody;

	}

	/**
	 * 
	 * 作者：Administrator<br>
	 * 生成日期：2008-1-26 下午03:54:25<br>
	 * 功能描述：指定编码集通过post方式获得http返回的数据<br>
	 * 
	 * @param url
	 *            请求地址
	 * @param nv
	 *            post的配对信息
	 * @param encode
	 *            编码集 修改人：Administrator<br>
	 *            修改时间：2008-1-26 下午03:54:25<br>
	 *            修改功能：<br>
	 *            修改后版本：<br>
	 */
	public static String post(HttpClient httpClient, String url, Map<String, String> nv, String encode) {
		PostMethod httpPost = new UTF8PostMethod(url, encode);
		String respBody = null;

		try {
			NameValuePair[] vcs = new NameValuePair[nv.size()];
			int i = 0;
			for (Map.Entry<String, String> entry : nv.entrySet()) {
				String name = entry.getKey();
				vcs[i] = new NameValuePair(name, entry.getValue());
				httpPost.setParameter(name, entry.getValue());
			}

			int nRetCode = httpClient.executeMethod(httpPost);

			if (nRetCode == 200) {
				respBody = inputStreamAsString(httpPost.getResponseBodyAsStream(), encode);
			} else {
				System.out.println(new Date() + " url:" + url + " returnCode:" + nRetCode);
			}

		} catch (Exception e) {
			System.out.println(new Date() + " url:" + url + " respBody:" + respBody);
			e.printStackTrace();
		} finally {
			httpPost.releaseConnection();
		}

		if (respBody != null)
			respBody = respBody.trim();

		return respBody;

	}

	public static String post(String url, Map<String, String> nv, String encode) {
		return post(getDefaultHttpClient(), url, nv, encode);
	}

	public static String post(HttpClient httpClient, String url, Map<String, String> nv) {
		return post(httpClient, url, nv, "UTF-8");
	}

	/**
	 * 默认编码集(UTF-8)post发送数据<br>
	 * 
	 * @param url
	 * @param nv
	 * @return
	 */
	public static String post(String url, Map<String, String> nv) {
		return post(getDefaultHttpClient(), url, nv);
	}

	/**
	 * 
	 * 作者：Administrator<br>
	 * 生成日期：2008-1-26 下午03:54:25<br>
	 * 功能描述：获得默认编码集(UTF-8)的http请求的反馈<br>
	 * 
	 * @param url
	 *            修改人：Administrator<br>
	 *            修改时间：2008-1-26 下午03:54:25<br>
	 *            修改功能：<br>
	 *            修改后版本：<br>
	 */
	public static String retrieveWebContent(String url) {
		return retrieveWebContent(getDefaultHttpClient(), url);
	}

	/**
	 * 
	 * 作者：Administrator<br>
	 * 生成日期：2008-1-26 下午03:54:25<br>
	 * 功能描述：获得指定认编码集的http请求的反馈<br>
	 * 
	 * @param url
	 * @param encode
	 *            修改人：Administrator<br>
	 *            修改时间：2008-1-26 下午03:54:25<br>
	 *            修改功能：<br>
	 *            修改后版本：<br>
	 */
	public static String retrieveWebContent(String url, String encode) {
		return retrieveWebContent(getDefaultHttpClient(), url, encode);
	}

	private static String inputStreamAsString(InputStream stream, String encode) throws IOException {
		BufferedReader br = new BufferedReader(new InputStreamReader(stream, encode));
		StringBuilder sb = new StringBuilder();
		String line = null;

		while ((line = br.readLine()) != null) {
			sb.append(line + "\n");
		}

		br.close();

		return sb.toString();
	}

	/**
	 * sunwei
	 * 
	 * @param getOneConnectTimeOut
	 *            获取一个httpclient对外连接的超时时间(当perHostMaxLink已经没有剩余时)，单位 秒，如果为0，那么为无限制，直到有连接，否则一直等，异常为“org.apache.commons.httpclient.ConnectionPoolTimeoutException: Timeout waiting for
	 *            connection”，推荐为10*1000
	 * @param connectionTimeOut
	 *            和目标服务器建立连接的超时时间，单位 秒,异常为“org.apache.commons.httpclient.ConnectTimeoutException: The host did not accept the connection within timeout of 1 ms”,推荐为10*1000
	 * @param getDateTimeOut
	 *            请求返回的超时时间,单位 秒,如果为0，那么为无限制，一直等到数据返回， 异常为 “java.net.SocketTimeoutException: Read timed out”，推荐设为10*1000
	 * @param totalMaxLink
	 *            系统最大同时对外请求数，推荐设为100
	 * @param perHostMaxLink
	 *            每个host的同时对外最大请求数,不得小于1,推荐设为20
	 */
	public static void setParams(int getOneConnectTimeOut, int connectionTimeOut, int getDataTimeOut, int totalMaxLink, int perHostMaxLink) {
		WebClientManager.getInstance().setHttpConnectionManager(getOneConnectTimeOut, connectionTimeOut, getDataTimeOut, totalMaxLink, perHostMaxLink);
	}
}
