package org.swift.util.http;

import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.params.HttpClientParams;
import org.apache.commons.httpclient.params.HttpConnectionManagerParams;

/**
 * HTTPClient 线程管理类
 * 
 * @author mafei
 * 
 */
public class WebClientManager {
	private static WebClientManager webClientManager = null;
	private MultiThreadedHttpConnectionManager connectionManager = null;
	private HttpClientParams clientParams = null;

	private WebClientManager() {
		connectionManager = new MultiThreadedHttpConnectionManager();
		clientParams = new HttpClientParams();
		setHttpConnectionManager(2 * 60000, 2 * 60000, 2 * 60000, 5012, 5012);// 默认是不能用的
	}

	public static WebClientManager getInstance() {
		if (webClientManager == null) {
			synchronized (WebClientManager.class) {
				if (webClientManager == null) {
					webClientManager = new WebClientManager();
				}
			}
		}
		return webClientManager;
	}

	public HttpConnectionManager getHttpConnectionManager() {
		return connectionManager;
	}

	public HttpClientParams getHttpClientParams() {
		return clientParams;
	}

	/**
	 * 功能描述：
	 * 
	 * @param getOneConnectTimeOut
	 *            获取一个httpclient对外连接的超时时间(当perHostMaxLink已经没有剩余时)，单位 秒，如果为0，那么为无限制，直到有连接，否则一直等，异常为“org.apache.commons.httpclient.ConnectionPoolTimeoutException: Timeout waiting for connection”，推荐为10*1000
	 * @param connectionTimeOut
	 *            和目标服务器建立连接的超时时间，单位 秒,异常为“org.apache.commons.httpclient.ConnectTimeoutException: The host did not accept the connection within timeout of 1 ms”,推荐为10*1000
	 * @param getDateTimeOut
	 *            请求返回的超时时间,单位 秒,如果为0，那么为无限制，一直等到数据返回， 异常为 “java.net.SocketTimeoutException: Read timed out”，推荐设为10*1000
	 * @param totalMaxLink
	 *            系统最大同时对外请求数，推荐设为100
	 * @param perHostMaxLink
	 *            每个host的同时对外最大请求数,不得小于1,推荐设为20
	 */
	public void setHttpConnectionManager(int getOneConnectTimeOut, int connectionTimeOut, int getDataTimeOut, int totalMaxLink, int perHostMaxLink) {
		HttpConnectionManagerParams managerParams = new HttpConnectionManagerParams();

		managerParams.setSoTimeout(getDataTimeOut);// 连接以后获取数据的超时
		managerParams.setConnectionTimeout(connectionTimeOut);// 与服务器取得连接的超时
		managerParams.setMaxTotalConnections(totalMaxLink);// 所有网站的对外总连接
		managerParams.setMaxConnectionsPerHost(HostConfiguration.ANY_HOST_CONFIGURATION, perHostMaxLink);// 每个host的对外总连接
		getHttpConnectionManager().setParams(managerParams);

		getHttpClientParams().setParameter(HttpClientParams.CONNECTION_MANAGER_TIMEOUT, getOneConnectTimeOut * 1l); // 获取连接超时
	}

}
