package org.swift.util.impl;

import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.LinkedList;

import org.swift.database.pool.DBConnect;
import org.swift.database.pool.DBSql;
import org.swift.util.IResource;


/**
 * 功能描述：数据库资源
 * 
 */
public class DBResource implements IResource {

	private String dbName;
	private String tabName;
	private DBConnect reader;
	private DBConnect writer;
	private LinkedList<String> list;
	private String cSection = "";

	public DBResource(String dbName, String tabName) {
		this.dbName = dbName;
		this.tabName = tabName;
	}

	public boolean exists() {
		boolean exist = true;
		DBConnect conn = new DBConnect();
		try {
			conn.init(dbName);
			conn.prepareStatement("select count(*) from " + tabName);
			conn.executeQuery();
		} catch (SQLException e) {
			e.printStackTrace();
			exist = false;
		} finally {
			conn.close();
		}
		return exist;
	}

	public void close() {
		list = null;
		reader = null;
		writer = null;
	}

	public void open(OpenMode mode) throws IOException {
		if (mode == OpenMode.ReadWrite || mode == OpenMode.ReadApped) {
			throw new IOException(
					"db resource not supported ReadWrite and ReadApped mode open");
		}
		if (mode == OpenMode.ReadOnly && reader == null) {
			reader = new DBConnect();
			list = new LinkedList<String>();
			try {
				reader.init(dbName);
				reader.prepareStatement("select * from " + tabName
						+ " order by section");
				ResultSet rs = reader.executeQuery();
				String cSection = null;
				while (rs.next()) {
					String section = rs.getString("section");
					String name = rs.getString("name");
					String value = rs.getString("value");
					if (section != null && !section.equals(cSection)) {
						list.add("[" + section + "]");
						cSection = section;
					}
					list.add(name + "=" + value);
				}
			} catch (SQLException e) {
				e.printStackTrace();
			} finally {
				reader.close();
			}
		}
		if ((mode == OpenMode.WriteOnly || mode == OpenMode.AppendOnly)
				&& writer == null) {
			writer = new DBConnect();
			if (mode == OpenMode.WriteOnly) {
				try {
					writer.init(dbName);
					writer.prepareStatement("delete from " + tabName);
					writer.executeUpdate();
				} catch (SQLException e) {
					e.printStackTrace();
				} finally {
					writer.close();
				}
			}
		}
	}

	public String read() throws IOException {
		if (reader == null) {
			throw new IOException("DB resources not open for read.");
		}
		return list.poll();
	}

	private String makeSql(String t) {
		if (t == null || t.length() == 0) {
			return null;
		}
		if (t.startsWith("[") && t.endsWith("]")) {
			t = t.substring(1);
			t = t.substring(0, t.length() - 1);
			cSection = t.trim();
			return null;
		}
		String kv[] = t.split("=", 2);
		String name = kv[0];
		String value = "";
		if (kv.length == 2) {
			value = kv[1];
		}
		DBSql sql = new DBSql("insert into " + tabName
				+ " set section = ?, name = ?, value = ? "
				+ " on duplicate key update value = ?");
		sql.setString(1, cSection);
		sql.setString(2, name);
		sql.setString(3, value);
		sql.setString(4, value);
		return sql.toString();
	}

	public void write(String t) throws IOException {
		if (writer == null) {
			throw new IOException("DB resources not open for wirte.");
		}
		String sql = makeSql(t);
		if (sql == null) {
			return;
		}
		try {
			writer.init(dbName);
			writer.prepareStatement(sql);
			writer.executeUpdate();
		} catch (SQLException e) {
			e.printStackTrace();
		} finally {
			writer.close();
		}
	}

	public String getAddress() {
		return dbName;
	}

	public boolean checkModification() {
		return false;
	}

	public void flush() {
	}
}
