package org.swift.util.impl;


import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;

import org.swift.util.IResource;
import org.swift.util.file.FileHandler;


/**
 * 
 * 功能描述：字符串文件字符串资源，用于包装字符串文件（utf-8）。
 * 
 */
public class FileResource implements IResource {

	private File file;
	private StreamResource reader;
	private PrintWriter writer;
	private long lastModified;

	public FileResource(String file) {
		if (file != null) {
			this.file = new File(file);
			lastModified = this.file.lastModified();
		}
	}

	public FileResource(File file) {
		if (file != null) {
			this.file = file;
			lastModified = this.file.lastModified();
		}
	}

	public boolean exists() {
		if (file == null) {
			return false;
		}
		return file.exists();
	}

	public void close() throws IOException {
		if (reader != null) {
			reader.close();
			reader = null;
		}
		if (writer != null) {
			writer.close();
			writer = null;
		}
	}

	public void open(OpenMode mode) throws IOException {
		if (!exists() && !FileHandler.newFile(getAddress())) {
			throw new IOException("create path[" + file.getParent() + "] failed");
		}
		if ((mode == OpenMode.ReadOnly || mode == OpenMode.ReadWrite || mode == OpenMode.ReadApped)
				&& reader == null) {
			reader = new StreamResource(new FileInputStream(file));
			reader.open(OpenMode.ReadOnly);
		}
		if ((mode == OpenMode.WriteOnly || mode == OpenMode.AppendOnly
				|| mode == OpenMode.ReadWrite || mode == OpenMode.ReadApped)
				&& writer == null) {
			writer = new PrintWriter(new OutputStreamWriter(new FileOutputStream(file,
					(mode == OpenMode.AppendOnly || mode == OpenMode.ReadApped)), "utf-8"));
		}
	}

	public String read() throws IOException {
		if (reader == null) {
			throw new IOException("File resources not open for read.");
		}
		return reader.read();
	}

	public void write(String t) throws IOException {
		if (writer == null) {
			throw new IOException("File resources not open for write.");
		}
		if (t == null) {
			return;
		}
		writer.println(t);
	}

	public String getAddress() {
		if (file == null) {
			return null;
		}
		return file.getAbsolutePath();
	}

	public boolean checkModification() {
		long time = file.lastModified();
		if (lastModified == time) {
			return false;
		}
		lastModified = time;
		return true;
	}

	public void flush() throws IOException {
		if (writer == null) {
			throw new IOException("File resources not open for write.");
		}
		writer.flush();
	}
}
