package org.swift.util.impl;


import java.io.IOException;
import java.util.LinkedList;

import org.swift.func.IProcessor;
import org.swift.util.IHttpAccesser;
import org.swift.util.IResource;
import org.swift.util.IThreadPool;
import org.swift.util.http.WebClient;


/**
 * 实现IHttpAccesser, Runnable的接口 Mar 9,2009, 11:20:15 Am 增加了url 最大的失败次数
 */
public class HttpAccesser implements IHttpAccesser, IProcessor {

	IResource resource;
	private LinkedList<AccessUrl> queue;

	public HttpAccesser(IResource nNesource, int threadCount, IThreadPool pool) {
		resource = nNesource;
		queue = new LinkedList<AccessUrl>();
		pool.addWorkers(this, threadCount);
	}

	public String access(String url) {
		if (url == null) {
			return null;
		}
		return WebClient.retrieveWebContent(url);
	}

	public synchronized boolean init() {
		if (resource == null || !resource.exists()) {
			return true;
		}
		try {
			resource.open(IResource.OpenMode.ReadOnly);
			String count_url = resource.read();
			while (count_url != null) {
				String[] str = count_url.split(" ", 2);
				int count = 0;
				String url = str[0];
				if (str.length == 2) {
					count = Integer.parseInt(str[0]);
					url = str[1];
				}
				queue.add(new AccessUrl(url, count));
				count_url = resource.read();
			}
			resource.open(IResource.OpenMode.WriteOnly);
			resource.write(null);
		} catch (IOException e) {
			e.printStackTrace();
		} finally {
			try {
				resource.close();
			} catch (IOException e) {
				e.printStackTrace();
			}
		}
		return true;
	}

	public boolean cycle() {
		AccessUrl accessUrl = null;
		synchronized (this) {
			if (!queue.isEmpty()) {
				accessUrl = queue.poll();
			}
		}
		if (accessUrl == null) {
			try {
				Thread.sleep(1000);
			} catch (InterruptedException e) {
				e.printStackTrace();
			}
			return true;
		}
		if (accessUrl.url == null) {
			return true;
		}
		if (access(accessUrl.url) != null) {
			return true;
		}
		if (accessUrl.count > 0) {
			accessUrl.count--;
			synchronized (this) {
				queue.add(accessUrl);
			}
		}
		return true;
	}

	public synchronized void destroy() {
		try {
			resource.open(IResource.OpenMode.AppendOnly);
			while (!queue.isEmpty()) {
				AccessUrl access = queue.poll();
				resource.write(access.count + " " + access.url);
			}
		} catch (IOException e) {
			e.printStackTrace();
		} finally {
			try {
				resource.close();
			} catch (IOException e) {
				e.printStackTrace();
			}
		}
	}

	@SuppressWarnings("unchecked")
	public synchronized boolean notify(String url, int failedCount) {
		if (url == null || failedCount < 0) {
			return false;
		}
		return queue.add(new AccessUrl(url, failedCount));
	}

	static class AccessUrl {
		public String url = "";
		public int count;

		public AccessUrl(String url, int count) {
			super();
			this.url = url;
			this.count = count;
		}
	}

}
