package org.swift.util.impl;


import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.Date;

import org.apache.log4j.Level;
import org.swift.database.pool.DBSql;
import org.swift.util.ILogger;
import org.swift.util.ISqlExecuter;
import org.swift.util.format.DateTimeFormat;


/**
 * 功能描述：日志实现类
 * 
 * 修改记录：
 * 
 */
public class Logger implements ILogger {

	private ISqlExecuter executer;
	private org.apache.log4j.Logger jlogger;

	Logger(String inlog4jname) {
		jlogger = org.apache.log4j.Logger.getLogger(inlog4jname);
	}

	private boolean isLevelOverrun(Level level) {
		Level jl = jlogger.getLevel();
		if (jl == null) {
			jl = Level.INFO;
		}
		if (level.toInt() < jl.toInt()) {
			return false;
		}
		return true;
	}

	private String getLogString(String action, boolean result, String other) {
		return "\"" + action + "\" \"" + (result ? "success" : "failed") + "\" \"" + other + "\"";
	}

	private String getExceptionString(Exception exception, Level level) {
		if (exception == null) {
			return null;
		}
		if (!isLevelOverrun(level)) {
			return exception.toString();
		}
		String log = null;
		try {
			ByteArrayOutputStream baos = new ByteArrayOutputStream();
			PrintStream ps = new PrintStream(baos);
			exception.printStackTrace(ps);
			log = baos.toString();
			baos.close();
			ps.close();
		} catch (Exception e) {
			log = exception.toString();
		}
		return log;
	}

	private void dbLog(Level level, String type, String log) {
		if (executer == null) {
			return;
		}
		if (!isLevelOverrun(level)) {
			return;
		}
		log = DateTimeFormat.toString(new Date(), "yy/MM/dd_HH:mm:ss") + " [" + level.toString()
				+ "] <" + Thread.currentThread().getName() + ">" + log;
		DBSql sql = new DBSql("{call insert_log(?,?)}");
		sql.setString(1, type);
		sql.setString(2, log);
		// String sql = "{call insert_log('" + type + "','" + log.replace("\'",
		// "\\\'") + "')}";
		executer.call(sql.toString(), null);
	}

	public void debug(String action, boolean result, String other) {
		debug(DEFAULT_TYPE, action, result, other);
	}

	public void debug(Exception exception) {
		debug(EXCEPTION, exception);
	}

	public void debug(String type, String action, boolean result, String other) {
		String log = getLogString(action, result, other);
		debug(type, log);
	}

	public void debug(String type, Exception exception) {
		String log = getExceptionString(exception, Level.DEBUG);
		error(type, log);
	}

	private void debug(String type, String log) {
		jlogger.debug(log);
		dbLog(Level.DEBUG, type, log);
	}

	public void error(String action, boolean result, String other) {
		error(DEFAULT_TYPE, action, result, other);
	}

	public void error(Exception exception) {
		error(EXCEPTION, exception);
	}

	public void error(String type, String action, boolean result, String other) {
		String log = getLogString(action, result, other);
		error(type, log);
	}

	public void error(String type, Exception exception) {
		String log = getExceptionString(exception, Level.ERROR);
		error(type, log);
	}

	private void error(String type, String log) {
		jlogger.error(log);
		dbLog(Level.ERROR, type, log);
	}

	public void fatal(String action, boolean result, String other) {
		fatal(DEFAULT_TYPE, action, result, other);
	}

	public void fatal(Exception exception) {
		fatal(EXCEPTION, exception);
	}

	public void fatal(String type, String action, boolean result, String other) {
		String log = getLogString(action, result, other);
		fatal(type, log);
	}

	public void fatal(String type, Exception exception) {
		String log = getExceptionString(exception, Level.FATAL);
		fatal(type, log);
	}

	private void fatal(String type, String log) {
		jlogger.fatal(log);
		dbLog(Level.FATAL, type, log);
	}

	public void info(String action, boolean result, String other) {
		info(DEFAULT_TYPE, action, result, other);
	}

	public void info(Exception exception) {
		info(EXCEPTION, exception);
	}

	public void info(String type, String action, boolean result, String other) {
		String log = getLogString(action, result, other);
		info(type, log);
	}

	public void info(String type, Exception exception) {
		String log = getExceptionString(exception, Level.INFO);
		error(type, log);
	}

	private void info(String type, String log) {
		jlogger.info(log);
		dbLog(Level.INFO, type, log);
	}

	public void warn(String action, boolean result, String other) {
		warn(DEFAULT_TYPE, action, result, other);
	}

	public void warn(Exception exception) {
		warn(EXCEPTION, exception);
	}

	public void warn(String type, String action, boolean result, String other) {
		String log = getLogString(action, result, other);
		warn(type, log);
	}

	public void warn(String type, Exception exception) {
		String log = getExceptionString(exception, Level.WARN);
		error(type, log);
	}

	private void warn(String type, String log) {
		jlogger.warn(log);
		dbLog(Level.WARN, type, log);
	}

	public void setSqlExecuter(ISqlExecuter executer) {
		this.executer = executer;
	}
}
