package org.swift.util.impl;


import java.io.File;
import java.io.IOException;

import org.swift.util.IProject;
import org.swift.util.file.Path;


/**
 * 功能描述：项目信息 假设目录结构已定
 * 
 * Web项目：project/WEB-INF/lib；project/WEB-INF/classes
 * Main项目：project/lib；project/bin
 * 
 */
public class Project implements IProject {

	private boolean isWebProject;
	private String path;
	private String name;

	public Project() {
		char sep = File.separatorChar;
		try {
			path = Path.getPathFromClass(Project.class);
			if (path.endsWith(".class")) {
				path = path.substring(0, path.lastIndexOf(sep + "org" + sep
						+ "swift" + sep));
				path = path.substring(0, path.lastIndexOf(sep));
			} else if (path.endsWith(".jar")) {
				path = path.substring(0, path.lastIndexOf(sep));
				path = path.substring(0, path.lastIndexOf(sep));
			}
			if (path.endsWith(sep + "WEB-INF")) {
				isWebProject = true;
				path = path.substring(0, path.lastIndexOf(sep + "WEB-INF"));
			} else {
				isWebProject = false;
			}
			int index = path.lastIndexOf(sep);
			name = path.substring(index + 1);
			path = path.substring(0, index + 1);
		} catch (IOException e) {
			e.printStackTrace();
		}
	}

	public String getName() {
		return name;
	}

	public String getPath() {
		return path;
	}

	public boolean isWebProject() {
		return isWebProject;
	}

}
