package org.swift.util.impl;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Enumeration;

import javax.servlet.http.HttpServletRequest;

import org.swift.util.IRequestParams;


public class RequestParams implements IRequestParams {
	private HttpServletRequest request;

	public RequestParams(HttpServletRequest request) {
		this.request = request;
	}

	public String getParameter(String key) {
		return request.getParameter(key);
	}

	public String getParameter(String key, String enc) {
		String value = getParameter(key);
		try {
			return URLDecoder.decode(URLEncoder.encode(value, "ISO8859-1"), enc);
		} catch (Exception e) {
			e.printStackTrace();
			return value;
		}
	}

	@SuppressWarnings("unchecked")
	public String getQueryString() {
		String queryString = request.getQueryString();
		if (queryString != null) {
			return queryString;
		}
		queryString = "";
		Enumeration<String> paramNames = request.getParameterNames();
		while (paramNames.hasMoreElements()) {
			String name = paramNames.nextElement();
			queryString += name + "=" + getParameter(name) + "&";
		}
		return queryString;
	}

	@SuppressWarnings("unchecked")
	public String getQueryString(String enc) {
		String queryString = request.getQueryString();
		if (queryString != null) {
			try {
				return URLDecoder.decode(queryString, enc);
			} catch (UnsupportedEncodingException e) {
				e.printStackTrace();
				return queryString;
			}
		}
		queryString = "";
		Enumeration<String> paramNames = request.getParameterNames();
		while (paramNames.hasMoreElements()) {
			String name = paramNames.nextElement();
			queryString += name + "=" + getParameter(name) + "&";
		}
		return queryString;
	}

	public String getIp() {
		if (request == null) {
			return null;
		}
		String ip = request.getHeader("X-Forwarded-For");
		if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
			ip = request.getHeader("Proxy-Client-IP");
		}
		if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
			ip = request.getHeader("WL-Proxy-Client-IP");
		}
		if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
			ip = request.getHeader("HTTP_CLIENT_IP");
		}
		if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
			ip = request.getHeader("HTTP_X_FORWARDED_FOR");
		}
		if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
			ip = request.getRemoteAddr();
		}

		String ips[] = ip.split(",");
		return ips[0];
	}
}
