package org.swift.util.impl;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

import org.swift.util.IResource;


/**
 *  
 * 功能描述：输入流字符串资源，用于包装字符串（utf-8）流。
 * 
 */
public class StreamResource implements IResource {

	private InputStream inputStream;
	private BufferedReader reader;

	public StreamResource(InputStream stream) {
		if (stream == null) {
			return;
		}
		inputStream = stream;
	}

	public boolean exists() {
		return inputStream != null;
	}

	public void open(OpenMode mode) throws IOException {
		if (mode != OpenMode.ReadOnly) {
			throw new IOException("StreamResource not supported write!");
		}
		if (reader != null) {
			return;
		}
		reader = new BufferedReader(new InputStreamReader(inputStream, "utf-8"));
	}

	public void close() throws IOException {
		if (reader != null) {
			reader.close();
		}
	}

	public String read() throws IOException {
		if (reader == null) {
			throw new IOException("StreamResource not open for read!");
		}
		return reader.readLine();
	}

	public void write(String t) throws IOException {
		throw new IOException("StreamResource not supported write!");
	}

	public String getAddress() {
		return null;
	}

	public boolean checkModification() {
		return false;
	}

	public void flush() throws IOException {
		throw new IOException("StreamResource not supported write!");
	}
}
