package org.swift.util.impl;

import org.swift.util.IConfig;
import org.swift.util.IWebEnv;

/**
 * 功能描述：Web项目部署环境
 * 
 */
public class WebEnv implements IWebEnv {
	private IConfig config;
	private String name;

	public WebEnv(IConfig config, String name) {
		this.config = config;
		this.name = name;
	}

	public String getHost() {
		return config.getString(name, HOST, "localhost");
	}

	public String getPath() {
		return config.getString(name, PATH, "/");
	}

	public String getPort() {
		return config.getString(name, PORT, "80");
	}

	public String getProtocol() {
		return config.getString(name, PROTOCOL, "http");
	}

	public String getUrl() {
		String url = getProtocol() + "://" + getHost();
		String port = getPort();
		if (port != null && port.length() > 0 && !getPort().equals("80")) {
			url += ":" + port;
		}
		url += getPath();
		return url;
	}
}
