package org.swift.util.lang;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;


/**
 * 字节处理类<br>
 * @author 鲍庆丰<br>
 * @version 1.0<br>
 * 用法:<br>
 * 		System.out.println(CharUtil.hexString2Long("F8002200"));<br>

        System.out.println(CharUtil.intToHexString(1234));<br>

        byte[] b = new byte[5];<br>
        b[0] = 0x31; b[1]=0x32;b[2]=0x33;b[3]=0x34;b[4]=0x00;<br>
        System.out.println(CharUtil.byteToHexString(b[0]));<br>
        System.out.println(CharUtil.byteToString(b));<br>
        System.out.println(CharUtil.byteArrayToHexString(b));<br>
        System.out.println(CharUtil.byteArrayToHexString(b,2));<br>

        System.out.println(CharUtil.byte2int(b,2));<br>
 */
@Deprecated
public class CharUtil {

    private static String[] HexCode = {
            "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "a", "b", "c", "d",
            "e", "f"
        };

    /**
     * addSpace或者addZero时对齐方式<br>
     * ALIGN_LEFT为左对齐，右边补响应空格或者0<br>
     * ALIGN_RIGHT为右对齐，左边补响应空格或者0<br>
     */
    public static final int ALIGN_LEFT = 1;
    public static final int ALIGN_RIGHT = 2;

    /**
     * 字符串替换函数
     * @param sAll String   原来的字符串
     * @param older String  要替换掉的字符串
     * @param newer String  新的字符串
     * @return String       替换后的结果
     */
    public static String strReplace(String sAll, String sOld, String sNew) {
        int iT = 0;
        String sF = null;
        String sH = null;

        //如果新串中包括旧串,不让替多只让替少
        if (sNew.indexOf(sOld) != -1) {
            return sAll;
        }

        if ((sAll == null) || (sOld == null) || (sNew == null)) {
            return sAll;
        }

        iT = sAll.indexOf(sOld);

        //int i = 0;

        while (iT != -1) {
            sF = sAll.substring(0, iT);
            sH = sAll.substring(iT + sOld.length());
            sAll = sF + sNew + sH;
            iT = sAll.indexOf(sOld);
        }

        return sAll;
    }

    /**
     * 过滤接收字符{MO}
     * @param sMo String       转换前字符
     * @return boolean         转换后字符
     * @说明
     */
    public static String convertMoString(String sMo) {
        String sReturn = sMo;

        if (sReturn == null) {
            return sReturn;
        }

        try {
            sReturn = sReturn.toUpperCase();
            sReturn = sReturn.replace('，', ',');
            sReturn = sReturn.replace('。', '.');
            sReturn = sReturn.replace('；', ';');
            sReturn = sReturn.replace('！', '!');
            sReturn = sReturn.replace('？', '?');
            sReturn = sReturn.replace('：', ':');
            sReturn = sReturn.replace('"', '＂');
            sReturn = sReturn.replace('“', '＂');
            sReturn = sReturn.replace('”', '＂');
            sReturn = sReturn.replace('-', ' ');
            sReturn = sReturn.replace('_', ' ');
            sReturn = sReturn.replace('，', ',');
            sReturn = sReturn.replace('０', '0');
            sReturn = sReturn.replace('１', '1');
            sReturn = sReturn.replace('２', '2');
            sReturn = sReturn.replace('３', '3');
            sReturn = sReturn.replace('４', '4');
            sReturn = sReturn.replace('５', '5');
            sReturn = sReturn.replace('６', '6');
            sReturn = sReturn.replace('７', '7');
            sReturn = sReturn.replace('８', '8');
            sReturn = sReturn.replace('９', '9');
            sReturn = strReplace(sReturn, "‘", "'");
        } catch (Exception ex) {
            return sMo;
        }

        return sReturn;
    }

    /**
     * 过滤接收字符{MT}
     * @param sMo String       转换前字符
     * @return boolean         转换后字符
     * @说明
     */
    public static String convertMtString(String sMt) {
        String sReturn = sMt;

        if (sReturn == null) {
            return sReturn;
        }

        try {
            sReturn = strReplace(sReturn, "‘", "'");
            sReturn = sReturn.replace('，', ',');
            sReturn = sReturn.replace('。', '.');
            sReturn = sReturn.replace('；', ';');
            sReturn = sReturn.replace('！', '!');
            sReturn = sReturn.replace('？', '?');
            sReturn = sReturn.replace('：', ':');
            sReturn = sReturn.replace('"', '＂');
            sReturn = sReturn.replace('“', '＂');
            sReturn = sReturn.replace('”', '＂');
        } catch (Exception ex) {
            return sMt;
        }

        return sReturn;
    }

    /**
     * 作者：清风<br>
     * 生成日期：2007-12-28 下午02:57:44<br>
     * 功能描述：判断字符串是否为纯数字<br>
     * @param msg
     * @return
     */
    public static boolean isNumeric(String msg) {
        try {
            Long.parseLong(msg);
        } catch (Exception ex) {
            return false;
        }

        return true;
    }

    /**
     *  一个字节转换为16进制字符串<br>
     *  例如 byte = 0x12 ---->  "12"<br>
     */
    public static String byteToHexString(byte b) {
        int n = b;

        if (n < 0) {
            n = 256 + n;
        }

        int d1 = n / 16;
        int d2 = n % 16;

        return HexCode[d1] + HexCode[d2];
    }

    /**
     *  int转换为16进制字符串<br>
     *  例如 int = 1234 ---->  "000004d2"<br>
     */
    public static String intToHexString(int i) {
        byte[] bt = int2byte(i);

        return byteArrayToHexString(bt);
    }

    /**
     * 字节数组转换为字符串<br>
     * byte[0] = 0x31; byte[1]=0x32;byte[3]=0x00; ---> "12"<br>
     */
    public static String byteToString(byte[] b) {
        if ((b == null) || (b.length == 0) || (b[0] == 0)) {
            return "";
        }

        int i = 0;

        for (i = 0; i < b.length; i++) {
            if (b[i] == 0) {
                break;
            }
        }

        byte[] rb = new byte[i];

        System.arraycopy(b, 0, rb, 0, i);

        return new String(rb);
    }

    /**
     * 字节数组转换为16进制字符串<br>
     * byte[0] = 0x31; byte[1]=0x32;byte[2]=0x00; ---> "313200"<br>
     */
    public static String byteArrayToHexString(byte[] b) {
        String result = "";

        for (int i = 0; i < b.length; i++)
            result = result + byteToHexString(b[i]);

        return result;
    }

    /**
     * 取字节流指定长度前的字节数组转换为16进制字符串<br>
     * byte[0] = 0x31; byte[1]=0x32;byte[2]=0x00; byteArrayToHexString(b,2) ---> "3132"<br>
     */
    public static String byteArrayToHexString(byte[] b, int nEnd) {
        String result = "";

        if (nEnd > b.length) {
            return "";
        }

        for (int i = 0; i < nEnd; i++)
            result = result + byteToHexString(b[i]);

        return result;
    }

    /**
     *
     * byte[0] = 0x31; byte[1]=0x32;byte[2]=0x00; byteArrayToHexString(b,2) ---> "3132"
     */
    public static int byte2int(byte[] b, int offset) {
        return (b[offset + 3] & 0xff) | ((b[offset + 2] & 0xff) << 8) |
        ((b[offset + 1] & 0xff) << 16) | ((b[offset] & 0xff) << 24);
    }

    public static int byte2int(byte[] b) {
        return (b[3] & 0xff) | ((b[2] & 0xff) << 8) | ((b[1] & 0xff) << 16) |
        ((b[0] & 0xff) << 24);
    }

    public static long byte2long(byte[] b) {
        return ((long) b[7] & (long) 255) | (((long) b[6] & (long) 255) << 8) |
        (((long) b[5] & (long) 255) << 16) |
        (((long) b[4] & (long) 255) << 24) |
        (((long) b[3] & (long) 255) << 32) |
        (((long) b[2] & (long) 255) << 40) |
        (((long) b[1] & (long) 255) << 48) | ((long) b[0] << 56);
    }

    public static long byte2long(byte[] b, int offset) {
        return ((long) b[offset + 7] & (long) 255) |
        (((long) b[offset + 6] & (long) 255) << 8) |
        (((long) b[offset + 5] & (long) 255) << 16) |
        (((long) b[offset + 4] & (long) 255) << 24) |
        (((long) b[offset + 3] & (long) 255) << 32) |
        (((long) b[offset + 2] & (long) 255) << 40) |
        (((long) b[offset + 1] & (long) 255) << 48) | ((long) b[offset] << 56);
    }

    public static byte[] int2byte(int n) {
        byte[] b = new byte[4];
        b[0] = (byte) (n >> 24);
        b[1] = (byte) (n >> 16);
        b[2] = (byte) (n >> 8);
        b[3] = (byte) n;

        return b;
    }

    /**
     *  16进制输出byte[]<br>
     *  例如 byte[0] = 1 byte[1] = 2 ---->  0x3132<br>
     */
    static public String rhex(byte[] in) {
        DataInputStream data = new DataInputStream(new ByteArrayInputStream(in));
        String str = "0x";

        try {
            for (int j = 0; j < in.length; j++) {
                String tmp = Integer.toHexString(data.readUnsignedByte());

                if (tmp.length() == 1) {
                    tmp = "0" + tmp;
                }

                str = str + tmp;
            }
        } catch (Exception ex) {
        }

        return str;
    }

    /**
     *n 为待转数据，buf[]为转换后的数据，offset为buf[]中转换的起始点<br>
     * 转换后数据从低到高位<br>
     */
    public static void int2byte(int n, byte[] buf, int offset) {
        buf[offset] = (byte) (n >> 24);
        buf[offset + 1] = (byte) (n >> 16);
        buf[offset + 2] = (byte) (n >> 8);
        buf[offset + 3] = (byte) n;
    }

    public static byte[] short2byte(int n) {
        byte[] b = new byte[2];
        b[0] = (byte) (n >> 8);
        b[1] = (byte) n;

        return b;
    }

    public static void short2byte(int n, byte[] buf, int offset) {
        buf[offset] = (byte) (n >> 8);
        buf[offset + 1] = (byte) n;
    }

    public static byte[] long2byte(long n) {
        byte[] b = new byte[8];
        b[0] = (byte) (int) (n >> 56);
        b[1] = (byte) (int) (n >> 48);
        b[2] = (byte) (int) (n >> 40);
        b[3] = (byte) (int) (n >> 32);
        b[4] = (byte) (int) (n >> 24);
        b[5] = (byte) (int) (n >> 16);
        b[6] = (byte) (int) (n >> 8);
        b[7] = (byte) (int) n;

        return b;
    }

    public static void long2byte(long n, byte[] buf, int offset) {
        buf[offset] = (byte) (int) (n >> 56);
        buf[offset + 1] = (byte) (int) (n >> 48);
        buf[offset + 2] = (byte) (int) (n >> 40);
        buf[offset + 3] = (byte) (int) (n >> 32);
        buf[offset + 4] = (byte) (int) (n >> 24);
        buf[offset + 5] = (byte) (int) (n >> 16);
        buf[offset + 6] = (byte) (int) (n >> 8);
        buf[offset + 7] = (byte) (int) n;
    }

    public static long hexString2Long(String hexString) {
        long l = 0;

        if ((hexString == null) || (hexString.length() == 0)) {
            return l;
        }

        String lowHexString = hexString.toUpperCase();
        int len = lowHexString.length();

        for (int i = 0; i < len; i++) {
            int chr = lowHexString.charAt(len - i - 1);

            if ((chr >= 0x30) && (chr <= 0x39)) {
                l += ((chr - 0x30) * Math.pow(16, i));
            } else if ((chr >= 0x41) && (chr <= 0x46)) {
                l += ((chr - 0x41 + 10) * Math.pow(16, i));
            } else {
                return 0;
            }
        }

        return l;
    }

    public static String addZero(String info, int len, int align) {
        if (info == null) {
            return null;
        }

        String str = new String(info);
        int nLen = str.length();

        while (nLen < len) {
            if (align == ALIGN_LEFT) {
                str = str + "0";
            } else if (align == ALIGN_RIGHT) {
                str = "0" + str;
            }

            nLen++;
        }

        return str;
    }

    /**
     * 补空格
     * @param info
     * @param len
     * @param align
     * @return
     */
    public static String addSpace(String info, int len, int align) {
        if (info == null) {
            return null;
        }

        String str = new String(info);
        int nLen = str.length();

        while (nLen < len) {
            if (align == ALIGN_LEFT) {
                str = str + " ";
            } else if (align == ALIGN_RIGHT) {
                str = " " + str;
            }

            nLen++;
        }

        return str;
    }

    /**
     * 补指定字符
     * @param info
     * @param len
     * @param spec
     * @param align
     * @return
     */
    public static byte[] addSpec(byte[] info, int len, byte spec, int align) {
        if (info == null) {
            return null;
        }

        int nCopy = info.length;

        if (info.length > len) {
            nCopy = len;
        }

        byte[] str = new byte[len];

        if (align == ALIGN_LEFT) {
            System.arraycopy(info, 0, str, 0, nCopy);
        } else if (align == ALIGN_RIGHT) {
            System.arraycopy(info, 0, str, len - nCopy, nCopy);
        }

        int nLen = info.length;
        int i = 0;

        while (nLen < len) {
            if (align == ALIGN_LEFT) {
                str[nLen++] = spec;
            } else if (align == ALIGN_RIGHT) {
                str[i++] = spec;
                nLen++;
            }
        }

        return str;
    }

    //子字节串
    public static byte[] subbyte(byte[] info, int start, int len) {
        if ((info == null) || (info.length < (len + start))) {
            return null;
        }

        byte[] str = new byte[len];
        System.arraycopy(info, start, str, 0, len);

        return str;
    }

    static public void main(String[] args) throws Exception {
    	System.out.println(CharUtil.hexString2Long("F8002200"));

        System.out.println(CharUtil.intToHexString(1234));

        byte[] b = new byte[5];
        b[0] = 0x31; b[1]=0x32;b[2]=0x33;b[3]=0x34;b[4]=0x00;
        System.out.println(CharUtil.byteToHexString(b[0]));
        System.out.println(CharUtil.byteToString(b));
        System.out.println(CharUtil.byteArrayToHexString(b));
        System.out.println(CharUtil.byteArrayToHexString(b,2));

        System.out.println(CharUtil.byte2int(b,2));
        //String dd = CharUtil.addZero(String.valueOf(11), 4, CharUtil.ALIGN_RIGHT);
        //String ddd = "";
    }


}
