package org.swift.util.lang;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;


/**
 * ID号生成<br>
 * 鲍庆丰<br>
 * baoqingfeng@gmail.com<br>
 */
@Deprecated
public class IdGen {
    private static final String[] allchars = {
            "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "a", "b", "c", "d",
            "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r",
            "s", "t", "u", "v", "w", "x", "y", "z", "~", "`", "!", "@", "A", "B",
            "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P",
            "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z", "#", "$", "%", "^",
            "&", "*", "(", ")", "-", "_", "=", "+", "{", "[", "]", "}", "|",
            "\\", "'", "\"", "/", "?", ".", ">", "<", ","
        };
    private static final String[] num_abc_chars = {
            "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "a", "b", "c", "d",
            "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r",
            "s", "t", "u", "v", "w", "x", "y", "z", "A", "B", "C", "D", "E", "F",
            "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T",
            "U", "V", "W", "X", "Y", "Z"
        };
    private static final String[] num_chars = {
            "0", "1", "2", "3", "4", "5", "6", "7", "8", "9"
        };

    public static void main(String[] args) throws Exception {
        System.out.println(genRandNum(6));
    }

    public synchronized static long getId(String file) {
        return gen(file);
    }

    /**
     * 从allchars获得一个长度为len随机字符
     * @param len
     * 		返回的随机字符的长度
     * @return
     * @throws Exception
     */
    public static String genRandTextInAllChar(int len)
        throws Exception {
        int i = 0;
        int maxLen = allchars.length;
        int index = 0;
        StringBuffer b = new StringBuffer();

        for (i = 0; i < len; i++) {
            index = (int) (java.lang.Math.random() * maxLen);
            b.append(allchars[index]);
        }

        return b.toString();
    }

    /**
     * 从num_abc_chars获得一个长度为len随机字符
     * @param len
     * @return
     * @throws Exception
     */
    public static String genRandText(int len) throws Exception {
        int i = 0;
        int maxLen = num_abc_chars.length;
        int index = 0;
        StringBuffer b = new StringBuffer();

        for (i = 0; i < len; i++) {
            index = (int) (java.lang.Math.random() * maxLen);
            b.append(num_abc_chars[index]);
        }

        return b.toString();
    }

    /**
     * 从num_chars获得一个长度为len随机数字
     * @param len
     * @return
     * @throws Exception
     */
    public static String genRandNum(int len) throws Exception {
        int i = 0;
        int maxLen = num_chars.length;
        int index = 0;
        StringBuffer b = new StringBuffer();

        for (i = 0; i < len; i++) {
            index = (int) (java.lang.Math.random() * maxLen);
            b.append(num_chars[index]);
        }

        return b.toString();
    }

    /**
     * 生成id
     * @param file
     * @return
     */
    private static long gen(String file) {
        long lid = 0;
        FileReader fileReader = null;
        BufferedReader mBufReader = null;
        FileWriter fileWriter = null;
        BufferedWriter mBufWriter = null;

        try {
            if (!createFile(file)) {
                return 168;
            }

            fileReader = new FileReader(file);
            mBufReader = new BufferedReader(fileReader);

            String id = mBufReader.readLine();

            if ((id == null) || (id.length() == 0)) {
                id = "0";
            }

            lid = new Long(id).longValue();
            mBufReader.close();
            fileReader.close();

            fileWriter = new FileWriter(file);
            mBufWriter = new BufferedWriter(fileWriter);
            fileWriter.write(new Long(lid + 1).toString());

            mBufWriter.flush();
            mBufWriter.close();
        } catch (Throwable e) {
            try {
                fileReader.close();
                mBufReader.close();
                fileWriter.close();
                mBufWriter.close();
            } catch (Throwable t) {
            }

            ;
        }

        return lid;
    }

    /**
     * 创建一个文件名为fileName的文件
     * @param fileName
     * @return
     * @throws IOException
     * @throws Exception
     */
    public static boolean createFile(String fileName)
        throws IOException, Exception {
        File file = new File(fileName);

        if (file.exists()) /* does file exist? If so, can it be written to */ {
            if (file.canWrite() == false) {
                return false;
            }
        } else {
            String path = null; /* Does not exist.  Create the directories */

            int firstSlash = fileName.indexOf(File.separatorChar);
            int finalSlash = fileName.lastIndexOf(File.separatorChar);

            if (finalSlash == 0) { /* error, not valid path */
            } else if (finalSlash == 1) /* UNIX root dir */ {
                path = File.separator;
            } else if (firstSlash == finalSlash) { /* for example c:\  Then make sure slash is part of path */
                path = fileName.substring(0, finalSlash + 1);
            } else {
                path = fileName.substring(0, finalSlash);
            }

            File dir = new File(path);
            dir.mkdirs();
        }

        return true;
    }
}
