package org.swift.util.lang;

import java.util.Random;
import java.util.UUID;

/**
 * 杭州优恒网络技术有限公司
 * 
 * 作者：yesw
 * 
 * 功能描述：ID号生成器
 * 
 */
public class IdGenerator {
	private static final String[] allchars = { "0", "1", "2", "3", "4", "5", "6", "7", "8", "9",
			"a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q",
			"r", "s", "t", "u", "v", "w", "x", "y", "z", "~", "`", "!", "@", "A", "B", "C", "D",
			"E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U",
			"V", "W", "X", "Y", "Z", "#", "$", "%", "^", "&", "*", "(", ")", "-", "_", "=", "+",
			"{", "[", "]", "}", "|", "\\", "'", "\"", "/", "?", ".", ">", "<", "," };
	private static final String[] num_abc_chars = { "0", "1", "2", "3", "4", "5", "6", "7", "8",
			"9", "a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p",
			"q", "r", "s", "t", "u", "v", "w", "x", "y", "z", "A", "B", "C", "D", "E", "F", "G",
			"H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X",
			"Y", "Z" };
	private static final String[] num_chars = { "0", "1", "2", "3", "4", "5", "6", "7", "8", "9" };

	private static final String[] hex_chars = { "0", "1", "2", "3", "4", "5", "6", "7", "8", "9" , "A", "B", "C", "D", "E", "F"};

	public static String getRandString(String[] chars, int len) {
		if (chars == null) {
			return null;
		}
		int i = 0;
		int maxLen = chars.length;
		int index = 0;
		StringBuffer b = new StringBuffer();
		Random random = new Random();
		for (i = 0; i < len; i++) {
			index = random.nextInt(maxLen);
			b.append(chars[index]);
		}
		return b.toString();
	}

	/**
	 * 从hexchars获得一个长度为len随机字符
	 * 
	 * @param len
	 *            返回的随机字符的长度
	 * @return
	 * @throws Exception
	 */
	public static String getHexChar(int len) throws Exception {
		return getRandString(hex_chars, len);
	}
	/**
	 * 从allchars获得一个长度为len随机字符
	 * 
	 * @param len
	 *            返回的随机字符的长度
	 * @return
	 * @throws Exception
	 */
	public static String getRandTextInAllChar(int len) throws Exception {
		return getRandString(allchars, len);
	}

	/**
	 * 从num_abc_chars获得一个长度为len随机字符
	 * 
	 * @param len
	 * @return
	 * @throws Exception
	 */
	public static String getRandText(int len) throws Exception {
		return getRandString(num_abc_chars, len);
	}

	/**
	 * 从num_chars获得一个长度为len随机数字
	 * 
	 * @param len
	 * @return
	 * @throws Exception
	 */
	public static String getRandNum(int len) throws Exception {
		return getRandString(num_chars, len);
	}

	/**
	 * 用UUID取id
	 * 
	 * @return
	 */
	public static String getUUID() {
		UUID uuid = UUID.randomUUID();
		return uuid.toString().replace("-", "");
	}
}
