package org.swift.util.lang;

import java.io.UnsupportedEncodingException;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.swift.util.encrypt.Security;

/**
 * 字符串处理<br>
 * 鲍庆丰<br>
 * baoqingfeng@gmail.com<br>
 */
public class StringUtil {

	/**
	 * @param s
	 * @return 字符串
	 */
	@Deprecated
	public static String GetString(String s) {
		try {
			return new String(s.getBytes("ISO8859_1"));
		} catch (UnsupportedEncodingException e) {
			e.printStackTrace();
		}

		return "";
	}

	/**
	 * @param s
	 * @return 判断字符串s是不是数字
	 */
	public static boolean IsNumber(String s) {
		Pattern pattern = Pattern.compile("[0-9]*");
		Matcher isNum = pattern.matcher(s);
		if (!isNum.matches()) {
			return false;
		}
		return true;

	}

	/**
	 * @param s
	 * @return 判断字符串s是不是IP地址
	 */
	public static boolean IsIpAddress(String s) {
		String strMatch = "^(\\d{1,2}|1\\d\\d|2[0-4]\\d|25[0-5])\\.(\\d{1,2}|1\\d\\d|2[0-4]\\d|25[0-5])\\.(\\d{1,2}|1\\d\\d|2[0-4]\\d|25[0-5])\\.(\\d{1,2}|1\\d\\d|2[0-4]\\d|25[0-5])$";
		Pattern ParsePattern = Pattern.compile(strMatch);
		Matcher ParseMatcher = ParsePattern.matcher(s);

		// boolean a = ParseMatcher.find();
		return ParseMatcher.find();
	}

	/**
	 * @param s
	 * @return 判断字符串s是不是域名
	 */
	public static boolean IsDomainName(String s) {
		String strMatch = "[a-zA-Z0-9]+([a-zA-Z0-9\\-\\.]+)?\\.(com|cn|org|net|mil|edu|COM|ORG|NET|MIL|EDU)";
		Pattern ParsePattern = Pattern.compile(strMatch);
		Matcher ParseMatcher = ParsePattern.matcher(s);

		return ParseMatcher.find();
	}

	/**
	 * @param s
	 * @return 判断字符串s是不是EMAIL地址
	 */
	public static boolean IsEmailAddr(String s) {
		String strMatch = "[\\w\\.\\-]+@([\\w\\-]+\\.)+[\\w\\-]";
		Pattern ParsePattern = Pattern.compile(strMatch);
		Matcher ParseMatcher = ParsePattern.matcher(s);

		return ParseMatcher.find();
	}

	/**
	 * @param d
	 * @param pL
	 * @return 格式化d(double),得到pL位小数的实数
	 */
	public static String GetStandardDouble(double d, int pL) {
		String format = "0.";

		for (int i = 0; i < pL; i++)
			format += "0";

		return ((new DecimalFormat(format)).format(d));
	}

	/**
	 * @param time
	 * @param pattern
	 * @return 格式化时间截,并按照pattern的格式返回时间字符串
	 */
	@Deprecated
	public static String LongTimeToString(long time, String pattern) {
		SimpleDateFormat sdf = new SimpleDateFormat(pattern);
		Date dtTime = new Date(time);

		return sdf.format(dtTime);
	}

	/**
	 * 产生num位数字随机数
	 * 
	 * @param num
	 * @return
	 */
	public static String GetRandValue(int num) {
		String sRand = "";
		Random random = new Random();

		for (int i = 0; i < num; i++) {
			String rand = String.valueOf(random.nextInt(10));
			sRand += rand;
		}

		return sRand;
	}

	/**
	 * @return 经过MD5加密的字符串
	 */
	@Deprecated
	public static String GetRandValue32() {
		return Security.MD5(String.valueOf(new Date().getTime()));
	}

	/**
	 * 秒转换为时分秒格式
	 * 
	 * @param second
	 *            秒
	 * @return
	 */
	@Deprecated
	public static String SecToHour(int second) {
		int min = second / 60;
		int sec = second % 60;
		int hour = 0;

		if (min >= 60) {
			hour = min / 60;
			min = min - (hour * 60);
		}

		StringBuffer sb = new StringBuffer();

		if (hour != 0) {
			sb.append(hour);
			sb.append("小时");
		}

		if (min != 0) {
			sb.append(min);
			sb.append("分");
		}

		sb.append(sec);
		sb.append("秒");

		return sb.toString();
	}

	/**
	 * @param str
	 * @return 判断字符串是否为空,或者null
	 */
	public static boolean isEmpty(String str) {
		return (str == null) || (str.length() == 0);
	}

	/**
	 * @param str
	 * @return 判断字符串是否不为空,或者null
	 */
	public static boolean isNotEmpty(String str) {
		return !isEmpty(str);
	}

	/**
	 * 功能描述：加密转义字符
	 * 
	 * @param context
	 * @return
	 */
	public static String encryptEscapeChar(String context) {
		if (context == null) {
			return null;
		}
		context = context.replace("\\", "\\\\");
		context = context.replace("\n", "\\n");
		context = context.replace("\t", "\\t");
		context = context.replace("\r", "\\r");
		context = context.replace("\'", "\\\'");
		context = context.replace("\"", "\\\"");
		return context;
	}

	/**
	 * 功能描述：解密转义字符
	 * 
	 * @param context
	 * @return
	 */
	public static String decryptEscapeChar(String context) {
		if (context == null) {
			return null;
		}
		context = context.replaceAll("(?<=^|[^\\\\](?:\\\\\\\\){0,100})\\\\n", "\n");
		context = context.replaceAll("(?<=^|[^\\\\](?:\\\\\\\\){0,100})\\\\r", "\r");
		context = context.replaceAll("(?<=^|[^\\\\](?:\\\\\\\\){0,100})\\\\t", "\t");
		context = context.replaceAll("(?<=^|[^\\\\](?:\\\\\\\\){0,100})\\\\'", "\'");
		context = context.replaceAll("\\\\\"", "\"");
		context = context.replaceAll("\\\\\\\\", "\\\\");
		return context;
	}

	public static boolean isStr(String sourseStr) {
		if ((sourseStr != null) && !sourseStr.equals("") && !sourseStr.equals("null")) {
			return true;
		} else {
			return false;
		}
	}

	public static boolean isThisStr(String sourseStr, String targetStr) {
		if (isStr(sourseStr) && sourseStr.equals(targetStr)) {
			return true;
		} else {
			return false;
		}
	}

	public static void main(String[] args) {
		// String s = "selsjdfk \nlsdfsdjfd \\rskfhksf\rnsfhksdffdsf";
		// System.out.println(s);
		// System.out.println("_____________________________");
		// s = StringUtil.encryptEscapeChar(s);
		// System.out.println(s);
		// System.out.println("_____________________________");
		// s = StringUtil.decryptEscapeChar(s);
		// System.out.println(s);
		System.out.println(IsEmailAddr("aaad.dd@ddsgfsdfsef.com"));
		System.out.println(IsEmailAddr("aaaddd@ddsgfsdfsef.com"));
		System.out.println(IsEmailAddr("aaa_ddd@ddsgfsdfsef.dd"));
		System.out.println(IsEmailAddr("111111@ddsgfsdfsef.com"));
		System.out.println(IsEmailAddr("aaa.sef.com"));
		System.out.println(IsEmailAddr("aa"));
		System.out.println(IsEmailAddr("aaa.ddd@d"));
	}
}
