package org.swift.util.mail;


import java.io.IOException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;

import org.swift.util.http.WebClient;


/**
 * 发送邮件类<br>
 * 
 *         例:<br>
 *         System.out.println(SendMail.SendMailForm("post@from.com",
 *         "mail@to.com", "通过SendMailForm发送", "我是猪头1"));<br>
 *         System.out.println(SendMail.SendMailByPost("post@from.com",
 *         "mail@to.com", "通过SendMailByPost发送", "测试"));<br>
 *         Map<String ,String> map = new HashMap<String ,String>();<br>
 *         map.put("username", "baoqf撒旦发 ");<br>
 *         map.put("answer", "asdkjf大莱卡时代精神看");<br>
 *         System.out.println(SendMail.SendMailByTemplete("mail@to.com",
 *         "set_passwd_protect", map));<br>
 */
public class SendMail {

	// public final static String SMS_Srv_URL =
	// "http://send.uuca11.com:580/mail/";
	// public final static String SMS_Srv_URL = "http://127.0.0.1/";

	/**
	 * 从from发送邮件content到to
	 * 
	 * @param from
	 * @param to
	 * @param title
	 * @param content
	 * @return 发送结果
	 */
	public static boolean SendMailForm(String emailSrvUrl, String from,
			String to, String title, String content) {
		try {
			String sendmailURL = emailSrvUrl + "/mail?from=" + from + "&to="
					+ to + "&title=" + URLEncoder.encode(title, "utf-8")
					+ "&content=" + URLEncoder.encode(content, "utf-8");
			String respBody = WebClient.retrieveWebContent(sendmailURL);
			if (respBody == null)
				return false;
			String ret[] = respBody.split(" ");
			if (ret == null || ret.length == 0)
				return false;
			if (Integer.parseInt(ret[0]) == 0) {
				return true;
			} else {
				System.out.println("sendmail returnCode:" + ret[0] + " url:"
						+ sendmailURL);
			}
		} catch (Exception e) {
			e.printStackTrace();
		}

		return false;
	}

	/**
	 * 通过POST方式发送邮件
	 * 
	 * @param from
	 * @param to
	 * @param title
	 * @param content
	 * @return
	 */
	public static boolean SendMailByPost(String emailSrvUrl, String from,
			String to, String title, String content) {
		try {
			String sendmailURL = emailSrvUrl + "/mail";
			Map<String, String> map = new HashMap<String, String>();
			map.put("from", from);
			map.put("to", to);
			map.put("title", title);
			map.put("content", content);
			String respBody = WebClient.post(sendmailURL, map);
			if (respBody == null)
				return false;
			String ret[] = respBody.split(" ");
			if (ret == null || ret.length == 0)
				return false;

			if (Integer.parseInt(ret[0]) == 0) {
				return true;
			} else {
				System.out.println("sendmail returnCode:" + ret[0] + " url:"
						+ sendmailURL);
			}
		} catch (Exception e) {
			e.printStackTrace();
		}

		return false;
	}

	/**
	 * 根据模板生成相应的内容发送邮件
	 * 
	 * @param to
	 * @param template_name
	 * @param map
	 * @return
	 */
	public static boolean SendMailByTemplete(String emailSrvUrl, String to,
			String template_name, Map<String, String> map) {
		try {
			String sendmailURL = emailSrvUrl + "/mailByTemplete";
			map.put("template_name", template_name);
			map.put("to", to);
			String respBody = WebClient.post(sendmailURL, map);
			if (respBody == null)
				return false;
			String ret[] = respBody.split(" ");
			if (ret == null || ret.length == 0)
				return false;

			if (Integer.parseInt(ret[0]) == 0) {
				return true;
			} else {
				System.out.println("sendmail returnCode:" + ret[0] + " url:"
						+ sendmailURL);
			}
		} catch (Exception e) {
			e.printStackTrace();
		}

		return false;
	}

	/**
	 * @param args
	 * @throws IOException
	 */
	public static void main(String[] args) throws IOException {

		System.out.println(SendMail.SendMailForm(
				"http://core.serv.usl:8001/mail/", "post@from.com",
				"mail@to.com", "通过SendMailForm发送", "我是猪头1"));
		System.out.println(SendMail.SendMailByPost(
				"http://core.serv.usl:8001/mail/", "post@unihand.com",
				"mail@to.com", "通过SendMailByPost发送", "测试"));
		Map<String, String> map = new HashMap<String, String>();
		map.put("username", "baoqf撒旦发 ");
		map.put("answer", "asdkjf大莱卡时代精神看");
		System.out.println(SendMail.SendMailByTemplete(
				"http://core.serv.usl:8001/mail/", "mail@to.com",
				"set_passwd_protect", map));
	}

}
