package org.swift.util.misc;

/**
 * IP V4相关的操作和判断
 * 
 */
public class IPv4Util {

	private static String ipRegex;
	static {
		String regex0 = "(2[0-4]\\d)" + "|(25[0-5])";
		String regex1 = "1\\d{2}";
		String regex2 = "[1-9]\\d";
		String regex3 = "\\d";
		String regex = "(" + regex0 + ")|(" + regex1 + ")|(" + regex2 + ")|("
				+ regex3 + ")";
		regex = "(" + regex + ")\\.(" + regex + ")\\.(" + regex + ")\\.("
				+ regex + ")";
		ipRegex = regex;
	}

	/**
	 * @param ip
	 * @return IP中各个段的和
	 */
	public static long ip2Long(String ip) {
		long value = 0;
		if (isIp(ip)) {
			String[] nums = ip.split("\\.");
			for (String num : nums) {
				value *= 256;
				value += Integer.parseInt(num);
			}
		}
		return value;
	}

	/**
	 * @param ip
	 * @return 数字类型的IP转换成字符串类型的IP
	 */
	public static String stringIP(long ipValue) {
		if (ipValue < 0 || ipValue > 4294967295l) {
			return null;
		}
		String ip = "";
		while (ipValue > 0) {
			ip = "." + (ipValue % 256) + ip;
			ipValue /= 256;
		}
		ip = ip.substring(1);
		return ip;
	}

	/**
	 * 判断字符串ip是不是IP地址
	 * 
	 * @param ip
	 * @return
	 */
	public static boolean isIp(String ip) {
		return ip.matches(ipRegex);
	}

	public static void main(String[] ara) {
		System.out.println(ip2Long("255.255.255.254"));
		System.out.println(stringIP(913077248343434435l));
		System.out.println(isIp("2ff55.ff255.ff255.25566fff"));
	}
}
