/*
 * Decompiled with CFR 0.152.
 */
package com.jd.wlogin.interceptor;

import com.jd.wlogin.api.ClientInfo;
import com.jd.wlogin.api.VerifyAppLoginResult;
import com.jd.wlogin.api.VerifyH5LoginResult;
import com.jd.wlogin.api.VerifyPcLoginResult;
import com.jd.wlogin.api.VerifyWQTokenResult;
import com.jd.wlogin.api.WLoginHelper;
import com.jd.wlogin.utils.RequestUtils;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TicketInterceptor
implements HandlerInterceptor {
    private static final Logger log = LoggerFactory.getLogger(TicketInterceptor.class);
    private WLoginHelper wloginHelper;
    private Set<String> excludePrefixs;
    private String ticketType;
    private int appid;
    private boolean isNeedJsonValue;
    private String biz;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        String pin;
        log.debug("start Interceptor");
        String path = request.getServletPath();
        if (!this.needTicket(path)) {
            return true;
        }
        log.debug(String.format("ticketType(%s), biz(%s)", this.ticketType, this.biz));
        if ("app".equals(this.ticketType)) {
            pin = this.doVerifyApp(request);
        } else if ("m".equals(this.ticketType)) {
            pin = this.doVerifyM(request);
        } else if ("pc".equals(this.ticketType)) {
            pin = this.doVerifyPc(request);
        } else if ("wq".equals(this.ticketType)) {
            pin = this.doVerifyWq(request);
        } else {
            String appTicket = RequestUtils.getAppTicket(request);
            String mTicket = RequestUtils.getMTicket(request);
            String pcTicket = RequestUtils.getPcTicket(request);
            String wqTicket = RequestUtils.getWqTicket(request);
            if (StringUtils.isNotEmpty((String)appTicket)) {
                pin = this.doVerifyApp(request);
            } else if (StringUtils.isNotEmpty((String)mTicket)) {
                pin = this.doVerifyM(request);
            } else if (StringUtils.isNotEmpty((String)pcTicket)) {
                pin = this.doVerifyPc(request);
            } else if (StringUtils.isNotEmpty((String)wqTicket)) {
                pin = this.doVerifyWq(request);
            } else {
                return true;
            }
        }
        if (pin == null || pin.length() == 0) {
            return true;
        }
        request.setAttribute("login_pin", (Object)pin);
        return true;
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
    }

    public boolean needTicket(String path) {
        if (this.excludePrefixs == null || this.excludePrefixs.isEmpty()) {
            return Boolean.TRUE;
        }
        for (String prefix : this.excludePrefixs) {
            if (!path.startsWith(prefix)) continue;
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public String doVerifyApp(HttpServletRequest request) {
        ClientInfo clientInfo = RequestUtils.getClientInfo(request);
        String ticket = RequestUtils.getAppTicket(request);
        log.debug(String.format("%s, appid(%d), tikcet(%s)", clientInfo.toString(), this.appid, ticket));
        VerifyAppLoginResult result = this.wloginHelper.verifyAppLogin(this.appid, ticket, clientInfo);
        if (null != result && null != result.getPin() && !result.getPin().equals("")) {
            return result.getPin();
        }
        this.setErrors(request);
        log.error(String.format("verifyAppLogin failed, ticket(%s), sysErrCode(%d), errCode(%d)", ticket, this.wloginHelper.getSysErrCode(), this.wloginHelper.getErrCode()));
        return null;
    }

    public String doVerifyM(HttpServletRequest request) {
        ClientInfo clientInfo = RequestUtils.getClientInfo(request);
        String ticket = RequestUtils.getMTicket(request);
        log.debug(String.format("%s, appid(%d), tikcet(%s)", clientInfo.toString(), this.appid, ticket));
        VerifyH5LoginResult result = this.wloginHelper.verifyH5Login(this.appid, ticket, clientInfo, this.isNeedJsonValue);
        if (null != result && null != result.getPin() && !result.getPin().equals("")) {
            request.setAttribute("json", (Object)result.getJson());
            return result.getPin();
        }
        this.setErrors(request);
        log.error(String.format("verifyH5Login failed, ticket(%s), sysErrCode(%d), errCode(%d)", ticket, this.wloginHelper.getSysErrCode(), this.wloginHelper.getErrCode()));
        return null;
    }

    public String doVerifyPc(HttpServletRequest request) {
        ClientInfo clientInfo = RequestUtils.getClientInfo(request);
        String ticket = RequestUtils.getPcTicket(request);
        log.debug(String.format("%s, appid(%d), tikcet(%s)", clientInfo.toString(), this.appid, ticket));
        VerifyPcLoginResult result = this.wloginHelper.verifyPcLogin(this.appid, ticket, clientInfo);
        if (null != result && null != result.getPin() && !result.getPin().equals("")) {
            return result.getPin();
        }
        this.setErrors(request);
        log.error(String.format("verifyPcLogin failed, ticket(%s), sysErrCode(%d), errCode(%d)", ticket, this.wloginHelper.getSysErrCode(), this.wloginHelper.getErrCode()));
        return null;
    }

    public String doVerifyWq(HttpServletRequest request) {
        ClientInfo clientInfo = RequestUtils.getClientInfo(request);
        String ticket = RequestUtils.getWqTicket(request);
        log.debug(String.format("%s, appid(%d), tikcet(%s), biz(%s)", clientInfo.toString(), this.appid, ticket, this.biz));
        VerifyWQTokenResult result = this.wloginHelper.verifyWQAuthTokn(this.appid, this.biz, ticket, clientInfo);
        if (null != result && null != result.getPin() && !result.getPin().equals("")) {
            request.setAttribute("isDefaultPin", (Object)result.getIsDefaultPin());
            return result.getPin();
        }
        this.setErrors(request);
        log.error(String.format("verifyWQAuthTokn failed, ticket(%s), sysErrCode(%d), errCode(%d)", ticket, this.wloginHelper.getSysErrCode(), this.wloginHelper.getErrCode()));
        return null;
    }

    public void setErrors(HttpServletRequest request) {
        request.setAttribute("sysErrCode", (Object)this.wloginHelper.getSysErrCode());
        request.setAttribute("sysErrMsg", (Object)this.wloginHelper.getSysErrMsg());
        request.setAttribute("errCode", (Object)this.wloginHelper.getErrCode());
        request.setAttribute("errMsg", (Object)this.wloginHelper.getErrMsg());
    }

    public void setWloginHelper(WLoginHelper wloginHelper) {
        this.wloginHelper = wloginHelper;
    }

    public void setExcludePrefixs(Set<String> excludePrefixs) {
        this.excludePrefixs = excludePrefixs;
    }

    public void setTicketType(String ticketType) {
        this.ticketType = ticketType;
    }

    public int getAppid() {
        return this.appid;
    }

    public void setAppid(int appid) {
        this.appid = appid;
    }

    public Boolean isIsNeedJsonValue() {
        return this.isNeedJsonValue;
    }

    public void setIsNeedJsonValue(Boolean isNeedJsonValue) {
        this.isNeedJsonValue = isNeedJsonValue;
    }

    public String getBiz() {
        return this.biz;
    }

    public void setBiz(String biz) {
        this.biz = biz;
    }
}

