/*
 * Decompiled with CFR 0.152.
 */
package com.jd.wlogin.utils;

import com.jd.wlogin.api.ClientInfo;
import com.jd.wlogin.config.KeyNames;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;

public class RequestUtils {
    public static String getRemoteIp(HttpServletRequest request) {
        if (request == null) {
            return null;
        }
        String ip = request.getHeader("x-forwarded-for");
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        if (StringUtils.isNotEmpty((String)ip) && ip.contains(",")) {
            ip = ip.substring(0, ip.indexOf(","));
        }
        if (ip != null) {
            return ip.split(":")[0];
        }
        return null;
    }

    public static ClientInfo getClientInfo(HttpServletRequest request) {
        ClientInfo clientInfo = new ClientInfo();
        clientInfo.setClient(request.getParameter(KeyNames.KeyNameClientType));
        clientInfo.setClientIp(RequestUtils.getRemoteIp(request));
        clientInfo.setOsVersion(request.getParameter(KeyNames.KeyNameOsVersion));
        clientInfo.setAppName(request.getParameter(KeyNames.KeyNameAppName));
        clientInfo.setClientVersion(request.getParameter(KeyNames.KeyNameAppVersion));
        clientInfo.setNetworkType(request.getParameter(KeyNames.KeyNameNetworkType));
        clientInfo.setScreen(request.getParameter(KeyNames.KeyNameScreen));
        clientInfo.setUuid(request.getParameter(KeyNames.KeyNameUuid));
        clientInfo.setBuild(request.getParameter(KeyNames.KeyNameBuild));
        clientInfo.setPartner(request.getParameter(KeyNames.KeyNamePartner));
        return clientInfo;
    }

    public static String getAppTicket(HttpServletRequest request) {
        Cookie[] cookies = request.getCookies();
        if (cookies == null || cookies.length == 0) {
            return null;
        }
        for (Cookie cookie : cookies) {
            if (!KeyNames.KeyNameAppTicket.equals(cookie.getName())) continue;
            return cookie.getValue();
        }
        return null;
    }

    public static String getMTicket(HttpServletRequest request) {
        Cookie[] cookies = request.getCookies();
        if (cookies == null || cookies.length == 0) {
            return null;
        }
        for (Cookie cookie : cookies) {
            if (!KeyNames.KeyNameMTicket.equals(cookie.getName())) continue;
            return cookie.getValue();
        }
        return null;
    }

    public static String getPcTicket(HttpServletRequest request) {
        Cookie[] cookies = request.getCookies();
        if (cookies == null || cookies.length == 0) {
            return null;
        }
        for (Cookie cookie : cookies) {
            if (!KeyNames.KeyNamePcTicket.equals(cookie.getName())) continue;
            return cookie.getValue();
        }
        return null;
    }

    public static String getWqTicket(HttpServletRequest request) {
        Cookie[] cookies = request.getCookies();
        if (cookies == null || cookies.length == 0) {
            return null;
        }
        for (Cookie cookie : cookies) {
            if (!KeyNames.KeyNameWqTicket.equals(cookie.getName())) continue;
            return cookie.getValue();
        }
        return null;
    }
}

