/*
 * Decompiled with CFR 0.152.
 */
package com.jd.wlogin.api;

import com.jd.wlogin.api.ClientInfo;
import com.jd.wlogin.api.GainLoginModeResult;
import com.jd.wlogin.api.GetAppLoginResultAccount;
import com.jd.wlogin.api.KplClientInfo;
import com.jd.wlogin.api.ReqJumpTokenResult;
import com.jd.wlogin.api.VerifyAppLoginResult;
import com.jd.wlogin.api.VerifyH5LoginResult;
import com.jd.wlogin.api.VerifyISVLoginResult;
import com.jd.wlogin.api.VerifyJumpTokenResult;
import com.jd.wlogin.api.VerifyKplLoginResult;
import com.jd.wlogin.api.VerifyLoginResult;
import com.jd.wlogin.api.VerifyOpenAccessTokenResult;
import com.jd.wlogin.api.VerifyPcLoginResult;
import com.jd.wlogin.api.VerifyQRTicketResult;
import com.jd.wlogin.api.VerifySidResult;
import com.jd.wlogin.api.VerifySmartLoginResult;
import com.jd.wlogin.api.VerifyThirdLoginResult;
import com.jd.wlogin.api.VerifyWQTokenResult;
import com.jd.wlogin.cc.config_request;
import com.jd.wlogin.default_setting.default_setting;
import com.jd.wlogin.report.report_agent;
import com.jd.wlogin.server.server_request;
import com.jd.wlogin.tlv_type.kpl.Tlv0x8;
import com.jd.wlogin.tlv_type.open.tlv_0x77;
import com.jd.wlogin.tlv_type.open.tlv_0x82;
import com.jd.wlogin.tlv_type.tlv_0x10;
import com.jd.wlogin.tlv_type.tlv_0x11;
import com.jd.wlogin.tlv_type.tlv_0x17;
import com.jd.wlogin.tlv_type.tlv_0x1d;
import com.jd.wlogin.tlv_type.tlv_0x2f;
import com.jd.wlogin.tlv_type.tlv_0x3;
import com.jd.wlogin.tlv_type.tlv_0x30;
import com.jd.wlogin.tlv_type.tlv_0x50;
import com.jd.wlogin.tlv_type.tlv_0x58;
import com.jd.wlogin.tlv_type.tlv_0x8;
import com.jd.wlogin.tlv_type.tlv_0xa;
import com.jd.wlogin.tlv_type.tlv_0xe;
import com.jd.wlogin.tools.TypeConvertKpl;
import com.jd.wlogin.tools.message_byte_array_result;
import com.jd.wlogin.tools.message_decoder;
import com.jd.wlogin.tools.message_encoder;
import com.jd.wlogin.tools.util;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class WLoginHelperImpl {
    public static final int kSuccess = 0;
    public static final int kNetworkFailed = -1;
    public static final int kMessageCheckFailed = -2;
    public static final int kRecvMsgDecodeFailed = -3;
    public static final int kInputParameterError = -4;
    public static final int kPinEncodeFailed = -5;
    public static final int kPinTooLong = -6;
    public static final int kCookieTooLong = -7;
    private static final String kVerifyServiceName = "VerifyService";
    private static final String kVerifyServiceExName = "VerifyServiceEx";
    private static final String kQRVerifyServiceName = "QRVerifyService";
    private static final String kMVerifyServiceName = "MVerifyService";
    private static final String kMLoginServiceName = "MLoginService";
    private static final String kSidVerifyServiceName = "SidVerifyService";
    private static final String kOpenVerifyServiceName = "OpenVerifyService";
    private static final String kLoginTypeServiceName = "LoginTypeService";
    private static final String kPcVerifyServiceName = "PcVerifyService";
    private static final String kSmartVerifyServiceName = "SmartVerifyService";
    private static final String kISVVerifyServiceName = "ISVVerifyService";
    private static final String kKplVerifyServiceName = "KplVerifyService";
    private static final String kInterVerifyServiceName = "InterVerifyService";
    private static final String kInterMVerifyServiceName = "InterMVerifyService";
    private static final String kInterMLoginServiceName = "InterMLoginService";
    private static final String kInterOpenVerifyServiceName = "InterOpenVerifyService";
    private static final String kInterPcVerifyServiceName = "InterPcVerifyService";
    private static final String kWQVerifyServiceName = "WQVerifyService";
    private static final String kJOVerifyATServiceName = "Jdopen_VerifyATService";
    private static final String kMThirdVerifyServiceName = "MThirdVerifyService";
    private static final int kDefaultAppid = 100;
    private static final int kInterDefaultAppid = 400;
    private static final String kDefaultVerifyA4ClientList = "m|wh5|carm|afs-m|mrd|dshp|ld|mcoupon";
    private int status = 0;
    private int errCode = 0;
    private String errMsg = "";
    private String userErrMsg = "";
    private int sysErrCode = 0;
    private String sysErrMsg = "";
    private server_request serverRequest;
    private config_request _config_center_service = config_request.getInstance();
    private default_setting _default_setting = this._config_center_service.getDefaultSetting();
    private HashSet<String> _verifyA4ClientList = new HashSet();
    private Map<String, Integer> _appid_list = new HashMap<String, Integer>();
    private long _last_update_cc_time = 0L;
    private long _last_update_cc_time_appid_list = 0L;
    private int _cc_update_interval = 60000 + util.get_rand_32() % 500;
    private int _cc_update_interval_appid_list = 60000 + util.get_rand_32() % 500;
    private static ThreadLocal<WLoginHelperImpl> threadLocal = new ThreadLocal();

    private void clearErr() {
        this.status = 0;
        this.errCode = 0;
        this.errMsg = "";
        this.userErrMsg = "";
        this.sysErrCode = 0;
        this.sysErrMsg = "";
    }

    public int getStatus() {
        return this.status;
    }

    private void setStatus(int status) {
        this.status = status;
    }

    public int getErrCode() {
        return this.errCode;
    }

    private void setErrCode(int errCode) {
        this.errCode = errCode;
    }

    public String getErrMsg() {
        return this.errMsg;
    }

    private void setErrMsg(String errMsg) {
        this.errMsg = errMsg;
    }

    public String getUserErrMsg() {
        return this.userErrMsg;
    }

    private void setUserErrMsg(String userErrMsg) {
        this.userErrMsg = userErrMsg;
    }

    public int getSysErrCode() {
        return this.sysErrCode;
    }

    private void setSysErrCode(int sysErrCode) {
        this.sysErrCode = sysErrCode;
    }

    public String getSysErrMsg() {
        return this.sysErrMsg;
    }

    private void setSysErrMsg(String sysErrMsg) {
        this.sysErrMsg = sysErrMsg;
    }

    private WLoginHelperImpl() {
        this.serverRequest = new server_request();
        String[] clts = kDefaultVerifyA4ClientList.split("\\|");
        for (int i = 0; i < clts.length; ++i) {
            if (this._verifyA4ClientList.contains(clts[i])) continue;
            this._verifyA4ClientList.add(clts[i]);
        }
    }

    public static WLoginHelperImpl getInstance() {
        if (null == threadLocal.get()) {
            threadLocal.set(new WLoginHelperImpl());
        }
        return threadLocal.get();
    }

    private int checkClientInfo(ClientInfo clientInfo) {
        if (null == clientInfo) {
            return -4;
        }
        if (null == clientInfo.getClient()) {
            clientInfo.setClient("WLogin");
        }
        if (null == clientInfo.getOsVersion()) {
            clientInfo.setOsVersion("");
        }
        if (null == clientInfo.getClientVersion()) {
            clientInfo.setClientVersion("");
        }
        if (null == clientInfo.getUuid()) {
            clientInfo.setUuid("");
        }
        if (null == clientInfo.getAppName()) {
            clientInfo.setAppName("");
        }
        if (null == clientInfo.getNetworkType()) {
            clientInfo.setNetworkType("");
        }
        if (null == clientInfo.getScreen()) {
            clientInfo.setScreen("");
        }
        if (null == clientInfo.getArea()) {
            clientInfo.setArea("");
        }
        if (null == clientInfo.getClientIp()) {
            clientInfo.setClientIp("");
        }
        if (null == clientInfo.getBuild()) {
            clientInfo.setBuild("");
        }
        if (null == clientInfo.getPartner()) {
            clientInfo.setPartner("");
        }
        if (null == clientInfo.getLang()) {
            clientInfo.setLang("");
        }
        return 0;
    }

    public message_decoder sendAndRecv(String serviceName, message_encoder encoder) {
        return this.sendAndRecv(serviceName, encoder, -1);
    }

    public message_decoder sendAndRecv(String serviceName, message_encoder encoder, int timeout) {
        this.clearErr();
        int interface_id = report_agent.service_cmd_to_interface_id(encoder.getCmd(), encoder.getSubCmd());
        int ret = this.serverRequest.request(interface_id, encoder, serviceName, encoder.getAppId(), timeout);
        if (ret != 0) {
            this.setSysErrCode(ret);
            this.setSysErrMsg(this.serverRequest.exception_msg());
            return null;
        }
        if (message_decoder.Check(this.serverRequest.recv_buf(), this.serverRequest.recv_buf_len()) <= 0) {
            this.setSysErrCode(-2);
            this.setSysErrMsg("Received Invalid Message");
            return null;
        }
        message_decoder decoder = new message_decoder(this.serverRequest.recv_buf());
        if (encoder.seq() != decoder.seq()) {
            this.setSysErrCode(-1);
            this.setSysErrMsg("Received Message SEQ(" + decoder.seq() + ") isn't Equal to Sent Message SEQ(" + encoder.seq() + ").");
            return null;
        }
        return decoder;
    }

    public VerifyLoginResult verifyLoginForGw(String pin, String wskey, ClientInfo clientInfo) {
        this.clearErr();
        if (null == clientInfo) {
            this.setSysErrCode(-4);
            this.setSysErrMsg("Input Parameter Error: clientInfo is null");
            return null;
        }
        int appid = this.getAppid(clientInfo.getClient());
        return this.verifyLogin(pin, appid, wskey, clientInfo);
    }

    public VerifyLoginResult interVerifyLoginForGw(String pin, String wskey, ClientInfo clientInfo) {
        String json;
        Integer riskLevel;
        String plus;
        this.clearErr();
        if (null == pin || null == wskey || null == clientInfo) {
            this.setSysErrCode(-4);
            this.setSysErrMsg("Input Parameter Error: pin or wskey or clientInfo is null");
            return null;
        }
        if (0 != this.checkClientInfo(clientInfo)) {
            this.setSysErrCode(-4);
            this.setSysErrMsg("Input Parameter Error: some fields in clientInfo is null");
            return null;
        }
        if (pin.length() >= 2048) {
            this.setSysErrCode(-6);
            this.setSysErrMsg("Too long pin: " + pin);
            return null;
        }
        if (wskey.length() >= 4096) {
            this.setSysErrCode(-7);
            this.setSysErrMsg("Too long app wskey: " + wskey);
            return null;
        }
        int appId = 400;
        short cmd = 20;
        short sub_cmd = 1;
        message_encoder encoder = new message_encoder(2048);
        encoder.set_uid(0L);
        encoder.set_partition(0);
        encoder.set_seq(0);
        encoder.set_client_ip(util.string_to_ip(clientInfo.getClientIp()));
        encoder.set_cmd(cmd);
        encoder.set_sub_cmd(sub_cmd);
        encoder.set_app_id((short)appId);
        tlv_0x10 t10 = new tlv_0x10();
        t10.Encode(pin);
        encoder.AddByteArray(16, t10.value(), t10.len());
        tlv_0x8 t8 = new tlv_0x8();
        t8.Encode(appId, clientInfo.getClient(), clientInfo.getOsVersion(), clientInfo.getClientVersion(), clientInfo.getScreen(), clientInfo.getAppName(), clientInfo.getNetworkType(), clientInfo.getArea(), clientInfo.getUuid(), 1, clientInfo.getBuild(), clientInfo.getPartner());
        encoder.AddByteArray(8, t8.value(), t8.len());
        encoder.AddString(169, clientInfo.getClientIp());
        encoder.AddString(10, wskey);
        encoder.AddString(104, clientInfo.getLang());
        int interface_id = report_agent.service_cmd_to_interface_id(cmd, sub_cmd);
        int ret = this.serverRequest.request(interface_id, encoder, kInterVerifyServiceName, appId);
        if (ret != 0) {
            this.setSysErrCode(ret);
            this.setSysErrMsg(this.serverRequest.exception_msg());
            return null;
        }
        if (message_decoder.Check(this.serverRequest.recv_buf(), this.serverRequest.recv_buf_len()) <= 0) {
            this.setSysErrCode(-2);
            this.setSysErrMsg("Received Invalid Message");
            return null;
        }
        message_decoder decoder = new message_decoder(this.serverRequest.recv_buf());
        if (encoder.seq() != decoder.seq()) {
            this.setSysErrCode(-1);
            this.setSysErrMsg("Received Message SEQ(" + decoder.seq() + ") isn't Equal to Sent Message SEQ(" + encoder.seq() + ").");
            return null;
        }
        this.setStatus(decoder.status());
        if (0 != decoder.status()) {
            this.setErrCode(decoder.status());
            this.getErrorInfoFromTlv0x3(decoder);
            return null;
        }
        VerifyLoginResult result = new VerifyLoginResult();
        String retPin = decoder.GetString(16);
        if (null == retPin || !pin.equals(retPin)) {
            this.setStatus(11);
            this.setErrCode(11);
            this.setErrMsg("A2 Not Exists");
            this.setUserErrMsg("A2 Not Exists");
        } else {
            result.setPin(retPin);
        }
        Integer userLevel = decoder.GetInt32(97);
        if (null != userLevel) {
            result.setUserLevel(userLevel);
        }
        if (null != (plus = decoder.GetString(98))) {
            result.setPlus(plus);
        }
        if (null != (riskLevel = decoder.GetInt32(99))) {
            result.setRiskLevel(riskLevel);
        }
        if (null != (json = decoder.GetString(53))) {
            result.setJson(json);
        }
        return result;
    }

    public VerifyLoginResult verifyLogin(String pin, int appId, String wskey, ClientInfo clientInfo) {
        this.clearErr();
        if (null == pin || null == wskey || null == clientInfo) {
            this.setSysErrCode(-4);
            this.setSysErrMsg("Input Parameter Error: pin or wskey or clientInfo is null");
            return null;
        }
        if (0 != this.checkClientInfo(clientInfo)) {
            this.setSysErrCode(-4);
            this.setSysErrMsg("Input Parameter Error: some fields in clientInfo is null");
            return null;
        }
        if (appId <= 0) {
            this.setSysErrCode(-4);
            this.setSysErrMsg("Input Parameter Error: appId is less than 0");
            return null;
        }
        if (pin.length() >= 2048) {
            this.setSysErrCode(-6);
            this.setSysErrMsg("Too long pin: " + pin);
            return null;
        }
        if (wskey.length() >= 4096) {
            this.setSysErrCode(-7);
            this.setSysErrMsg("Too long app wskey: " + wskey);
            return null;
        }
        if ("android".equalsIgnoreCase(clientInfo.getClient()) || "apple".equalsIgnoreCase(clientInfo.getClient()) || "ipad".equalsIgnoreCase(clientInfo.getClient())) {
            VerifyAppLoginResult appResult = new VerifyAppLoginResult();
            int ret = this.verifyAppLogin(pin, appId, wskey, clientInfo, appResult);
            if (0 == ret && this.getStatus() == 0) {
                VerifyLoginResult retResult = new VerifyLoginResult();
                retResult.setPin(appResult.getPin());
                retResult.setUserLevel(appResult.getUserLevel());
                retResult.setPlus(appResult.getPlus());
                retResult.setRiskLevel(appResult.getRiskLevel());
                retResult.setJson(appResult.getJson());
                return retResult;
            }
            return null;
        }
        if (this.isNeedVerifyA4(clientInfo.getClient())) {
            VerifyH5LoginResult h5Result = new VerifyH5LoginResult();
            int ret = this.verifyH5Login(pin, appId, wskey, clientInfo, h5Result);
            if (0 == ret && this.getStatus() == 0) {
                VerifyLoginResult retResult = new VerifyLoginResult();
                retResult.setPin(h5Result.getPin());
                retResult.setUserLevel(h5Result.getUserLevel());
                retResult.setPlus(h5Result.getPlus());
                retResult.setRiskLevel(h5Result.getRiskLevel());
                retResult.setJson(h5Result.getJson());
                return retResult;
            }
            return null;
        }
        VerifyAppLoginResult appResult = new VerifyAppLoginResult();
        int ret = this.verifyAppLogin(pin, appId, wskey, clientInfo, appResult);
        if (0 == ret && this.getStatus() == 0) {
            VerifyLoginResult retResult = new VerifyLoginResult();
            retResult.setPin(appResult.getPin());
            retResult.setUserLevel(appResult.getUserLevel());
            retResult.setPlus(appResult.getPlus());
            retResult.setRiskLevel(appResult.getRiskLevel());
            retResult.setJson(appResult.getJson());
            return retResult;
        }
        return null;
    }

    public VerifyLoginResult interVerifyLogin(String pin, int appId, String wskey, ClientInfo clientInfo) {
        this.clearErr();
        if (pin == null || pin.equals("")) {
            this.setSysErrCode(-4);
            this.setSysErrMsg("Input Parameter Error: pin is empty or null!");
            return null;
        }
        if (pin.length() >= 2048) {
            this.setSysErrCode(-6);
            this.setSysErrMsg("Too long pin: " + pin);
            return null;
        }
        VerifyAppLoginResult appResult = this.interVerifyAppLogin(appId, wskey, clientInfo);
        if (null == appResult) {
            return null;
        }
        if (!pin.equals(appResult.getPin())) {
            this.setStatus(11);
            this.setErrCode(11);
            this.setErrMsg("A2 Not Exists");
            this.setUserErrMsg("A2 Not Exists");
            return null;
        }
        VerifyLoginResult retResult = new VerifyLoginResult();
        retResult.setPin(appResult.getPin());
        retResult.setUserLevel(appResult.getUserLevel());
        retResult.setPlus(appResult.getPlus());
        retResult.setRiskLevel(appResult.getRiskLevel());
        retResult.setJson(appResult.getJson());
        return retResult;
    }

    private boolean isNeedVerifyA4(String client) {
        if (null == client || client.isEmpty()) {
            return false;
        }
        if (this._verifyA4ClientList.contains(client.toLowerCase())) {
            return true;
        }
        if (System.currentTimeMillis() - this._last_update_cc_time > (long)this._cc_update_interval) {
            String clientList = this._config_center_service.CC_GetAttr(kVerifyServiceName, "VerifyA4", "ClientList");
            if (null != clientList) {
                this._last_update_cc_time = System.currentTimeMillis();
            }
            if ((null == clientList || clientList.isEmpty()) && this._verifyA4ClientList.isEmpty()) {
                clientList = kDefaultVerifyA4ClientList;
            }
            if (null != clientList && !clientList.isEmpty()) {
                String[] clts = clientList.split("\\|");
                for (int i = 0; i < clts.length; ++i) {
                    if (this._verifyA4ClientList.contains(clts[i])) continue;
                    this._verifyA4ClientList.add(clts[i]);
                }
            }
        }
        return this._verifyA4ClientList.contains(client.toLowerCase());
    }

    private int getAppid(String client) {
        Integer appid;
        if (null == client || client.isEmpty()) {
            return 100;
        }
        if (client.equalsIgnoreCase("apple") || client.equalsIgnoreCase("android") || client.equalsIgnoreCase("ipad")) {
            return 100;
        }
        if (this.isNeedVerifyA4(client)) {
            return 100;
        }
        if (System.currentTimeMillis() - this._last_update_cc_time_appid_list > (long)this._cc_update_interval_appid_list) {
            String appidList = this._config_center_service.CC_GetAttr(kVerifyServiceName, "ClientAppId", "AppidList");
            if (null != appidList) {
                this._last_update_cc_time_appid_list = System.currentTimeMillis();
            }
            if (null != appidList && !appidList.isEmpty()) {
                String[] clts = appidList.split("\\|");
                for (int i = 0; i < clts.length; ++i) {
                    int value;
                    String[] kv = clts[i].split(":");
                    if (kv.length < 2) continue;
                    try {
                        value = Integer.valueOf(kv[1]);
                    }
                    catch (NumberFormatException e) {
                        value = 100;
                    }
                    this._appid_list.put(kv[0], value);
                }
            }
        }
        if ((appid = this._appid_list.get(client)) == null) {
            return 100;
        }
        return appid;
    }

    private int verifyAppLogin(String pin, int appId, String wskey, ClientInfo clientInfo, VerifyAppLoginResult result) {
        this.clearErr();
        if (null == pin || null == wskey || null == clientInfo) {
            this.setSysErrCode(-4);
            this.setSysErrMsg("Input Parameter Error: pin or wskey or clientInfo is null");
            return -4;
        }
        if (0 != this.checkClientInfo(clientInfo)) {
            this.setSysErrCode(-4);
            this.setSysErrMsg("Input Parameter Error: some fields in clientInfo is null");
            return -4;
        }
        if (appId <= 0) {
            this.setSysErrCode(-4);
            this.setSysErrMsg("Input Parameter Error: appId is less than 0");
            return -4;
        }
        if (pin.length() >= 2048) {
            this.setSysErrCode(-6);
            this.setSysErrMsg("Too long pin: " + pin);
            return -6;
        }
        if (wskey.length() >= 4096) {
            this.setSysErrCode(-7);
            this.setSysErrMsg("Too long app wskey: " + wskey);
            return -7;
        }
        short cmd = 3;
        short sub_cmd = 1;
        message_encoder encoder = new message_encoder(2048);
        encoder.set_uid(0L);
        encoder.set_partition(util.crc32(pin));
        encoder.set_seq(0);
        encoder.set_client_ip(util.string_to_ip(clientInfo.getClientIp()));
        encoder.set_cmd(cmd);
        encoder.set_sub_cmd(sub_cmd);
        encoder.set_app_id((short)appId);
        tlv_0x10 t10 = new tlv_0x10();
        t10.Encode(pin);
        encoder.AddByteArray(16, t10.value(), t10.len());
        tlv_0x8 t8 = new tlv_0x8();
        t8.Encode(appId, clientInfo.getClient(), clientInfo.getOsVersion(), clientInfo.getClientVersion(), clientInfo.getScreen(), clientInfo.getAppName(), clientInfo.getNetworkType(), clientInfo.getArea(), clientInfo.getUuid(), 1, clientInfo.getBuild(), clientInfo.getPartner());
        encoder.AddByteArray(8, t8.value(), t8.len());
        encoder.AddString(169, clientInfo.getClientIp());
        tlv_0xa ta = new tlv_0xa();
        ta.Encode(wskey);
        encoder.AddByteArray(10, ta.value(), ta.len());
        int interface_id = report_agent.service_cmd_to_interface_id(cmd, sub_cmd);
        int ret = this.serverRequest.request(interface_id, encoder, kVerifyServiceName, appId);
        if (ret != 0) {
            this.setSysErrCode(ret);
            this.setSysErrMsg(this.serverRequest.exception_msg());
            return -1;
        }
        if (message_decoder.Check(this.serverRequest.recv_buf(), this.serverRequest.recv_buf_len()) <= 0) {
            this.setSysErrCode(-2);
            this.setSysErrMsg("Received Invalid Message");
            return -2;
        }
        message_decoder decoder = new message_decoder(this.serverRequest.recv_buf());
        if (encoder.seq() != decoder.seq()) {
            this.setSysErrCode(-1);
            this.setSysErrMsg("Received Message SEQ(" + decoder.seq() + ") isn't Equal to Sent Message SEQ(" + encoder.seq() + ").");
            return -1;
        }
        this.setStatus(decoder.status());
        if (0 != decoder.status()) {
            this.setErrCode(decoder.status());
            this.getErrorInfoFromTlv0x3(decoder);
        } else {
            String json;
            Integer riskLevel;
            String plus;
            String retPin = decoder.GetString(16);
            if (null == retPin || !pin.equals(retPin)) {
                this.setStatus(11);
                this.setErrCode(11);
                this.setErrMsg("A2 Not Exists");
                this.setUserErrMsg("A2 Not Exists");
            } else {
                result.setPin(retPin);
            }
            Integer userLevel = decoder.GetInt32(97);
            if (null != userLevel) {
                result.setUserLevel(userLevel);
            }
            if (null != (plus = decoder.GetString(98))) {
                result.setPlus(plus);
            }
            if (null != (riskLevel = decoder.GetInt32(99))) {
                result.setRiskLevel(riskLevel);
            }
            if (null != (json = decoder.GetString(53))) {
                result.setJson(json);
            }
        }
        return 0;
    }

    public VerifyAppLoginResult verifyAppLogin(int appId, String wskey, ClientInfo clientInfo) {
        this.clearErr();
        if (null == wskey || null == clientInfo) {
            this.setSysErrCode(-4);
            this.setSysErrMsg("Input Parameter Error: wskey or clientInfo is null");
            return null;
        }
        if (0 != this.checkClientInfo(clientInfo)) {
            this.setSysErrCode(-4);
            this.setSysErrMsg("Input Parameter Error: some fields in clientInfo is null");
            return null;
        }
        if (appId <= 0) {
            this.setSysErrCode(-4);
            this.setSysErrMsg("Input Parameter Error: appId is less than 0");
            return null;
        }
        if (wskey.length() >= 4096) {
            this.setSysErrCode(-7);
            this.setSysErrMsg("Too long wskey: " + wskey);
            return null;
        }
        short cmd = 3;
        short sub_cmd = 1;
        message_encoder encoder = new message_encoder(2048);
        encoder.set_uid(0L);
        encoder.set_partition(0);
        encoder.set_seq(0);
        encoder.set_client_ip(util.string_to_ip(clientInfo.getClientIp()));
        encoder.set_cmd(cmd);
        encoder.set_sub_cmd(sub_cmd);
        encoder.set_app_id((short)appId);
        tlv_0x8 t8 = new tlv_0x8();
        t8.Encode(appId, clientInfo.getClient(), clientInfo.getOsVersion(), clientInfo.getClientVersion(), clientInfo.getScreen(), clientInfo.getAppName(), clientInfo.getNetworkType(), clientInfo.getArea(), clientInfo.getUuid(), 1, clientInfo.getBuild(), clientInfo.getPartner());
        encoder.AddByteArray(8, t8.value(), t8.len());
        encoder.AddString(169, clientInfo.getClientIp());
        tlv_0xa ta = new tlv_0xa();
        ta.Encode(wskey);
        encoder.AddByteArray(10, ta.value(), ta.len());
        int interface_id = report_agent.service_cmd_to_interface_id(cmd, sub_cmd);
        int ret = this.serverRequest.request(interface_id, encoder, kVerifyServiceName, appId);
        if (ret != 0) {
            this.setSysErrCode(ret);
            this.setSysErrMsg(this.serverRequest.exception_msg());
            return null;
        }
        if (message_decoder.Check(this.serverRequest.recv_buf(), this.serverRequest.recv_buf_len()) <= 0) {
            this.setSysErrCode(-2);
            this.setSysErrMsg("Received Invalid Message");
            return null;
        }
        message_decoder decoder = new message_decoder(this.serverRequest.recv_buf());
        if (encoder.seq() != decoder.seq()) {
            this.setSysErrCode(-1);
            this.setSysErrMsg("Received Message SEQ(" + decoder.seq() + ") isn't Equal to Sent Message SEQ(" + encoder.seq() + ").");
            return null;
        }
        this.setStatus(decoder.status());
        if (0 != decoder.status()) {
            this.setErrCode(decoder.status());
            this.getErrorInfoFromTlv0x3(decoder);
            return null;
        }
        String pin = decoder.GetString(16);
        if (null != pin && !pin.isEmpty()) {
            String json;
            Integer riskLevel;
            String plus;
            VerifyAppLoginResult result = new VerifyAppLoginResult();
            result.setPin(pin);
            Integer userLevel = decoder.GetInt32(97);
            if (null != userLevel) {
                result.setUserLevel(userLevel);
            }
            if (null != (plus = decoder.GetString(98))) {
                result.setPlus(plus);
            }
            if (null != (riskLevel = decoder.GetInt32(99))) {
                result.setRiskLevel(riskLevel);
            }
            if (null != (json = decoder.GetString(53))) {
                result.setJson(json);
            }
            return result;
        }
        return null;
    }

    public VerifyAppLoginResult interVerifyAppLogin(int appId, String wskey, ClientInfo clientInfo) {
        this.clearErr();
        if (null == wskey || null == clientInfo) {
            this.setSysErrCode(-4);
            this.setSysErrMsg("Input Parameter Error: wskey or clientInfo is null");
            return null;
        }
        if (0 != this.checkClientInfo(clientInfo)) {
            this.setSysErrCode(-4);
            this.setSysErrMsg("Input Parameter Error: some fields in clientInfo is null");
            return null;
        }
        if (appId <= 0) {
            this.setSysErrCode(-4);
            this.setSysErrMsg("Input Parameter Error: appId is less than 0");
            return null;
        }
        if (wskey.length() >= 4096) {
            this.setSysErrCode(-7);
            this.setSysErrMsg("Too long app wskey: " + wskey);
            return null;
        }
        short cmd = 20;
        short sub_cmd = 3;
        message_encoder encoder = new message_encoder(2048);
        encoder.set_uid(0L);
        encoder.set_partition(0);
        encoder.set_seq(0);
        encoder.set_client_ip(util.string_to_ip(clientInfo.getClientIp()));
        encoder.set_cmd(cmd);
        encoder.set_sub_cmd(sub_cmd);
        encoder.set_app_id((short)appId);
        tlv_0x8 t8 = new tlv_0x8();
        t8.Encode(appId, clientInfo.getClient(), clientInfo.getOsVersion(), clientInfo.getClientVersion(), clientInfo.getScreen(), clientInfo.getAppName(), clientInfo.getNetworkType(), clientInfo.getArea(), clientInfo.getUuid(), 1, clientInfo.getBuild(), clientInfo.getPartner());
        encoder.AddByteArray(8, t8.value(), t8.len());
        encoder.AddString(169, clientInfo.getClientIp());
        encoder.AddString(10, wskey);
        encoder.AddString(104, clientInfo.getLang());
        int interface_id = report_agent.service_cmd_to_interface_id(cmd, sub_cmd);
        int ret = this.serverRequest.request(interface_id, encoder, kInterVerifyServiceName, appId);
        if (ret != 0) {
            this.setSysErrCode(ret);
            this.setSysErrMsg(this.serverRequest.exception_msg());
            return null;
        }
        if (message_decoder.Check(this.serverRequest.recv_buf(), this.serverRequest.recv_buf_len()) <= 0) {
            this.setSysErrCode(-2);
            this.setSysErrMsg("Received Invalid Message");
            return null;
        }
        message_decoder decoder = new message_decoder(this.serverRequest.recv_buf());
        if (encoder.seq() != decoder.seq()) {
            this.setSysErrCode(-1);
            this.setSysErrMsg("Received Message SEQ(" + decoder.seq() + ") isn't Equal to Sent Message SEQ(" + encoder.seq() + ").");
            return null;
        }
        this.setStatus(decoder.status());
        if (0 != decoder.status()) {
            this.setErrCode(decoder.status());
            this.getErrorInfoFromTlv0x3(decoder);
            return null;
        }
        String pin = decoder.GetString(16);
        if (null != pin && !pin.isEmpty()) {
            String json;
            Integer riskLevel;
            String plus;
            VerifyAppLoginResult result = new VerifyAppLoginResult();
            result.setPin(pin);
            Integer userLevel = decoder.GetInt32(97);
            if (null != userLevel) {
                result.setUserLevel(userLevel);
            }
            if (null != (plus = decoder.GetString(98))) {
                result.setPlus(plus);
            }
            if (null != (riskLevel = decoder.GetInt32(99))) {
                result.setRiskLevel(riskLevel);
            }
            if (null != (json = decoder.GetString(53))) {
                result.setJson(json);
            }
            return result;
        }
        return null;
    }

    public int reqJumpToken(String pin, int appId, String wskey, String jumpTokenValue, ClientInfo clientInfo, ReqJumpTokenResult tokenResult) {
        this.clearErr();
        if (null == jumpTokenValue || null == clientInfo || null == tokenResult) {
            this.setSysErrCode(-4);
            this.setSysErrMsg("Input Parameter Error: jumpTokenValue or clientInfo or tokenResult is null");
            return -4;
        }
        if (0 != this.checkClientInfo(clientInfo)) {
            this.setSysErrCode(-4);
            this.setSysErrMsg("Input Parameter Error: some fields in clientInfo is null");
            return -4;
        }
        if (appId <= 0) {
            this.setSysErrCode(-4);
            this.setSysErrMsg("Input Parameter Error: appId is less than 0");
            return -4;
        }
        pin = null == pin ? "" : pin;
        String string = wskey = null == wskey ? "" : wskey;
        if (pin.length() >= 2048) {
            this.setSysErrCode(-6);
            this.setSysErrMsg("Too long pin: " + pin);
            return -6;
        }
        if (wskey.length() >= 4096) {
            this.setSysErrCode(-7);
            this.setSysErrMsg("Too long app wskey: " + wskey);
            return -7;
        }
        short cmd = 2;
        short sub_cmd = 9;
        message_encoder encoder = new message_encoder(2048);
        encoder.set_uid(0L);
        encoder.set_partition(0);
        encoder.set_seq(0);
        encoder.set_client_ip(util.string_to_ip(clientInfo.getClientIp()));
        encoder.set_cmd(cmd);
        encoder.set_sub_cmd(sub_cmd);
        encoder.set_app_id((short)appId);
        tlv_0x10 t10 = new tlv_0x10();
        t10.Encode(pin);
        encoder.AddByteArray(16, t10.value(), t10.len());
        tlv_0x8 t8 = new tlv_0x8();
        t8.Encode(appId, clientInfo.getClient(), clientInfo.getOsVersion(), clientInfo.getClientVersion(), clientInfo.getScreen(), clientInfo.getAppName(), clientInfo.getNetworkType(), clientInfo.getArea(), clientInfo.getUuid(), 1, clientInfo.getBuild(), clientInfo.getPartner());
        encoder.AddByteArray(8, t8.value(), t8.len());
        encoder.AddString(169, clientInfo.getClientIp());
        tlv_0xa ta = new tlv_0xa();
        ta.Encode(wskey);
        encoder.AddByteArray(10, ta.value(), ta.len());
        tlv_0x17 t17 = new tlv_0x17();
        t17.Encode(jumpTokenValue);
        encoder.AddByteArray(23, t17.value(), t17.len());
        int interface_id = report_agent.service_cmd_to_interface_id(cmd, sub_cmd);
        int ret = this.serverRequest.request(interface_id, encoder, kVerifyServiceName, appId);
        if (ret != 0) {
            this.setSysErrCode(ret);
            this.setSysErrMsg(this.serverRequest.exception_msg());
            return -1;
        }
        if (message_decoder.Check(this.serverRequest.recv_buf(), this.serverRequest.recv_buf_len()) <= 0) {
            this.setSysErrCode(-2);
            this.setSysErrMsg("Received Invalid Message");
            return -2;
        }
        message_decoder decoder = new message_decoder(this.serverRequest.recv_buf());
        if (encoder.seq() != decoder.seq()) {
            this.setSysErrCode(-1);
            this.setSysErrMsg("Received Message SEQ(" + decoder.seq() + ") isn't Equal to Sent Message SEQ(" + encoder.seq() + ").");
            return -1;
        }
        this.setStatus(decoder.status());
        if (0 != decoder.status()) {
            this.setErrCode(decoder.status());
            message_byte_array_result result_0x3 = decoder.GetByteArrayByReference(3);
            if (null != result_0x3) {
                tlv_0x3 t3 = new tlv_0x3();
                if (0 != t3.Decode(result_0x3.buf(), result_0x3.pos(), result_0x3.len())) {
                    return -3;
                }
                this.setErrMsg(t3.err_str());
                this.setUserErrMsg(t3.user_err_str());
            }
        } else {
            message_byte_array_result result_0x11 = decoder.GetByteArrayByReference(17);
            if (null == result_0x11) {
                this.setSysErrCode(-3);
                this.setSysErrMsg("Decode Received Message Failed");
                return -3;
            }
            tlv_0x11 t11 = new tlv_0x11();
            t11.Decode(pin, appId, result_0x11.buf(), result_0x11.pos(), result_0x11.len());
            tokenResult.setJumpToken(t11.jump_token());
            message_byte_array_result result_0x17 = decoder.GetByteArrayByReference(23);
            if (null != result_0x17) {
                tlv_0x17 t17_url = new tlv_0x17();
                t17_url.Decode(result_0x17.buf(), result_0x17.pos(), result_0x17.len());
                tokenResult.setUrl(t17_url.jump_token_value());
            } else {
                this.setSysErrCode(-3);
                this.setSysErrMsg("Decode Received Message Failed");
                return -3;
            }
        }
        return 0;
    }

    public int verifyJumpToken(String jumpToken, int destAppId, ClientInfo clientInfo, VerifyJumpTokenResult tokenResult) {
        this.clearErr();
        if (null == jumpToken || null == clientInfo || null == tokenResult) {
            this.setSysErrCode(-4);
            this.setSysErrMsg("Input Parameter Error: jumpToken or clientInfo or tokenResult is null");
            return -4;
        }
        if (0 != this.checkClientInfo(clientInfo)) {
            this.setSysErrCode(-4);
            this.setSysErrMsg("Input Parameter Error: some fields in clientInfo is null");
            return -4;
        }
        if (destAppId <= 0) {
            this.setSysErrCode(-4);
            this.setSysErrMsg("Input Parameter Error: destAppId is less than 0");
            return -4;
        }
        short cmd = 2;
        short sub_cmd = 8;
        tlv_0x11 t11_input = new tlv_0x11();
        if (0 != t11_input.Encode(jumpToken)) {
            this.setSysErrCode(-4);
            this.setSysErrMsg("Input Parameter Error: jumpToken isn't a valid token");
            return -4;
        }
        String pin = t11_input.pin();
        int appId = t11_input.app_id();
        byte[] token = t11_input.token();
        message_encoder encoder = new message_encoder(2048);
        encoder.set_uid(0L);
        encoder.set_partition(0);
        encoder.set_seq(0);
        encoder.set_client_ip(util.string_to_ip(clientInfo.getClientIp()));
        encoder.set_cmd(cmd);
        encoder.set_sub_cmd(sub_cmd);
        encoder.set_app_id((short)appId);
        tlv_0x10 t10 = new tlv_0x10();
        t10.Encode(pin);
        encoder.AddByteArray(16, t10.value(), t10.len());
        tlv_0x8 t8 = new tlv_0x8();
        t8.Encode(appId, clientInfo.getClient(), clientInfo.getOsVersion(), clientInfo.getClientVersion(), clientInfo.getScreen(), clientInfo.getAppName(), clientInfo.getNetworkType(), clientInfo.getArea(), clientInfo.getUuid(), 1, clientInfo.getBuild(), clientInfo.getPartner());
        encoder.AddByteArray(8, t8.value(), t8.len());
        encoder.AddString(169, clientInfo.getClientIp());
        encoder.AddByteArray(17, token);
        encoder.AddInt16(22, destAppId);
        int interface_id = report_agent.service_cmd_to_interface_id(cmd, sub_cmd);
        int ret = this.serverRequest.request(interface_id, encoder, kVerifyServiceName, appId);
        if (ret != 0) {
            this.setSysErrCode(ret);
            this.setSysErrMsg(this.serverRequest.exception_msg());
            return -1;
        }
        if (message_decoder.Check(this.serverRequest.recv_buf(), this.serverRequest.recv_buf_len()) <= 0) {
            this.setSysErrCode(-2);
            this.setSysErrMsg("Received Invalid Message");
            return -2;
        }
        message_decoder decoder = new message_decoder(this.serverRequest.recv_buf());
        if (encoder.seq() != decoder.seq()) {
            this.setSysErrCode(-1);
            this.setSysErrMsg("Received Message SEQ(" + decoder.seq() + ") isn't Equal to Sent Message SEQ(" + encoder.seq() + ").");
            return -1;
        }
        this.setStatus(decoder.status());
        if (0 != decoder.status()) {
            this.setErrCode(decoder.status());
            this.getErrorInfoFromTlv0x3(decoder);
        } else {
            message_byte_array_result result_0x10;
            message_byte_array_result result_0xa = decoder.GetByteArrayByReference(10);
            if (null != result_0xa) {
                tlv_0xa ta = new tlv_0xa();
                if (0 != ta.Decode(result_0xa.buf(), result_0xa.pos(), result_0xa.len())) {
                    this.setSysErrCode(-3);
                    this.setSysErrMsg("Decode Received Message Failed");
                    return -3;
                }
                tokenResult.setTgt(ta.tgt());
            } else {
                tokenResult.setTgt("");
            }
            message_byte_array_result result_0xe = decoder.GetByteArrayByReference(14);
            if (null != result_0xe) {
                tlv_0xe te = new tlv_0xe();
                if (0 != te.Decode(result_0xe.buf(), result_0xe.pos(), result_0xe.len())) {
                    this.setSysErrCode(-3);
                    this.setSysErrMsg("Decode Received Message Failed");
                    return -3;
                }
                tokenResult.setTgtRefreshTime(te.refresh_time());
                tokenResult.setTgtExpireTime(te.expire_time());
            }
            if (null != (result_0x10 = decoder.GetByteArrayByReference(16))) {
                tlv_0x10 t10_out = new tlv_0x10();
                if (0 != t10_out.Decode(result_0x10.buf(), result_0x10.pos(), result_0x10.len())) {
                    this.setSysErrCode(-3);
                    this.setSysErrMsg("Decode Received Message Failed");
                    return -3;
                }
                tokenResult.setPin(t10_out.pin());
            } else {
                tokenResult.setPin("");
            }
            message_byte_array_result result_0x17 = decoder.GetByteArrayByReference(23);
            if (null != result_0x17) {
                tlv_0x17 t17_url = new tlv_0x17();
                t17_url.Decode(result_0x17.buf(), result_0x17.pos(), result_0x17.len());
                tokenResult.setTokenValue(t17_url.jump_token_value());
            } else {
                this.setSysErrCode(-3);
                this.setSysErrMsg("Decode Received Message Failed");
                return -3;
            }
        }
        return 0;
    }

    public int verifyQRTicket(String qrTicket, int appId, ClientInfo clientInfo, VerifyQRTicketResult result) {
        this.clearErr();
        if (null == qrTicket || qrTicket.length() == 0) {
            this.setSysErrCode(-4);
            this.setSysErrMsg("Input Parameter Error: qrTicket is null or length = 0");
            return -4;
        }
        if (0 != this.checkClientInfo(clientInfo)) {
            this.setSysErrCode(-4);
            this.setSysErrMsg("Input Parameter Error: some fields in clientInfo is null");
            return -4;
        }
        if (appId <= 0) {
            this.setSysErrCode(-4);
            this.setSysErrMsg("Input Parameter Error: appId is less than or equal 0");
            return -4;
        }
        short cmd = 7;
        short sub_cmd = 5;
        message_encoder encoder = new message_encoder(2048);
        encoder.set_uid(0L);
        encoder.set_partition(0);
        encoder.set_seq(0);
        encoder.set_client_ip(util.string_to_ip(clientInfo.getClientIp()));
        encoder.set_cmd(cmd);
        encoder.set_sub_cmd(sub_cmd);
        encoder.set_app_id((short)appId);
        tlv_0x8 t8 = new tlv_0x8();
        t8.Encode(appId, clientInfo.getClient(), clientInfo.getOsVersion(), clientInfo.getClientVersion(), clientInfo.getScreen(), clientInfo.getAppName(), clientInfo.getNetworkType(), clientInfo.getArea(), clientInfo.getUuid(), 1, clientInfo.getBuild(), clientInfo.getPartner());
        encoder.AddByteArray(8, t8.value(), t8.len());
        encoder.AddString(169, clientInfo.getClientIp());
        encoder.AddString(37, qrTicket);
        int interface_id = report_agent.service_cmd_to_interface_id(cmd, sub_cmd);
        int ret = this.serverRequest.request(interface_id, encoder, kQRVerifyServiceName, appId);
        if (ret != 0) {
            this.setSysErrCode(ret);
            this.setSysErrMsg(this.serverRequest.exception_msg());
            return -1;
        }
        if (message_decoder.Check(this.serverRequest.recv_buf(), this.serverRequest.recv_buf_len()) <= 0) {
            this.setSysErrCode(-2);
            this.setSysErrMsg("Received Invalid Message");
            return -2;
        }
        message_decoder decoder = new message_decoder(this.serverRequest.recv_buf());
        if (encoder.seq() != decoder.seq()) {
            this.setSysErrCode(-1);
            this.setSysErrMsg("Received Message SEQ(" + decoder.seq() + ") isn't Equal to Sent Message SEQ(" + encoder.seq() + ").");
            return -1;
        }
        this.setStatus(decoder.status());
        if (0 != decoder.status()) {
            this.setErrCode(decoder.status());
            this.getErrorInfoFromTlv0x3(decoder);
        } else {
            message_byte_array_result result_0x30;
            message_byte_array_result result_0x2f;
            message_byte_array_result result_0x10 = decoder.GetByteArrayByReference(16);
            if (null != result_0x10) {
                tlv_0x10 t10 = new tlv_0x10();
                if (0 != t10.Decode(result_0x10.buf(), result_0x10.pos(), result_0x10.len())) {
                    this.setSysErrCode(-3);
                    this.setSysErrMsg("Decode Received Message Failed");
                    return -3;
                }
                result.setPin(t10.pin());
            }
            if (null != (result_0x2f = decoder.GetByteArrayByReference(47))) {
                tlv_0x2f t2f = new tlv_0x2f();
                if (0 != t2f.Decode(result_0x2f.buf(), result_0x2f.pos(), result_0x2f.len())) {
                    this.setSysErrCode(-3);
                    this.setSysErrMsg("Decode Received Message Failed");
                    return -3;
                }
                result.setLoginIP(util.ip_to_string(t2f.ip()));
            }
            if (null != (result_0x30 = decoder.GetByteArrayByReference(48))) {
                tlv_0x30 t30 = new tlv_0x30();
                if (0 != t30.Decode(result_0x30.buf(), result_0x30.pos(), result_0x2f.len())) {
                    this.setSysErrCode(-3);
                    this.setSysErrMsg("Decode Received Message Failed");
                    return -3;
                }
                result.setLoginTime(t30.time());
            }
        }
        return 0;
    }

    private int verifyH5Login(String ptPin, int appId, String ptKey, ClientInfo clientInfo, VerifyH5LoginResult result) {
        this.clearErr();
        if (ptPin == null || ptPin.equals("") || ptKey == null || ptKey.equals("")) {
            this.setSysErrCode(-4);
            this.setSysErrMsg("Input Parameter Error: pin or a4 is empty or null!");
            return -4;
        }
        if (0 != this.checkClientInfo(clientInfo)) {
            this.setSysErrCode(-4);
            this.setSysErrMsg("Input Parameter Error: some fields in clientInfo is null");
            return -4;
        }
        if (appId <= 0) {
            this.setSysErrCode(-4);
            this.setSysErrMsg("Input Parameter Error: appId is less than 0");
            return -4;
        }
        if ("******".equals(ptPin)) {
            this.setStatus(94);
            this.setErrCode(94);
            return 0;
        }
        if (ptPin.length() >= 2048) {
            this.setSysErrCode(-6);
            this.setSysErrMsg("Too long pt_pin: " + ptPin);
            return -6;
        }
        if (ptKey.length() >= 4096) {
            this.setSysErrCode(-7);
            this.setSysErrMsg("Too long pt_key: " + ptKey);
            return -7;
        }
        String verifyA4ServiceName = kMVerifyServiceName;
        if (ptKey.startsWith("app_open") || ptKey.startsWith("fake_")) {
            verifyA4ServiceName = kOpenVerifyServiceName;
        }
        short cmd = 6;
        short sub_cmd = 3;
        message_encoder encoder = new message_encoder(2048);
        encoder.set_uid(0L);
        encoder.set_partition(0);
        encoder.set_seq(0);
        encoder.set_client_ip(util.string_to_ip(clientInfo.getClientIp()));
        encoder.set_cmd(cmd);
        encoder.set_sub_cmd(sub_cmd);
        encoder.set_app_id((short)appId);
        tlv_0x8 t8 = new tlv_0x8();
        t8.Encode(appId, clientInfo.getClient(), clientInfo.getOsVersion(), clientInfo.getClientVersion(), clientInfo.getScreen(), clientInfo.getAppName(), clientInfo.getNetworkType(), clientInfo.getArea(), clientInfo.getUuid(), 1, clientInfo.getBuild(), clientInfo.getPartner());
        encoder.AddByteArray(8, t8.value(), t8.len());
        encoder.AddString(169, clientInfo.getClientIp());
        tlv_0x10 t10 = new tlv_0x10();
        t10.Encode(ptPin);
        encoder.AddByteArray(16, t10.value(), t10.len());
        encoder.AddString(46, ptKey);
        encoder.AddInt32(68, 0);
        int interface_id = report_agent.service_cmd_to_interface_id(cmd, sub_cmd);
        int ret = this.serverRequest.request(interface_id, encoder, verifyA4ServiceName, appId, this._default_setting.getServerTimeOut());
        if (ret != 0) {
            this.setSysErrCode(ret);
            this.setSysErrMsg(this.serverRequest.exception_msg());
            return -1;
        }
        if (message_decoder.Check(this.serverRequest.recv_buf(), this.serverRequest.recv_buf_len()) <= 0) {
            this.setSysErrCode(-2);
            this.setSysErrMsg("Received Invalid Message");
            return -2;
        }
        message_decoder decoder = new message_decoder(this.serverRequest.recv_buf());
        if (encoder.seq() != decoder.seq()) {
            this.setSysErrCode(-1);
            this.setSysErrMsg("Received Message SEQ(" + decoder.seq() + ") isn't Equal to Sent Message SEQ(" + encoder.seq() + ").");
            return -1;
        }
        this.setStatus(decoder.status());
        if (0 != decoder.status()) {
            this.setErrCode(decoder.status());
            this.getErrorInfoFromTlv0x3(decoder);
        } else {
            String json;
            Integer riskLevel;
            String plus;
            String retPtPin = decoder.GetString(16);
            if (null == retPtPin || !ptPin.equals(retPtPin)) {
                this.setStatus(94);
                this.setErrCode(94);
                this.setErrMsg("A4 Not Exists");
                this.setUserErrMsg("A4 Not Exists");
            } else {
                result.setPin(retPtPin);
            }
            Integer userLevel = decoder.GetInt32(97);
            if (null != userLevel) {
                result.setUserLevel(userLevel);
            }
            if (null != (plus = decoder.GetString(98))) {
                result.setPlus(plus);
            }
            if (null != (riskLevel = decoder.GetInt32(99))) {
                result.setRiskLevel(riskLevel);
            }
            if (null != (json = decoder.GetString(53))) {
                result.setJson(json);
            }
        }
        return 0;
    }

    public VerifyH5LoginResult verifyH5Login(String ptPin, int appId, String ptKey, ClientInfo clientInfo) {
        this.clearErr();
        VerifyH5LoginResult h5Result = new VerifyH5LoginResult();
        int ret = this.verifyH5Login(ptPin, appId, ptKey, clientInfo, h5Result);
        if (0 == ret && this.getStatus() == 0) {
            return h5Result;
        }
        return null;
    }

    private int verifyH5Login(int appId, String ptKey, ClientInfo clientInfo, VerifyH5LoginResult result, boolean isNeedJsonValue) {
        this.clearErr();
        if (ptKey == null || ptKey.equals("")) {
            this.setSysErrCode(-4);
            this.setSysErrMsg("Input Parameter Error: a4 is empty or null!");
            return -4;
        }
        if (0 != this.checkClientInfo(clientInfo)) {
            this.setSysErrCode(-4);
            this.setSysErrMsg("Input Parameter Error: some fields in clientInfo is null");
            return -4;
        }
        if (appId <= 0) {
            this.setSysErrCode(-4);
            this.setSysErrMsg("Input Parameter Error: appId is less than 0");
            return -4;
        }
        if (null == result) {
            this.setSysErrCode(-4);
            this.setSysErrMsg("Input Parameter Error: result is null");
            return -4;
        }
        if (ptKey.length() >= 4096) {
            this.setSysErrCode(-7);
            this.setSysErrMsg("Too long pt_key: " + ptKey);
            return -7;
        }
        String verifyA4ServiceName = kMVerifyServiceName;
        if (ptKey.startsWith("app_open") || ptKey.startsWith("fake_")) {
            verifyA4ServiceName = kOpenVerifyServiceName;
        }
        short cmd = 6;
        short sub_cmd = 3;
        message_encoder encoder = new message_encoder(2048);
        encoder.set_uid(0L);
        encoder.set_partition(0);
        encoder.set_seq(0);
        encoder.set_client_ip(util.string_to_ip(clientInfo.getClientIp()));
        encoder.set_cmd(cmd);
        encoder.set_sub_cmd(sub_cmd);
        encoder.set_app_id((short)appId);
        tlv_0x8 t8 = new tlv_0x8();
        t8.Encode(appId, clientInfo.getClient(), clientInfo.getOsVersion(), clientInfo.getClientVersion(), clientInfo.getScreen(), clientInfo.getAppName(), clientInfo.getNetworkType(), clientInfo.getArea(), clientInfo.getUuid(), 1, clientInfo.getBuild(), clientInfo.getPartner());
        encoder.AddByteArray(8, t8.value(), t8.len());
        encoder.AddString(169, clientInfo.getClientIp());
        encoder.AddString(46, ptKey);
        int needType = isNeedJsonValue ? 1 : 0;
        encoder.AddInt32(68, needType);
        int interface_id = report_agent.service_cmd_to_interface_id(cmd, sub_cmd);
        int ret = this.serverRequest.request(interface_id, encoder, verifyA4ServiceName, appId, this._default_setting.getServerTimeOut());
        if (ret != 0) {
            this.setSysErrCode(ret);
            this.setSysErrMsg(this.serverRequest.exception_msg());
            return -1;
        }
        if (message_decoder.Check(this.serverRequest.recv_buf(), this.serverRequest.recv_buf_len()) <= 0) {
            this.setSysErrCode(-2);
            this.setSysErrMsg("Received Invalid Message");
            return -2;
        }
        message_decoder decoder = new message_decoder(this.serverRequest.recv_buf());
        if (encoder.seq() != decoder.seq()) {
            this.setSysErrCode(-1);
            this.setSysErrMsg("Received Message SEQ(" + decoder.seq() + ") isn't Equal to Sent Message SEQ(" + encoder.seq() + ").");
            return -1;
        }
        this.setStatus(decoder.status());
        if (0 != decoder.status()) {
            this.setErrCode(decoder.status());
            this.getErrorInfoFromTlv0x3(decoder);
        } else {
            String json;
            Integer riskLevel;
            String plus;
            String ptPin = decoder.GetString(16);
            if ("******".equals(ptPin)) {
                ptPin = null;
            }
            result.setPin(ptPin);
            if (null != ptPin && !ptPin.isEmpty()) {
                try {
                    result.setCookies("pt_pin=" + URLEncoder.encode(ptPin, "UTF-8") + "; pt_key=" + ptKey + ";");
                }
                catch (UnsupportedEncodingException e) {
                    this.setSysErrCode(-5);
                    this.setSysErrMsg("URLEncoder for pin(" + ptPin + ") failed: " + e.getMessage());
                    return -5;
                }
            } else {
                result.setCookies("");
            }
            Integer userLevel = decoder.GetInt32(97);
            if (null != userLevel) {
                result.setUserLevel(userLevel);
            }
            if (null != (plus = decoder.GetString(98))) {
                result.setPlus(plus);
            }
            if (null != (riskLevel = decoder.GetInt32(99))) {
                result.setRiskLevel(riskLevel);
            }
            if (null != (json = decoder.GetString(53))) {
                result.setJson(json);
            }
        }
        return 0;
    }

    public VerifyH5LoginResult verifyH5Login(int appId, String ptKey, ClientInfo clientInfo, boolean isNeedJsonValue) {
        this.clearErr();
        VerifyH5LoginResult result = new VerifyH5LoginResult();
        int ret = this.verifyH5Login(appId, ptKey, clientInfo, result, isNeedJsonValue);
        if (0 == ret && this.getStatus() == 0) {
            return result;
        }
        return null;
    }

    public VerifyH5LoginResult interVerifyH5Login(int appId, String ptKey, ClientInfo clientInfo, boolean isNeedJsonValue) {
        String json;
        Integer riskLevel;
        String plus;
        this.clearErr();
        if (ptKey == null || ptKey.equals("")) {
            this.setSysErrCode(-4);
            this.setSysErrMsg("Input Parameter Error: a4 is empty or null!");
            return null;
        }
        if (0 != this.checkClientInfo(clientInfo)) {
            this.setSysErrCode(-4);
            this.setSysErrMsg("Input Parameter Error: some fields in clientInfo is null");
            return null;
        }
        if (appId <= 0) {
            this.setSysErrCode(-4);
            this.setSysErrMsg("Input Parameter Error: appId is less than 0");
            return null;
        }
        if (ptKey.length() >= 4096) {
            this.setSysErrCode(-7);
            this.setSysErrMsg("Too long pt_key: " + ptKey);
            return null;
        }
        short cmd = 20;
        short sub_cmd = 2;
        String verifyA4ServiceName = kInterMVerifyServiceName;
        if (ptKey.startsWith("app_open") || ptKey.startsWith("fake_")) {
            verifyA4ServiceName = kInterOpenVerifyServiceName;
            sub_cmd = 4;
        }
        message_encoder encoder = new message_encoder(2048);
        encoder.set_uid(0L);
        encoder.set_partition(0);
        encoder.set_seq(0);
        encoder.set_client_ip(util.string_to_ip(clientInfo.getClientIp()));
        encoder.set_cmd(cmd);
        encoder.set_sub_cmd(sub_cmd);
        encoder.set_app_id((short)appId);
        tlv_0x8 t8 = new tlv_0x8();
        t8.Encode(appId, clientInfo.getClient(), clientInfo.getOsVersion(), clientInfo.getClientVersion(), clientInfo.getScreen(), clientInfo.getAppName(), clientInfo.getNetworkType(), clientInfo.getArea(), clientInfo.getUuid(), 1, clientInfo.getBuild(), clientInfo.getPartner());
        encoder.AddByteArray(8, t8.value(), t8.len());
        encoder.AddString(169, clientInfo.getClientIp());
        encoder.AddString(46, ptKey);
        int needType = isNeedJsonValue ? 1 : 0;
        encoder.AddInt32(68, needType);
        encoder.AddString(104, clientInfo.getLang());
        int interface_id = report_agent.service_cmd_to_interface_id(cmd, sub_cmd);
        int ret = this.serverRequest.request(interface_id, encoder, verifyA4ServiceName, appId, this._default_setting.getServerTimeOut());
        if (ret != 0) {
            this.setSysErrCode(ret);
            this.setSysErrMsg(this.serverRequest.exception_msg());
            return null;
        }
        if (message_decoder.Check(this.serverRequest.recv_buf(), this.serverRequest.recv_buf_len()) <= 0) {
            this.setSysErrCode(-2);
            this.setSysErrMsg("Received Invalid Message");
            return null;
        }
        message_decoder decoder = new message_decoder(this.serverRequest.recv_buf());
        if (encoder.seq() != decoder.seq()) {
            this.setSysErrCode(-1);
            this.setSysErrMsg("Received Message SEQ(" + decoder.seq() + ") isn't Equal to Sent Message SEQ(" + encoder.seq() + ").");
            return null;
        }
        this.setStatus(decoder.status());
        if (0 != decoder.status()) {
            this.setErrCode(decoder.status());
            this.getErrorInfoFromTlv0x3(decoder);
            return null;
        }
        VerifyH5LoginResult result = new VerifyH5LoginResult();
        String ptPin = decoder.GetString(16);
        if ("******".equals(ptPin)) {
            ptPin = null;
        }
        result.setPin(ptPin);
        if (null != ptPin && !ptPin.isEmpty()) {
            try {
                result.setCookies("pt_pin=" + URLEncoder.encode(ptPin, "UTF-8") + "; pt_key=" + ptKey + ";");
            }
            catch (UnsupportedEncodingException e) {
                this.setSysErrCode(-5);
                this.setSysErrMsg("URLEncoder for pin(" + ptPin + ") failed: " + e.getMessage());
                return null;
            }
        } else {
            result.setCookies("");
        }
        Integer userLevel = decoder.GetInt32(97);
        if (null != userLevel) {
            result.setUserLevel(userLevel);
        }
        if (null != (plus = decoder.GetString(98))) {
            result.setPlus(plus);
        }
        if (null != (riskLevel = decoder.GetInt32(99))) {
            result.setRiskLevel(riskLevel);
        }
        if (null != (json = decoder.GetString(53))) {
            result.setJson(json);
        }
        return result;
    }

    public VerifyH5LoginResult interVerifyH5Login(String ptPin, int appId, String ptKey, ClientInfo clientInfo) {
        this.clearErr();
        if (ptPin == null || ptPin.equals("")) {
            this.setSysErrCode(-4);
            this.setSysErrMsg("Input Parameter Error: pt_pin is empty or null!");
            return null;
        }
        if (ptPin.length() >= 2048) {
            this.setSysErrCode(-6);
            this.setSysErrMsg("Too long pt_pin: " + ptPin);
            return null;
        }
        VerifyH5LoginResult result = this.interVerifyH5Login(appId, ptKey, clientInfo, false);
        if (null == result) {
            return null;
        }
        if (!ptPin.equals(result.getPin())) {
            this.setStatus(94);
            this.setErrCode(94);
            this.setErrMsg("A4 Not Exists");
            this.setUserErrMsg("A4 Not Exists");
            return null;
        }
        return result;
    }

    public int verifySid(String sid, int appId, VerifySidResult result) {
        this.clearErr();
        if (sid == null || sid.equals("")) {
            this.setSysErrCode(-4);
            this.setSysErrMsg("Input Parameter Error: sid is empty or null!");
            return -4;
        }
        if (appId <= 0) {
            this.setSysErrCode(-4);
            this.setSysErrMsg("Input Parameter Error: appId is less than 0");
            return -4;
        }
        short cmd = 9;
        short sub_cmd = 4;
        message_encoder encoder = new message_encoder(2048);
        encoder.set_uid(0L);
        encoder.set_seq(0);
        encoder.set_cmd(cmd);
        encoder.set_sub_cmd(sub_cmd);
        encoder.set_app_id((short)appId);
        encoder.AddString(49, sid);
        int interface_id = report_agent.service_cmd_to_interface_id(cmd, sub_cmd);
        int ret = this.serverRequest.request(interface_id, encoder, kSidVerifyServiceName, appId, this._default_setting.getServerTimeOut());
        if (ret != 0) {
            this.setSysErrCode(ret);
            this.setSysErrMsg(this.serverRequest.exception_msg());
            return -1;
        }
        if (message_decoder.Check(this.serverRequest.recv_buf(), this.serverRequest.recv_buf_len()) <= 0) {
            this.setSysErrCode(-2);
            this.setSysErrMsg("Received Invalid Message");
            return -2;
        }
        message_decoder decoder = new message_decoder(this.serverRequest.recv_buf());
        if (encoder.seq() != decoder.seq()) {
            this.setSysErrCode(-1);
            this.setSysErrMsg("Received Message SEQ(" + decoder.seq() + ") isn't Equal to Sent Message SEQ(" + encoder.seq() + ").");
            return -1;
        }
        this.setStatus(decoder.status());
        if (0 != decoder.status()) {
            this.setErrCode(decoder.status());
            this.getErrorInfoFromTlv0x3(decoder);
        } else {
            String json = decoder.GetString(53);
            result.setJson(json);
        }
        return 0;
    }

    public VerifySidResult verifySid(String sid, int appId) {
        VerifySidResult result = new VerifySidResult();
        int ret = this.verifySid(sid, appId, result);
        if (0 == ret && this.getStatus() == 0) {
            return result;
        }
        return null;
    }

    public int logoutH5Login(int appId, String ptKey, ClientInfo clientInfo) {
        return this.logoutH5LoginByCommand(appId, ptKey, clientInfo, 6, 10, kMLoginServiceName);
    }

    public int interLogoutH5Login(int appId, String ptKey, ClientInfo clientInfo) {
        return this.logoutH5LoginByCommand(appId, ptKey, clientInfo, 23, 4, kInterMLoginServiceName);
    }

    private int logoutH5LoginByCommand(int appId, String ptKey, ClientInfo clientInfo, int cmd, int sub_cmd, String serviceName) {
        this.clearErr();
        if (ptKey == null || ptKey.equals("")) {
            this.setSysErrCode(-4);
            this.setSysErrMsg("Input Parameter Error: a4 is empty or null!");
            return -4;
        }
        if (0 != this.checkClientInfo(clientInfo)) {
            this.setSysErrCode(-4);
            this.setSysErrMsg("Input Parameter Error: some fields in clientInfo is null");
            return -4;
        }
        if (appId <= 0) {
            this.setSysErrCode(-4);
            this.setSysErrMsg("Input Parameter Error: appId is less than 0");
            return -4;
        }
        if (ptKey.length() >= 4096) {
            this.setSysErrCode(-7);
            this.setSysErrMsg("Too long pt_key: " + ptKey);
            return -7;
        }
        message_encoder encoder = new message_encoder(2048);
        encoder.set_uid(0L);
        encoder.set_partition(0);
        encoder.set_seq(0);
        encoder.set_client_ip(util.string_to_ip(clientInfo.getClientIp()));
        encoder.set_cmd((short)cmd);
        encoder.set_sub_cmd((short)sub_cmd);
        encoder.set_app_id((short)appId);
        tlv_0x8 t8 = new tlv_0x8();
        t8.Encode(appId, clientInfo.getClient(), clientInfo.getOsVersion(), clientInfo.getClientVersion(), clientInfo.getScreen(), clientInfo.getAppName(), clientInfo.getNetworkType(), clientInfo.getArea(), clientInfo.getUuid(), 1, clientInfo.getBuild(), clientInfo.getPartner());
        encoder.AddByteArray(8, t8.value(), t8.len());
        encoder.AddString(169, clientInfo.getClientIp());
        encoder.AddString(4, "");
        encoder.AddString(46, ptKey);
        encoder.AddString(104, clientInfo.getLang());
        int interface_id = report_agent.service_cmd_to_interface_id(cmd, sub_cmd);
        int ret = this.serverRequest.request(interface_id, encoder, serviceName, appId, this._default_setting.getServerTimeOut());
        if (ret != 0) {
            this.setSysErrCode(ret);
            this.setSysErrMsg(this.serverRequest.exception_msg());
            return -1;
        }
        if (message_decoder.Check(this.serverRequest.recv_buf(), this.serverRequest.recv_buf_len()) <= 0) {
            this.setSysErrCode(-2);
            this.setSysErrMsg("Received Invalid Message");
            return -2;
        }
        message_decoder decoder = new message_decoder(this.serverRequest.recv_buf());
        if (encoder.seq() != decoder.seq()) {
            this.setSysErrCode(-1);
            this.setSysErrMsg("Received Message SEQ(" + decoder.seq() + ") isn't Equal to Sent Message SEQ(" + encoder.seq() + ").");
            return -1;
        }
        this.setStatus(decoder.status());
        if (0 != decoder.status()) {
            this.setErrCode(decoder.status());
            this.getErrorInfoFromTlv0x3(decoder);
        }
        return 0;
    }

    public GainLoginModeResult gainLoginMode(int appId, String wsKey, ClientInfo clientInfo) {
        this.clearErr();
        if (wsKey == null || wsKey.equals("")) {
            this.setSysErrCode(-4);
            this.setSysErrMsg("Input Parameter Error: a2 is empty or null!");
            return null;
        }
        if (0 != this.checkClientInfo(clientInfo)) {
            this.setSysErrCode(-4);
            this.setSysErrMsg("Input Parameter Error: some fields in clientInfo is null");
            return null;
        }
        if (appId <= 0) {
            this.setSysErrCode(-4);
            this.setSysErrMsg("Input Parameter Error: appId is less than 0");
            return null;
        }
        if (wsKey.length() >= 4096) {
            this.setSysErrCode(-7);
            this.setSysErrMsg("Too long app wskey: " + wsKey);
            return null;
        }
        short cmd = 3;
        short sub_cmd = 4;
        message_encoder encoder = new message_encoder(2048);
        encoder.set_uid(0L);
        encoder.set_seq(0);
        encoder.set_client_ip(util.string_to_ip(clientInfo.getClientIp()));
        encoder.set_cmd(cmd);
        encoder.set_sub_cmd(sub_cmd);
        encoder.set_app_id((short)appId);
        tlv_0x8 t8 = new tlv_0x8();
        t8.Encode(appId, clientInfo.getClient(), clientInfo.getOsVersion(), clientInfo.getClientVersion(), clientInfo.getScreen(), clientInfo.getAppName(), clientInfo.getNetworkType(), clientInfo.getArea(), clientInfo.getUuid(), 1, clientInfo.getBuild(), clientInfo.getPartner());
        encoder.AddByteArray(8, t8.value(), t8.len());
        encoder.AddString(169, clientInfo.getClientIp());
        tlv_0xa ta = new tlv_0xa();
        ta.Encode(wsKey);
        encoder.AddByteArray(10, ta.value(), ta.len());
        int interface_id = report_agent.service_cmd_to_interface_id(cmd, sub_cmd);
        int ret = this.serverRequest.request(interface_id, encoder, kLoginTypeServiceName, appId, this._default_setting.getServerTimeOut());
        if (ret != 0) {
            this.setSysErrCode(ret);
            this.setSysErrMsg(this.serverRequest.exception_msg());
            return null;
        }
        if (message_decoder.Check(this.serverRequest.recv_buf(), this.serverRequest.recv_buf_len()) <= 0) {
            this.setSysErrCode(-2);
            this.setSysErrMsg("Received Invalid Message");
            return null;
        }
        message_decoder decoder = new message_decoder(this.serverRequest.recv_buf());
        if (encoder.seq() != decoder.seq()) {
            this.setSysErrCode(-1);
            this.setSysErrMsg("Received Message SEQ(" + decoder.seq() + ") isn't Equal to Sent Message SEQ(" + encoder.seq() + ").");
            return null;
        }
        this.setStatus(decoder.status());
        GainLoginModeResult result = new GainLoginModeResult();
        if (0 != decoder.status()) {
            this.setErrCode(decoder.status());
            this.getErrorInfoFromTlv0x3(decoder);
            return null;
        }
        message_byte_array_result result_0x50 = decoder.GetByteArrayByReference(80);
        if (null == result_0x50) {
            this.setSysErrCode(-3);
            this.setSysErrMsg("Decode Received Message Failed");
            return null;
        }
        tlv_0x50 t50 = new tlv_0x50();
        if (0 != t50.Decode(result_0x50.buf(), result_0x50.pos(), result_0x50.len())) {
            this.setSysErrCode(-3);
            this.setSysErrMsg("Decode Received Message Failed");
            return null;
        }
        result.setType(t50.type());
        message_byte_array_result result_0x1d = decoder.GetByteArrayByReference(29);
        if (null == result_0x1d) {
            this.setSysErrCode(-3);
            this.setSysErrMsg("Decode Received Message Failed");
            return null;
        }
        tlv_0x1d t1d = new tlv_0x1d();
        if (0 != t1d.Decode(result_0x1d.buf(), result_0x1d.pos(), result_0x1d.len())) {
            this.setSysErrCode(-3);
            this.setSysErrMsg("Decode Received Message Failed");
            return null;
        }
        result.setAccessToken(t1d.getAccessToken());
        result.setOpenid(t1d.getOpenid());
        result.setRefreshToken(t1d.getRefreshToken());
        String unionid = decoder.GetString(89);
        result.setUnionid(unionid);
        String userInfo = decoder.GetString(148);
        result.setUserInfo(userInfo);
        return result;
    }

    public GainLoginModeResult gainMLoginMode(int appId, String ptKey, ClientInfo clientInfo) {
        this.clearErr();
        if (ptKey == null || ptKey.equals("")) {
            this.setSysErrCode(-4);
            this.setSysErrMsg("Input Parameter Error: a4 is empty or null!");
            return null;
        }
        if (0 != this.checkClientInfo(clientInfo)) {
            this.setSysErrCode(-4);
            this.setSysErrMsg("Input Parameter Error: some fields in clientInfo is null");
            return null;
        }
        if (appId <= 0) {
            this.setSysErrCode(-4);
            this.setSysErrMsg("Input Parameter Error: appId is less than 0");
            return null;
        }
        if (ptKey.length() >= 4096) {
            this.setSysErrCode(-7);
            this.setSysErrMsg("Too long pt_key: " + ptKey);
            return null;
        }
        short cmd = 3;
        short sub_cmd = 6;
        message_encoder encoder = new message_encoder(2048);
        encoder.set_uid(0L);
        encoder.set_seq(0);
        encoder.set_client_ip(util.string_to_ip(clientInfo.getClientIp()));
        encoder.set_cmd(cmd);
        encoder.set_sub_cmd(sub_cmd);
        encoder.set_app_id((short)appId);
        tlv_0x8 t8 = new tlv_0x8();
        t8.Encode(appId, clientInfo.getClient(), clientInfo.getOsVersion(), clientInfo.getClientVersion(), clientInfo.getScreen(), clientInfo.getAppName(), clientInfo.getNetworkType(), clientInfo.getArea(), clientInfo.getUuid(), 1, clientInfo.getBuild(), clientInfo.getPartner());
        encoder.AddByteArray(8, t8.value(), t8.len());
        encoder.AddString(169, clientInfo.getClientIp());
        encoder.AddString(46, ptKey);
        int interface_id = report_agent.service_cmd_to_interface_id(cmd, sub_cmd);
        int ret = this.serverRequest.request(interface_id, encoder, kLoginTypeServiceName, appId, this._default_setting.getServerTimeOut());
        if (ret != 0) {
            this.setSysErrCode(ret);
            this.setSysErrMsg(this.serverRequest.exception_msg());
            return null;
        }
        if (message_decoder.Check(this.serverRequest.recv_buf(), this.serverRequest.recv_buf_len()) <= 0) {
            this.setSysErrCode(-2);
            this.setSysErrMsg("Received Invalid Message");
            return null;
        }
        message_decoder decoder = new message_decoder(this.serverRequest.recv_buf());
        if (encoder.seq() != decoder.seq()) {
            this.setSysErrCode(-1);
            this.setSysErrMsg("Received Message SEQ(" + decoder.seq() + ") isn't Equal to Sent Message SEQ(" + encoder.seq() + ").");
            return null;
        }
        this.setStatus(decoder.status());
        GainLoginModeResult result = new GainLoginModeResult();
        if (0 != decoder.status()) {
            this.setErrCode(decoder.status());
            this.getErrorInfoFromTlv0x3(decoder);
            return null;
        }
        message_byte_array_result result_0x50 = decoder.GetByteArrayByReference(80);
        if (null == result_0x50) {
            this.setSysErrCode(-3);
            this.setSysErrMsg("Decode Received Message Failed");
            return null;
        }
        tlv_0x50 t50 = new tlv_0x50();
        if (0 != t50.Decode(result_0x50.buf(), result_0x50.pos(), result_0x50.len())) {
            this.setSysErrCode(-3);
            this.setSysErrMsg("Decode Received Message Failed");
            return null;
        }
        result.setType(t50.type());
        message_byte_array_result result_0x1d = decoder.GetByteArrayByReference(29);
        if (null == result_0x1d) {
            this.setSysErrCode(-3);
            this.setSysErrMsg("Decode Received Message Failed");
            return null;
        }
        tlv_0x1d t1d = new tlv_0x1d();
        if (0 != t1d.Decode(result_0x1d.buf(), result_0x1d.pos(), result_0x1d.len())) {
            this.setSysErrCode(-3);
            this.setSysErrMsg("Decode Received Message Failed");
            return null;
        }
        result.setAccessToken(t1d.getAccessToken());
        result.setOpenid(t1d.getOpenid());
        result.setRefreshToken(t1d.getRefreshToken());
        String unionid = decoder.GetString(89);
        result.setUnionid(unionid);
        String userInfo = decoder.GetString(148);
        result.setUserInfo(userInfo);
        return result;
    }

    public VerifyPcLoginResult verifyPcLogin(int appId, String ticketPc, ClientInfo clientInfo) {
        return this.verifyPcLoginByCommand(appId, ticketPc, clientInfo, 3, 5, kPcVerifyServiceName);
    }

    public VerifyPcLoginResult interVerifyPcLogin(int appId, String ticketPc, ClientInfo clientInfo) {
        return this.verifyPcLoginByCommand(appId, ticketPc, clientInfo, 20, 5, kInterPcVerifyServiceName);
    }

    private VerifyPcLoginResult verifyPcLoginByCommand(int appId, String ticketPc, ClientInfo clientInfo, int cmd, int sub_cmd, String serviceName) {
        String json;
        Integer riskLevel;
        String plus;
        this.clearErr();
        if (null == ticketPc || null == clientInfo) {
            this.setSysErrCode(-4);
            this.setSysErrMsg("Input Parameter Error: pin or wskey or clientInfo is null");
            return null;
        }
        if (0 != this.checkClientInfo(clientInfo)) {
            this.setSysErrCode(-4);
            this.setSysErrMsg("Input Parameter Error: some fields in clientInfo is null");
            return null;
        }
        if (appId <= 0) {
            this.setSysErrCode(-4);
            this.setSysErrMsg("Input Parameter Error: appId is less than 0");
            return null;
        }
        if (ticketPc.length() >= 4096) {
            this.setSysErrCode(-7);
            this.setSysErrMsg("Too long pc thor: " + ticketPc);
            return null;
        }
        message_encoder encoder = new message_encoder(2048);
        encoder.set_uid(0L);
        encoder.set_seq(0);
        encoder.set_client_ip(util.string_to_ip(clientInfo.getClientIp()));
        encoder.set_cmd((short)cmd);
        encoder.set_sub_cmd((short)sub_cmd);
        encoder.set_app_id((short)appId);
        tlv_0x8 t8 = new tlv_0x8();
        t8.Encode(appId, clientInfo.getClient(), clientInfo.getOsVersion(), clientInfo.getClientVersion(), clientInfo.getScreen(), clientInfo.getAppName(), clientInfo.getNetworkType(), clientInfo.getArea(), clientInfo.getUuid(), 1, clientInfo.getBuild(), clientInfo.getPartner());
        encoder.AddByteArray(8, t8.value(), t8.len());
        encoder.AddString(169, clientInfo.getClientIp());
        encoder.AddString(95, ticketPc);
        encoder.AddString(104, clientInfo.getLang());
        int interface_id = report_agent.service_cmd_to_interface_id(cmd, sub_cmd);
        int ret = this.serverRequest.request(interface_id, encoder, serviceName, appId);
        if (ret != 0) {
            this.setSysErrCode(ret);
            this.setSysErrMsg(this.serverRequest.exception_msg());
            return null;
        }
        if (message_decoder.Check(this.serverRequest.recv_buf(), this.serverRequest.recv_buf_len()) <= 0) {
            this.setSysErrCode(-2);
            this.setSysErrMsg("Received Invalid Message");
            return null;
        }
        message_decoder decoder = new message_decoder(this.serverRequest.recv_buf());
        if (encoder.seq() != decoder.seq()) {
            this.setSysErrCode(-1);
            this.setSysErrMsg("Received Message SEQ(" + decoder.seq() + ") isn't Equal to Sent Message SEQ(" + encoder.seq() + ").");
            return null;
        }
        this.setStatus(decoder.status());
        VerifyPcLoginResult result = new VerifyPcLoginResult();
        if (0 != decoder.status()) {
            this.setErrCode(decoder.status());
            this.getErrorInfoFromTlv0x3(decoder);
            return null;
        }
        String pin = decoder.GetString(16);
        if (pin == null || pin.equals("")) {
            return null;
        }
        result.setPin(pin);
        Integer userLevel = decoder.GetInt32(97);
        if (null != userLevel) {
            result.setUserLevel(userLevel);
        }
        if (null != (plus = decoder.GetString(98))) {
            result.setPlus(plus);
        }
        if (null != (riskLevel = decoder.GetInt32(99))) {
            result.setRiskLevel(riskLevel);
        }
        if (null != (json = decoder.GetString(53))) {
            result.setJson(json);
        }
        return result;
    }

    public VerifySmartLoginResult verifySmartLogin(int appId, String ticketSmart, ClientInfo clientInfo) {
        this.clearErr();
        if (null == ticketSmart || null == clientInfo) {
            this.setSysErrCode(-4);
            this.setSysErrMsg("Input Parameter Error: pin or wskey or clientInfo is null");
            return null;
        }
        if (0 != this.checkClientInfo(clientInfo)) {
            this.setSysErrCode(-4);
            this.setSysErrMsg("Input Parameter Error: some fields in clientInfo is null");
            return null;
        }
        if (appId <= 0) {
            this.setSysErrCode(-4);
            this.setSysErrMsg("Input Parameter Error: appId is less than 0");
            return null;
        }
        if (ticketSmart.length() >= 4096) {
            this.setSysErrCode(-7);
            this.setSysErrMsg("Too long smart ticket: " + ticketSmart);
            return null;
        }
        short cmd = 17;
        short sub_cmd = 2;
        message_encoder encoder = new message_encoder(2048);
        encoder.set_uid(0L);
        encoder.set_seq(0);
        encoder.set_client_ip(util.string_to_ip(clientInfo.getClientIp()));
        encoder.set_cmd(cmd);
        encoder.set_sub_cmd(sub_cmd);
        encoder.set_app_id((short)appId);
        tlv_0x8 t8 = new tlv_0x8();
        t8.Encode(appId, clientInfo.getClient(), clientInfo.getOsVersion(), clientInfo.getClientVersion(), clientInfo.getScreen(), clientInfo.getAppName(), clientInfo.getNetworkType(), clientInfo.getArea(), clientInfo.getUuid(), 1, clientInfo.getBuild(), clientInfo.getPartner());
        encoder.AddByteArray(8, t8.value(), t8.len());
        encoder.AddString(169, clientInfo.getClientIp());
        if (ticketSmart.startsWith("smart_")) {
            encoder.AddString(10, ticketSmart);
        } else {
            tlv_0xa ta = new tlv_0xa();
            ta.Encode(ticketSmart);
            encoder.AddByteArray(10, ta.value(), ta.len());
        }
        int interface_id = report_agent.service_cmd_to_interface_id(cmd, sub_cmd);
        int ret = this.serverRequest.request(interface_id, encoder, kSmartVerifyServiceName, appId);
        if (ret != 0) {
            this.setSysErrCode(ret);
            this.setSysErrMsg(this.serverRequest.exception_msg());
            return null;
        }
        if (message_decoder.Check(this.serverRequest.recv_buf(), this.serverRequest.recv_buf_len()) <= 0) {
            this.setSysErrCode(-2);
            this.setSysErrMsg("Received Invalid Message");
            return null;
        }
        message_decoder decoder = new message_decoder(this.serverRequest.recv_buf());
        if (encoder.seq() != decoder.seq()) {
            this.setSysErrCode(-1);
            this.setSysErrMsg("Received Message SEQ(" + decoder.seq() + ") isn't Equal to Sent Message SEQ(" + encoder.seq() + ").");
            return null;
        }
        this.setStatus(decoder.status());
        if (0 != decoder.status()) {
            this.setErrCode(decoder.status());
            this.getErrorInfoFromTlv0x3(decoder);
            return null;
        }
        String pin = decoder.GetString(16);
        if (null != pin && !pin.isEmpty()) {
            String json;
            Integer riskLevel;
            String plus;
            VerifySmartLoginResult result = new VerifySmartLoginResult();
            result.setPin(pin);
            Integer userLevel = decoder.GetInt32(97);
            if (null != userLevel) {
                result.setUserLevel(userLevel);
            }
            if (null != (plus = decoder.GetString(98))) {
                result.setPlus(plus);
            }
            if (null != (riskLevel = decoder.GetInt32(99))) {
                result.setRiskLevel(riskLevel);
            }
            if (null != (json = decoder.GetString(53))) {
                result.setJson(json);
            }
            return result;
        }
        return null;
    }

    public VerifyISVLoginResult verifyISVLogin(int appId, String token, ClientInfo clientInfo) {
        this.clearErr();
        if (null == token || null == clientInfo) {
            this.setSysErrCode(-4);
            this.setSysErrMsg("Input Parameter Error: pin or wskey or clientInfo is null");
            return null;
        }
        if (0 != this.checkClientInfo(clientInfo)) {
            this.setSysErrCode(-4);
            this.setSysErrMsg("Input Parameter Error: some fields in clientInfo is null");
            return null;
        }
        if (appId <= 0) {
            this.setSysErrCode(-4);
            this.setSysErrMsg("Input Parameter Error: appId is less than 0");
            return null;
        }
        if (token.length() >= 4096) {
            this.setSysErrCode(-7);
            this.setSysErrMsg("Too long ISV token: " + token);
            return null;
        }
        short cmd = 25;
        short sub_cmd = 2;
        message_encoder encoder = new message_encoder(2048);
        encoder.set_uid(0L);
        encoder.set_seq(0);
        encoder.set_client_ip(util.string_to_ip(clientInfo.getClientIp()));
        encoder.set_cmd(cmd);
        encoder.set_sub_cmd(sub_cmd);
        encoder.set_app_id((short)appId);
        tlv_0x8 t8 = new tlv_0x8();
        t8.Encode(appId, clientInfo.getClient(), clientInfo.getOsVersion(), clientInfo.getClientVersion(), clientInfo.getScreen(), clientInfo.getAppName(), clientInfo.getNetworkType(), clientInfo.getArea(), clientInfo.getUuid(), 1, clientInfo.getBuild(), clientInfo.getPartner());
        encoder.AddByteArray(8, t8.value(), t8.len());
        encoder.AddString(169, clientInfo.getClientIp());
        encoder.AddString(106, token);
        int interface_id = report_agent.service_cmd_to_interface_id(cmd, sub_cmd);
        int ret = this.serverRequest.request(interface_id, encoder, kISVVerifyServiceName, appId);
        if (ret != 0) {
            this.setSysErrCode(ret);
            this.setSysErrMsg(this.serverRequest.exception_msg());
            return null;
        }
        if (message_decoder.Check(this.serverRequest.recv_buf(), this.serverRequest.recv_buf_len()) <= 0) {
            this.setSysErrCode(-2);
            this.setSysErrMsg("Received Invalid Message");
            return null;
        }
        message_decoder decoder = new message_decoder(this.serverRequest.recv_buf());
        if (encoder.seq() != decoder.seq()) {
            this.setSysErrCode(-1);
            this.setSysErrMsg("Received Message SEQ(" + decoder.seq() + ") isn't Equal to Sent Message SEQ(" + encoder.seq() + ").");
            return null;
        }
        this.setStatus(decoder.status());
        if (0 != decoder.status()) {
            this.setErrCode(decoder.status());
            this.getErrorInfoFromTlv0x3(decoder);
            return null;
        }
        String pin = decoder.GetString(16);
        if (null != pin && !pin.isEmpty()) {
            VerifyISVLoginResult result = new VerifyISVLoginResult();
            result.setPin(pin);
            return result;
        }
        return null;
    }

    public VerifyKplLoginResult verifyKplLogin(int appId, String kplKey, KplClientInfo clientInfo) {
        this.clearErr();
        if (null == kplKey || null == clientInfo) {
            this.setSysErrCode(-4);
            this.setSysErrMsg("Input Parameter Error: kplKey or clientInfo is null");
            return null;
        }
        if (appId <= 0) {
            this.setSysErrCode(-4);
            this.setSysErrMsg("Input Parameter Error: appId is less than 0");
            return null;
        }
        if (kplKey.length() >= 4096) {
            this.setSysErrCode(-7);
            this.setSysErrMsg("Too long kepler key: " + kplKey);
            return null;
        }
        short cmd = 772;
        short sub_cmd = 1;
        message_encoder encoder = new message_encoder(2048);
        encoder.set_uid(0L);
        encoder.set_seq(0);
        encoder.set_client_ip(util.string_to_ip(clientInfo.getClientIp()));
        encoder.set_cmd(cmd);
        encoder.set_sub_cmd(sub_cmd);
        encoder.set_app_id((short)appId);
        encoder.AddString(5, kplKey);
        Tlv0x8 t8 = TypeConvertKpl.ClientInfo2Tlv0x8(clientInfo);
        encoder.AddString(169, clientInfo.getClientIp());
        encoder.AddByteArray(8, t8.value(), t8.len());
        int interface_id = report_agent.service_cmd_to_interface_id(cmd, sub_cmd);
        int ret = this.serverRequest.request(interface_id, encoder, kKplVerifyServiceName, appId);
        if (ret != 0) {
            this.setSysErrCode(ret);
            this.setSysErrMsg(this.serverRequest.exception_msg());
            return null;
        }
        if (message_decoder.Check(this.serverRequest.recv_buf(), this.serverRequest.recv_buf_len()) <= 0) {
            this.setSysErrCode(-2);
            this.setSysErrMsg("Received Invalid Message");
            return null;
        }
        message_decoder decoder = new message_decoder(this.serverRequest.recv_buf());
        if (encoder.seq() != decoder.seq()) {
            this.setSysErrCode(-1);
            this.setSysErrMsg("Received Message SEQ(" + decoder.seq() + ") isn't Equal to Sent Message SEQ(" + encoder.seq() + ").");
            return null;
        }
        this.setStatus(decoder.status());
        if (0 != decoder.status()) {
            this.setErrCode(decoder.status());
            this.getErrorInfoFromTlv0x3(decoder);
            return null;
        }
        VerifyKplLoginResult result = new VerifyKplLoginResult();
        String pin = decoder.GetString(16);
        if (null == pin || pin.isEmpty()) {
            this.setSysErrCode(-3);
            this.setSysErrMsg("pin is empty");
            return null;
        }
        result.setPin(pin);
        Long shopId = decoder.GetInt64(1);
        if (shopId == null) {
            this.setSysErrCode(-3);
            this.setSysErrMsg("shopId is empty");
            return null;
        }
        result.setVenderId(shopId);
        return result;
    }

    public VerifyWQTokenResult verifyWQAuthTokn(int appId, String biz, String authToken, ClientInfo clientInfo) {
        String json;
        Integer riskLevel;
        String plus;
        int interface_id;
        int ret;
        this.clearErr();
        int cmd = 3;
        int sub_cmd = 7;
        if (null == biz || null == authToken || null == clientInfo) {
            this.setSysErrCode(-4);
            this.setSysErrMsg("Input Parameter Error: biz or authToken or clientInfo is null");
            return null;
        }
        if (0 != this.checkClientInfo(clientInfo)) {
            this.setSysErrCode(-4);
            this.setSysErrMsg("Input Parameter Error: some fields in clientInfo is null");
            return null;
        }
        if (appId <= 0) {
            this.setSysErrCode(-4);
            this.setSysErrMsg("Input Parameter Error: appId is less than 0");
            return null;
        }
        if (biz.length() >= 2048) {
            this.setSysErrCode(-6);
            this.setSysErrMsg("Too long WQ biz: " + biz);
            return null;
        }
        if (authToken.length() >= 4096) {
            this.setSysErrCode(-7);
            this.setSysErrMsg("Too long wq_auth_token: " + authToken);
            return null;
        }
        message_encoder encoder = new message_encoder(2048);
        encoder.set_uid(0L);
        encoder.set_seq(0);
        encoder.set_client_ip(util.string_to_ip(clientInfo.getClientIp()));
        encoder.set_cmd((short)cmd);
        encoder.set_sub_cmd((short)sub_cmd);
        encoder.set_app_id((short)appId);
        tlv_0x8 t8 = new tlv_0x8();
        t8.Encode(appId, clientInfo.getClient(), clientInfo.getOsVersion(), clientInfo.getClientVersion(), clientInfo.getScreen(), clientInfo.getAppName(), clientInfo.getNetworkType(), clientInfo.getArea(), clientInfo.getUuid(), 1, clientInfo.getBuild(), clientInfo.getPartner());
        encoder.AddByteArray(8, t8.value(), t8.len());
        encoder.AddString(169, clientInfo.getClientIp());
        encoder.AddString(118, authToken);
        if (null != biz) {
            encoder.AddString(117, biz);
        }
        if ((ret = this.serverRequest.request(interface_id = report_agent.service_cmd_to_interface_id(cmd, sub_cmd), encoder, kWQVerifyServiceName, appId)) != 0) {
            this.setSysErrCode(ret);
            this.setSysErrMsg(this.serverRequest.exception_msg());
            return null;
        }
        if (message_decoder.Check(this.serverRequest.recv_buf(), this.serverRequest.recv_buf_len()) <= 0) {
            this.setSysErrCode(-2);
            this.setSysErrMsg("Received Invalid Message");
            return null;
        }
        message_decoder decoder = new message_decoder(this.serverRequest.recv_buf());
        if (encoder.seq() != decoder.seq()) {
            this.setSysErrCode(-1);
            this.setSysErrMsg("Received Message SEQ(" + decoder.seq() + ") isn't Equal to Sent Message SEQ(" + encoder.seq() + ").");
            return null;
        }
        this.setStatus(decoder.status());
        VerifyWQTokenResult result = new VerifyWQTokenResult();
        if (0 != decoder.status()) {
            this.setErrCode(decoder.status());
            this.getErrorInfoFromTlv0x3(decoder);
            return null;
        }
        String pin = decoder.GetString(16);
        if (pin == null || pin.isEmpty()) {
            this.setSysErrCode(-3);
            this.setSysErrMsg("pin is empty");
            return null;
        }
        result.setPin(pin);
        Integer isDefaultPin = decoder.GetInt32(121);
        if (null != isDefaultPin) {
            if (isDefaultPin.equals(0)) {
                result.setIsDefaultPin(false);
            } else {
                result.setIsDefaultPin(true);
            }
        } else {
            this.setSysErrCode(-3);
            this.setSysErrMsg("isDefaultPin is empty");
            return null;
        }
        Integer userLevel = decoder.GetInt32(97);
        if (null != userLevel) {
            result.setUserLevel(userLevel);
        }
        if (null != (plus = decoder.GetString(98))) {
            result.setPlus(plus);
        }
        if (null != (riskLevel = decoder.GetInt32(99))) {
            result.setRiskLevel(riskLevel);
        }
        if (null != (json = decoder.GetString(53))) {
            result.setJson(json);
        }
        return result;
    }

    public VerifyOpenAccessTokenResult verifyOpenAccessToken(int appId, String accessToken, String openid, String scope) {
        this.clearErr();
        int cmd = 1024;
        int sub_cmd = 9;
        if (null == accessToken || accessToken.isEmpty() || null == openid || openid.isEmpty() || null == scope || scope.isEmpty()) {
            this.setSysErrCode(-4);
            this.setSysErrMsg("Input Parameter Error: accessToken or openid or scope is null or empty");
            return null;
        }
        if (appId <= 0) {
            this.setSysErrCode(-4);
            this.setSysErrMsg("Input Parameter Error: appId is less than 0");
            return null;
        }
        message_encoder encoder = new message_encoder(2048);
        encoder.set_uid(0L);
        encoder.set_seq(0);
        encoder.set_cmd((short)cmd);
        encoder.set_sub_cmd((short)sub_cmd);
        tlv_0x77 t77 = new tlv_0x77();
        t77.Encode(accessToken);
        encoder.AddByteArray(119, t77.value(), t77.len());
        tlv_0x58 t58 = new tlv_0x58();
        t58.Encode(openid);
        encoder.AddByteArray(88, t58.value(), t58.len());
        tlv_0x82 t82 = new tlv_0x82();
        t82.Encode(scope);
        encoder.AddByteArray(130, t82.value(), t82.len());
        int interface_id = report_agent.service_cmd_to_interface_id(cmd, sub_cmd);
        int ret = this.serverRequest.request(interface_id, encoder, kJOVerifyATServiceName, appId);
        if (ret != 0) {
            this.setSysErrCode(ret);
            this.setSysErrMsg(this.serverRequest.exception_msg());
            return null;
        }
        if (message_decoder.Check(this.serverRequest.recv_buf(), this.serverRequest.recv_buf_len()) <= 0) {
            this.setSysErrCode(-2);
            this.setSysErrMsg("Received Invalid Message");
            return null;
        }
        message_decoder decoder = new message_decoder(this.serverRequest.recv_buf());
        if (encoder.seq() != decoder.seq()) {
            this.setSysErrCode(-1);
            this.setSysErrMsg("Received Message SEQ(" + decoder.seq() + ") isn't Equal to Sent Message SEQ(" + encoder.seq() + ").");
            return null;
        }
        message_byte_array_result result_0x3 = decoder.GetByteArrayByReference(3);
        if (null == result_0x3) {
            this.setSysErrCode(-3);
            this.setSysErrMsg("Decode TlvType ErrorMsg Failed");
            return null;
        }
        tlv_0x3 t3 = new tlv_0x3();
        if (0 != t3.Decode(result_0x3.buf(), result_0x3.pos(), result_0x3.len())) {
            this.setSysErrCode(-3);
            this.setSysErrMsg("Decode Received Message Failed");
            return null;
        }
        this.setStatus(t3.err_code());
        this.setErrCode(t3.err_code());
        if (0 != t3.err_code()) {
            this.setErrMsg(t3.err_str());
            this.setUserErrMsg(t3.user_err_str());
            return null;
        }
        VerifyOpenAccessTokenResult result = new VerifyOpenAccessTokenResult();
        String pin = decoder.GetString(16);
        if (pin == null || pin.isEmpty()) {
            this.setSysErrCode(-3);
            this.setSysErrMsg("pin is empty");
            return null;
        }
        result.setPin(pin);
        return result;
    }

    private void getErrorInfoFromTlv0x3(message_decoder decoder) {
        if (null == decoder) {
            return;
        }
        message_byte_array_result result_0x3 = decoder.GetByteArrayByReference(3);
        if (null != result_0x3) {
            tlv_0x3 t3 = new tlv_0x3();
            if (0 != t3.Decode(result_0x3.buf(), result_0x3.pos(), result_0x3.len())) {
                this.setSysErrCode(-3);
                this.setSysErrMsg("Decode Received Message Failed");
                return;
            }
            this.setErrMsg(t3.err_str());
            this.setUserErrMsg(t3.user_err_str());
        }
    }

    public VerifyThirdLoginResult verifyFXLogin(int appId, String fxKey, ClientInfo clientInfo) {
        String json;
        Integer riskLevel;
        String plus;
        this.clearErr();
        if (null == fxKey || null == clientInfo) {
            this.setSysErrCode(-4);
            this.setSysErrMsg("Input Parameter Error: pin or wskey or clientInfo is null");
            return null;
        }
        if (0 != this.checkClientInfo(clientInfo)) {
            this.setSysErrCode(-4);
            this.setSysErrMsg("Input Parameter Error: some fields in clientInfo is null");
            return null;
        }
        if (appId <= 0) {
            this.setSysErrCode(-4);
            this.setSysErrMsg("Input Parameter Error: appId is less than 0");
            return null;
        }
        short cmd = 38;
        short sub_cmd = 3;
        message_encoder encoder = new message_encoder(2048);
        encoder.set_uid(0L);
        encoder.set_seq(0);
        encoder.set_client_ip(util.string_to_ip(clientInfo.getClientIp()));
        encoder.set_cmd(cmd);
        encoder.set_sub_cmd(sub_cmd);
        encoder.set_app_id((short)appId);
        tlv_0x8 t8 = new tlv_0x8();
        t8.Encode(appId, clientInfo.getClient(), clientInfo.getOsVersion(), clientInfo.getClientVersion(), clientInfo.getScreen(), clientInfo.getAppName(), clientInfo.getNetworkType(), clientInfo.getArea(), clientInfo.getUuid(), 1, clientInfo.getBuild(), clientInfo.getPartner());
        encoder.AddByteArray(8, t8.value(), t8.len());
        encoder.AddString(169, clientInfo.getClientIp());
        encoder.AddString(145, fxKey);
        encoder.AddString(4, "");
        int interface_id = report_agent.service_cmd_to_interface_id(cmd, sub_cmd);
        int ret = this.serverRequest.request(interface_id, encoder, kMThirdVerifyServiceName, appId);
        if (ret != 0) {
            this.setSysErrCode(ret);
            this.setSysErrMsg(this.serverRequest.exception_msg());
            return null;
        }
        if (message_decoder.Check(this.serverRequest.recv_buf(), this.serverRequest.recv_buf_len()) <= 0) {
            this.setSysErrCode(-2);
            this.setSysErrMsg("Received Invalid Message");
            return null;
        }
        message_decoder decoder = new message_decoder(this.serverRequest.recv_buf());
        if (encoder.seq() != decoder.seq()) {
            this.setSysErrCode(-1);
            this.setSysErrMsg("Received Message SEQ(" + decoder.seq() + ") isn't Equal to Sent Message SEQ(" + encoder.seq() + ").");
            return null;
        }
        this.setStatus(decoder.status());
        if (0 != decoder.status()) {
            this.setErrCode(decoder.status());
            message_byte_array_result result_0x3 = decoder.GetByteArrayByReference(3);
            if (null != result_0x3) {
                tlv_0x3 t3 = new tlv_0x3();
                if (0 != t3.Decode(result_0x3.buf(), result_0x3.pos(), result_0x3.len())) {
                    this.setSysErrCode(-3);
                    this.setSysErrMsg("Decode Received Message Failed");
                    return null;
                }
                this.setErrMsg(t3.err_str());
                this.setUserErrMsg(t3.user_err_str());
            }
            return null;
        }
        VerifyThirdLoginResult result = new VerifyThirdLoginResult();
        String pin = decoder.GetString(16);
        if (null == pin || pin.isEmpty()) {
            return null;
        }
        result.setPin(pin);
        Integer userLevel = decoder.GetInt32(97);
        if (null != userLevel) {
            result.setUserLevel(userLevel);
        }
        if (null != (plus = decoder.GetString(98))) {
            result.setPlus(plus);
        }
        if (null != (riskLevel = decoder.GetInt32(99))) {
            result.setRiskLevel(riskLevel);
        }
        if (null != (json = decoder.GetString(53))) {
            result.setJson(json);
        }
        return result;
    }

    public GetAppLoginResultAccount GetAppLoginAccount(int appId, String wskey, ClientInfo clientInfo) {
        this.clearErr();
        if (null == wskey || null == clientInfo) {
            this.setSysErrCode(-4);
            this.setSysErrMsg("Input Parameter Error: wskey or clientInfo is null");
            return null;
        }
        if (0 != this.checkClientInfo(clientInfo)) {
            this.setSysErrCode(-4);
            this.setSysErrMsg("Input Parameter Error: some fields in clientInfo is null");
            return null;
        }
        if (appId <= 0) {
            this.setSysErrCode(-4);
            this.setSysErrMsg("Input Parameter Error: appId is less than 0");
            return null;
        }
        if (wskey.length() >= 4096) {
            this.setSysErrCode(-7);
            this.setSysErrMsg("Too long wskey: " + wskey);
            return null;
        }
        short cmd = 3;
        short sub_cmd = 9;
        message_encoder encoder = new message_encoder(2048);
        encoder.set_uid(0L);
        encoder.set_partition(0);
        encoder.set_seq(0);
        encoder.set_client_ip(util.string_to_ip(clientInfo.getClientIp()));
        encoder.set_cmd(cmd);
        encoder.set_sub_cmd(sub_cmd);
        encoder.set_app_id((short)appId);
        tlv_0x8 t8 = new tlv_0x8();
        t8.Encode(appId, clientInfo.getClient(), clientInfo.getOsVersion(), clientInfo.getClientVersion(), clientInfo.getScreen(), clientInfo.getAppName(), clientInfo.getNetworkType(), clientInfo.getArea(), clientInfo.getUuid(), 1, clientInfo.getBuild(), clientInfo.getPartner());
        encoder.AddByteArray(8, t8.value(), t8.len());
        encoder.AddString(169, clientInfo.getClientIp());
        tlv_0xa ta = new tlv_0xa();
        ta.Encode(wskey);
        encoder.AddByteArray(10, ta.value(), ta.len());
        int interface_id = report_agent.service_cmd_to_interface_id(cmd, sub_cmd);
        int ret = this.serverRequest.request(interface_id, encoder, kVerifyServiceExName, appId);
        this.setSysErrMsg(this.serverRequest.exception_msg());
        if (ret != 0) {
            this.setSysErrCode(ret);
            this.setSysErrMsg(this.serverRequest.exception_msg());
            return null;
        }
        if (message_decoder.Check(this.serverRequest.recv_buf(), this.serverRequest.recv_buf_len()) <= 0) {
            this.setSysErrCode(-2);
            this.setSysErrMsg("Received Invalid Message");
            return null;
        }
        message_decoder decoder = new message_decoder(this.serverRequest.recv_buf());
        if (encoder.seq() != decoder.seq()) {
            this.setSysErrCode(-1);
            this.setSysErrMsg("Received Message SEQ(" + decoder.seq() + ") isn't Equal to Sent Message SEQ(" + encoder.seq() + ").");
            return null;
        }
        this.setStatus(decoder.status());
        if (0 != decoder.status()) {
            this.setErrCode(decoder.status());
            this.getErrorInfoFromTlv0x3(decoder);
            return null;
        }
        String pin = decoder.GetString(16);
        if (null != pin && !pin.isEmpty()) {
            GetAppLoginResultAccount result = new GetAppLoginResultAccount();
            result.setPin(pin);
            String account = decoder.GetString(24);
            if (null != account) {
                result.setAccount(account);
            }
            return result;
        }
        return null;
    }
}

